/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.database;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class EFReportDBMT {
    public String connFileName;
    public JSONObject connObject = new JSONObject();
    Map<Integer, Map<Integer, List<Object>>> dataList = new HashMap<Integer, Map<Integer, List<Object>>>();
    Map<String, Boolean> hasFindMap = new HashMap<String, Boolean>();

    public boolean setConnFileName(String fileName) {
        try {
            String str;
            this.connFileName = fileName;
            File jsonFile = new File(fileName);
            FileInputStream fis = new FileInputStream(jsonFile);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader in = new BufferedReader(inputStreamReader);
            StringBuffer sb = new StringBuffer();
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
            in.close();
            String jsonText = sb.toString();
            JSONArray jsonArray = JSONArray.parseArray((String)jsonText);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                String name = object.getString("name");
                this.connObject.put(name, (Object)object);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean forClassWithFirst(String type) {
        try {
            if ("SQLITE".equals(type)) {
                Class.forName("org.sqlite.JDBC");
            } else if ("ORACLE".equals(type)) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
            } else if ("MYSQL".equals(type)) {
                Class.forName("com.mysql.cj.jdbc.Driver");
            } else if ("SQL SERVER".equals(type)) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            } else if ("POSTGRESQL".equals(type)) {
                Class.forName("org.postgresql.Driver");
            } else if ("ODBC".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("EXCEL".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("ACCESS".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("SAP".equals(type)) {
                Class.forName("com.sap.db.jdbc.Driver");
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getConnURL(String connName) {
        try {
            JSONObject object = this.connObject.getJSONObject(connName);
            return object.getString("url");
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDataByMultiThread(String info) {
        JSONArray returnInfo = new JSONArray();
        try {
            JSONArray connArray = JSONObject.parseArray((String)info);
            JSONArray dsArray = new JSONArray();
            int dsIndex = 0;
            for (int i = 0; i < connArray.size(); ++i) {
                JSONObject connObj = connArray.getJSONObject(i);
                String connName = connObj.getString("connName");
                JSONObject conObj = this.connObject.getJSONObject(connName);
                String type = conObj.getString("type");
                String url = conObj.getString("url");
                String username = conObj.getString("username");
                String password = conObj.getString("password");
                if (!this.hasFindMap.containsKey(type)) {
                    this.forClassWithFirst(type);
                    this.hasFindMap.put(type, true);
                }
                JSONArray dsList = connObj.getJSONArray("dsList");
                for (int j = 0; j < dsList.size(); ++j) {
                    JSONObject sqlObj = dsList.getJSONObject(j);
                    String sql = sqlObj.getString("sql");
                    String dsName = sqlObj.getString("dsName");
                    JSONObject dsObj = new JSONObject();
                    dsObj.put("connName", (Object)connName);
                    dsObj.put("dsIndex", (Object)dsIndex);
                    dsObj.put("sql", (Object)sql);
                    dsObj.put("dsName", (Object)dsName);
                    dsObj.put("url", (Object)url);
                    dsObj.put("username", (Object)username);
                    dsObj.put("password", (Object)password);
                    dsArray.add((Object)dsObj);
                    ++dsIndex;
                }
            }
            ExecutorService executor = Executors.newFixedThreadPool(dsArray.size());
            ArrayList<CompletableFuture<Map>> futures = new ArrayList<CompletableFuture<Map>>();
            for (int i = 0; i < dsArray.size(); ++i) {
                JSONObject dsObject = dsArray.getJSONObject(i);
                CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        return new Task(dsObject.getInteger("dsIndex"), dsObject.getString("dsName"), dsObject.getString("url"), dsObject.getString("username"), dsObject.getString("password"), dsObject.getString("sql")).call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, executor);
                futures.add(future);
            }
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            CompletionStage allDataListFuture = allFutures.thenApply(v -> futures.stream().map(future -> (Map)future.join()).collect(Collectors.toList()));
            List allDataList = (List)((CompletableFuture)allDataListFuture).get();
            for (int i = 0; i < allDataList.size(); ++i) {
                Map threadRes = (Map)allDataList.get(i);
                JSONObject dsInfo = (JSONObject)threadRes.get("dsInfo");
                if (dsInfo.size() == 0) continue;
                returnInfo.add(threadRes.get("dsInfo"));
                this.dataList.put((Integer)threadRes.get("dsIndex"), (Map)threadRes.get("dsResult"));
            }
            executor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnInfo.toString();
    }

    public byte[] getBlobValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        byte[] res = (byte[])fieldData.get(recordIndex);
        return res;
    }

    public byte[] getClobValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        byte[] res = (byte[])fieldData.get(recordIndex);
        return res;
    }

    public String getStringValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        String res = (String)fieldData.get(recordIndex);
        return res;
    }

    public byte[] getBytesValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        byte[] res = (byte[])fieldData.get(recordIndex);
        return res;
    }

    public int getIntValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        int res = (Integer)fieldData.get(recordIndex);
        return res;
    }

    public long getLongValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        String data = (String)fieldData.get(recordIndex);
        Long res = Long.parseLong(data);
        return res;
    }

    public double getDoubleValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        Double res = (Double)fieldData.get(recordIndex);
        return res;
    }

    public long getDateValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        Long res = (Long)fieldData.get(recordIndex);
        return res;
    }

    public long getDateTimeValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        Long res = (Long)fieldData.get(recordIndex);
        return res;
    }

    public boolean getBooleanValueByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        List<Object> fieldData = dsData.get(fieldIndex);
        Boolean res = (boolean)((Boolean)fieldData.get(recordIndex));
        return res;
    }

    public boolean getIsNullByIndex(int dsIndex, int fieldIndex, int recordIndex) {
        Map<Integer, List<Object>> dsData = this.dataList.get(dsIndex);
        if (dsData == null) {
            return true;
        }
        List<Object> fieldData = dsData.get(fieldIndex);
        if (fieldData == null) {
            return true;
        }
        Object res = fieldData.get(recordIndex);
        return res == null;
    }

    public void releaseData() {
        this.dataList.clear();
    }

    public static void main(String[] args) throws Exception {
        EFReportDBMT efReportDBMT = new EFReportDBMT();
        String connFile = "D:" + File.separator + "conn.json";
        StringBuffer sb = new StringBuffer();
        sb.append("[{\"connName\":\"hefeng\",\"connURL\":\"jdbc:mysql://124.71.218.83:3306/uic_hefeng?useSSL=false&useUnicode=true&characterEncoding=utf-8\",\"dsList\":[{\"sql\":\"SELECT c.dept_name,SUBSTRING(concat(DATE_FORMAT(a.date,'%Y%m%d'),''),3) as \u4e8b\u6545\u65e5\u671f");
        sb.append(",REPLACE(a.accident_type,'\u4e8b\u6545','') as \u4e8b\u6545\u7c7b\u578b,a.schedule as \u8fdb\u5ea6\\nFROM uic_safety_accidents a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nwhere a.biz_dept IN (1457886524741734402,1457886728656211969,");
        sb.append("1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,");
        sb.append("1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,");
        sb.append("1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,");
        sb.append("1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nand DATE_FORMAT(a.date,'%Y') = DATE_FORMAT('2023-08-12','%Y')\\nORDER BY DATE_FORMAT(a.date,'%Y-%m-%d') DESC\",\"dsName\":\"\u4e8b\u6545\u660e\u7ec6\u8f6e\u64ad\"},");
        sb.append("{\"sql\":\"SELECT COUNT(*) as \u4eba\u6570\\nFROM uic_user_litt a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nwhere a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,");
        sb.append("1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\n\",\"dsName\":\"\u4eba\u6570\"},{\"sql\":\"SELECT COUNT(*) as \u4eba\u6570,a.ybx\\nFROM uic_user_litt a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nwhere a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,");
        sb.append("1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY a.ybx\\n\",\"dsName\":\"\u4fdd\u9669\u5206\u5e03\u4eba\u6570\"},{\"sql\":\"SELECT a.project_team_name,concat(ifnull(ROUND(a.\u5229\u6da6/b.\u6210\u672c*100,2),0))as \u5229\u6da6\u7387 FROM\\n(SELECT a.biz_dept,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,date_format(a.cost_date,'%Y-%m') as \u6708\u4efd,\\nconcat(ROUND(a.mon_profit_amount,2),'')as \u5229\u6da6\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') =date_format(a.cost_date,'%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept))a\\n\\nLEFT JOIN (SELECT a.biz_dept,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,date_format(a.cost_date,'%Y-%m') as \u6708\u4efd,\\nconcat(ROUND(a.mon_pay_amount,2),'')as \u6210\u672c\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') =date_format(a.cost_date,'%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) b on a.biz_dept = b.biz_dept\\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE a.project_team_name != '\u84dd\u9886\u8d44\u6e90\u90e8'\\nORDER BY ROUND(a.\u5229\u6da6/b.\u6210\u672c*100,2) asc\\n\",\"dsName\":\"\u5229\u6da6\u7387\u6392\u540d\"},{\"sql\":\"SELECT a.dept_name FROM (SELECT a.parent_id,b.dept_name,group_concat(a.id separator ',')as id FROM uic_dept a \\nLEFT JOIN uic_dept b on a.parent_id =b.id\\nWHERE a.is_deleted = 0\\nand b.dept_name is not NULL\\nand b.dept_name LIKE '\u8fd0\u8425%\u90e8'\\nGROUP BY a.parent_id\\nUNION ALL\\nSELECT a.parent_id,'\u5b89\u5fbd\u548c\u4e30'as dept_name,group_concat(a.id separator ',')as id FROM uic_dept a \\nWHERE a.is_deleted = 0\\nand a.dept_category = 4\\nand a.dept_name is not NULL\\nand a.dept_name not LIKE '\u8003\u8bd5\u4f7f\u7528\u9879\u76ee\u7ec4'\\nand a.dept_name not LIKE '1'\\nUNION ALL\\nSELECT a.parent_id,a.dept_name,a.id FROM uic_dept a \\n) a \\n WHERE a.id = '1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697'\\nlimit 1\",\"dsName\":\"\u540d\u79f0\"},{\"sql\":\"\\nSELECT if('1' = 1,e.dept_name,c.dept_name) as project_team_name,ifnull(f.\u6570\u91cf,0)as \u6570\u91cf  \\nFROM\\nuic_dept a \\nLEFT JOIN uic_dept c on a.id = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nLEFT JOIN (SELECT if('1' = 1,e.dept_name,c.dept_name) as project_team_name,COUNT(*) AS \u6570\u91cf,a.biz_dept\\nFROM uic_safety_accidents a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nwhere a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nand DATE_FORMAT(a.date,'%Y') = DATE_FORMAT('2023-08-12','%Y')\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) f on a.id = f.biz_dept\\nwhere a.id IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nORDER BY f.\u6570\u91cf ASC\",\"dsName\":\"\u5de5\u4f24\u6b21\u6570\"},{\"sql\":\"SELECT '\u5229\u6da6' as \u7c7b\u578b,a.project_team_name,date_format(a.cost_date,'%Y-%m') as \u6708\u4efd,\\nconcat(ROUND(a.mon_profit_amount/10000,1),'')as \u91d1\u989d\\nFROM uic_cost a \\nWHERE date_format(a.cost_date,'%Y-%m') IN (SELECT * FROM(SELECT \\n\\tDATE_FORMAT(date_sub(DATE_FORMAT(DATE_SUB('2023-08-12', INTERVAL 12 MONTH),'%Y-%m-%d %H'),interval ( @s := @s - 1 ) MONTH),'%Y-%m')as \u65f6\u6bb5\\nfrom mysql.help_topic\\njoin (select @s:=1 ) c\\nLIMIT 12)a)\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY date_format(a.cost_date,'%Y-%m')\\n\\nUNION ALL\\n\\nSELECT '\u6536\u5165' as \u7c7b\u578b,a.project_team_name,date_format(a.cost_date,'%Y-%m') as \u6708\u4efd,\\nconcat(ROUND(a.mon_income_amount/10000,1),'')as \u91d1\u989d\\nFROM uic_cost a \\nWHERE date_format(a.cost_date,'%Y-%m') IN (SELECT * FROM(SELECT \\n\\tDATE_FORMAT(date_sub(DATE_FORMAT(DATE_SUB('2023-08-12', INTERVAL 12 MONTH),'%Y-%m-%d %H'),interval ( @i := @i - 1 ) MONTH),'%Y-%m')as \u65f6\u6bb5\\nfrom mysql.help_topic\\njoin (select @i:=1 ) c\\nLIMIT 12)a)\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY date_format(a.cost_date,'%Y-%m')\\n\\nUNION ALL\\n\\nSELECT '\u652f\u51fa' as \u7c7b\u578b,a.project_team_name,date_format(a.cost_date,'%Y-%m') as \u6708\u4efd");
        sb.append(",\\nconcat(ROUND(a.mon_pay_amount/10000,1),'')as \u91d1\u989d\\nFROM uic_cost a \\nWHERE date_format(a.cost_date,'%Y-%m') IN (SELECT * FROM(SELECT \\n\\tDATE_FORMAT(date_sub(DATE_FORMAT(DATE_SUB('2023-08-12', INTERVAL 12 MONTH),'%Y-%m-%d %H'),interval ( @u := @u - 1 ) MONTH),'%Y-%m')as \u65f6\u6bb5\\nfrom mysql.help_topic\\njoin (select @u:=1 ) c\\nLIMIT 12)a)\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY date_format(a.cost_date,'%Y-%m')\",\"dsName\":\"\u5f80\u6708\u6570\u636e\"},{\"sql\":\"SELECT a.biz_dept,\\na.project_team_name,\\nsum(a.\u521d\u7a3f\u91d1\u989d) AS \u521d\u7a3f\u91d1\u989d,\\nsum(a.\u5b9a\u7a3f\u91d1\u989d) AS \u5b9a\u7a3f\u91d1\u989d,\\nsum(a.\u5f00\u7968\u91d1\u989d) AS \u5f00\u7968\u91d1\u989d,\\nsum(a.\u5df2\u56de\u6b3e) AS \u5df2\u56de\u6b3e,\\nround(sum(a.\u5f85\u56de\u6b3e)/10000,1) AS \u5f85\u56de\u6b3e,\\na.\u8303\u56f4\\n FROM (SELECT a.biz_dept,\\nif('1' = 1,f.dept_name,c.dept_name) as project_team_name,\\ne.draft_first_money AS \u521d\u7a3f\u91d1\u989d,\\ne.draft_end_money AS \u5b9a\u7a3f\u91d1\u989d,\\ne.invoice_amount AS \u5f00\u7968\u91d1\u989d,\\na.actual_amount AS \u5df2\u56de\u6b3e,\\na.receive_amount AS \u5f85\u56de\u6b3e,\\nconcat(a.payment_ratio,'%')  AS \u56de\u6b3e\u7387,\\n  (CASE  WHEN (DATEDIFF(NOW(),a.receive_time)*1)<0 THEN '1\u4e2a\u6708\u5185' \\n \\t   WHEN (DATEDIFF(NOW(),a.receive_time)*1)<30 THEN '1-2\u4e2a\u6708'\\n   \\t   WHEN (DATEDIFF(NOW(),a.receive_time)*1)<60 THEN '\u8d85\u671f3\u4e2a\u6708'\\n   \\t   WHEN (DATEDIFF(NOW(),a.receive_time)*1)<90 THEN '\u8d85\u671f4\u4e2a\u6708'\\n   \\t   WHEN (DATEDIFF(NOW(),a.receive_time)*1)<120 THEN '\u8d85\u671f5\u4e2a\u6708'\\n   \\t   WHEN (DATEDIFF(NOW(),a.receive_time)*1)>120 THEN '\u8d85\u671f6\u4e2a\u6708'\\n\\t\\t\\t ELSE '\u672a\u8d85\u671f'\\n \\tEND ) AS \u8303\u56f4\\nFROM\\n\\tuic_contract_payment a\\nLEFT JOIN uic_dept c ON c.id = a.biz_dept \\nLEFT JOIN uic_dept f on c.parent_id = f.id\\nLEFT JOIN uic_bill e ON e.id = a.bill_id and e.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nLEFT JOIN uic_supplier b ON  e.supplier_id = b.id \\nLEFT JOIN (SELECT * FROM uic_contract a WHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) GROUP BY  a.supplier_id ) d ON d.supplier_id = a.supplier_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nand b.is_deleted = 0) a \\nWHERE a.\u8303\u56f4 != '1\u4e2a\u6708\u5185' and a.\u8303\u56f4 != '1-2\u4e2a\u6708' and a.\u8303\u56f4 != '\u672a\u8d85\u671f' \\nGROUP BY a.project_team_name,a.\u8303\u56f4\\nORDER BY sum(a.\u5f85\u56de\u6b3e) ASC\",\"dsName\":\"\u5f85\u4f1a\u6b3e\u8d85\u671f\u60c5\u51b5\"},{\"sql\":\"SELECT\\nif('1' = 1,f.dept_name,c.dept_name) as project_team_name,\\nsum(e.draft_first_money) AS \u521d\u7a3f\u91d1\u989d,\\nsum(e.draft_end_money) AS \u5b9a\u7a3f\u91d1\u989d,\\nsum(e.invoice_amount) AS \u5f00\u7968\u91d1\u989d,\\nsum(a.actual_amount) AS \u5df2\u56de\u6b3e,\\nrounD(sum(a.receive_amount)/10000,1) AS \u5f85\u56de\u6b3e,\\nconcat(a.payment_ratio,'%')  AS \u56de\u6b3e\u7387\\nFROM\\n\\tuic_contract_payment a\\nLEFT JOIN uic_dept c ON c.id = a.biz_dept\\nLEFT JOIN uic_dept f on c.parent_id = f.id\\nLEFT JOIN uic_bill e ON e.id = a.bill_id\\nLEFT JOIN uic_supplier b ON  e.supplier_id = b.id\\nLEFT JOIN (SELECT * FROM  uic_contract a GROUP BY  a.supplier_id ) d ON d.supplier_id = a.supplier_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nand b.is_deleted = 0\\nGROUP BY if('1' = 1 ,f.id,a.biz_dept)\\n\\tORDER BY sum(a.receive_amount) ASC\",\"dsName\":\"\u5f85\u56de\u6b3e\u6392\u540d\"},{\"sql\":\"SELECT COUNT(*) as \u4eba\u6570,a.xb\\nFROM uic_user_litt a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nwhere a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY a.xb\\n\",\"dsName\":\"\u6027\u522b\u5206\u5e03\"},{\"sql\":\"SELECT b.cost_id,b.cost_item_name,\\n\\nROUND(sum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) +sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)))as \u91d1\u989d\\n\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_item_id\\n\",\"dsName\":\"\u6210\u672c\u7ec4\u6210\"},{\"sql\":\"SELECT concat(a.monthOfday,'\u53f7')AS \u65e5\u671f,ROUND(ifnull(b.\u5229\u6da6,0),0)as \u5229\u6da6,'\u5229\u6da6' as \u7c7b\u522b\\nFROM ( SELECT 1 as monthOfday UNION ALL SELECT 2 as monthOfday UNION ALL\\nSELECT 3 as monthOfday UNION ALL\\nSELECT 4 as monthOfday UNION ALL\\nSELECT 5 as monthOfday UNION ALL\\nSELECT 6 as monthOfday UNION ALL\\nSELECT 7 as monthOfday UNION ALL\\nSELECT 8 as monthOfday UNION ALL\\nSELECT 9 as monthOfday UNION ALL\\nSELECT 10 as monthOfday UNION ALL\\nSELECT 11 as monthOfday UNION ALL\\nSELECT 12 as monthOfday UNION ALL\\nSELECT 13 as monthOfday UNION ALL\\nSELECT 14 as monthOfday UNION ALL\\nSELECT 15 as monthOfday UNION ALL\\nSELECT 16 as monthOfday UNION ALL\\nSELECT 17 as monthOfday UNION ALL\\nSELECT 18 as monthOfday UNION ALL\\nSELECT 19 as monthOfday UNION ALL\\nSELECT 20 as monthOfday UNION ALL\\nSELECT 21 as monthOfday UNION ALL\\nSELECT 22 as monthOfday UNION ALL\\nSELECT 23 as monthOfday UNION ALL\\nSELECT 24 as monthOfday UNION ALL\\nSELECT 25 as monthOfday UNION ALL\\nSELECT 26 as monthOfday UNION ALL\\nSELECT 27 as monthOfday UNION ALL\\nSELECT 28 as monthOfday UNION ALL\\nSELECT 29 as monthOfday UNION ALL\\nSELECT 30 as monthOfday UNION ALL\\nSELECT 31 as monthOfday) a\\n\\nLEFT JOIN (SELECT concat(d.\u65e5\u671f,'\u53f7')as \u65e5\u671f,ifnull(TRUNCATE(((ifnull(d.\u53d8\u52a8,0)+ifnull(c.\u603b\u91d1\u989d,0)) - ifnull(e.\u652f\u51fa,0)),2),0)As \u5229\u6da6\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,");
        sb.append("1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 != 0) d on b.cost_id = d.cost_id\\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 = 0) c on b.cost_id = c.cost_id\\nLEFT JOIN (SELECT b.cost_id,d.\u65e5\u671f,(ifnull(d.\u53d8\u52a8,0)+ifnull(c.\u603b\u91d1\u989d,0))as \u652f\u51fa\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 != 0) d on b.cost_id = d.cost_id\\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 = 0) c on b.cost_id = c.cost_id\\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY d.\u65e5\u671f) e on e.cost_id = b.cost_id and e.\u65e5\u671f = d.\u65e5\u671f\\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY d.\u65e5\u671f) b on concat(a.monthOfday,'\u53f7') = b.\u65e5\u671f\\nwhere a.monthOfday <= day(last_day('2023-08-12'))\\n\\nUNION ALL\\n\\nSELECT concat(a.monthOfday,'\u53f7')AS \u65e5\u671f,ROUND(ifnull(b.\u652f\u51fa,0),0)as \u5229\u6da6,'\u652f\u51fa' as \u7c7b\u522b\\nFROM ( SELECT 1 as monthOfday UNION ALL SELECT 2 as monthOfday UNION ALL\\nSELECT 3 as monthOfday UNION ALL\\nSELECT 4 as monthOfday UNION ALL\\nSELECT 5 as monthOfday UNION ALL\\nSELECT 6 as monthOfday UNION ALL\\nSELECT 7 as monthOfday UNION ALL\\nSELECT 8 as monthOfday UNION ALL\\nSELECT 9 as monthOfday UNION ALL\\nSELECT 10 as monthOfday UNION ALL\\nSELECT 11 as monthOfday UNION ALL\\nSELECT 12 as monthOfday UNION ALL\\nSELECT 13 as monthOfday UNION ALL\\nSELECT 14 as monthOfday UNION ALL\\nSELECT 15 as monthOfday UNION ALL\\nSELECT 16 as monthOfday UNION ALL\\nSELECT 17 as monthOfday UNION ALL\\nSELECT 18 as monthOfday UNION ALL\\nSELECT 19 as monthOfday UNION ALL\\nSELECT 20 as monthOfday UNION ALL\\nSELECT 21 as monthOfday UNION ALL\\nSELECT 22 as monthOfday UNION ALL\\nSELECT 23 as monthOfday UNION ALL\\nSELECT 24 as monthOfday UNION ALL\\nSELECT 25 as monthOfday UNION ALL\\nSELECT 26 as monthOfday UNION ALL\\nSELECT 27 as monthOfday UNION ALL\\nSELECT 28 as monthOfday UNION ALL\\nSELECT 29 as monthOfday UNION ALL\\nSELECT 30 as monthOfday UNION ALL\\nSELECT 31 as monthOfday) a\\n\\nLEFT JOIN (SELECT concat(d.\u65e5\u671f,'\u53f7')as \u65e5\u671f,e.\u652f\u51fa As \u652f\u51fa\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 != 0) d on b.cost_id = d.cost_id\\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,");
        sb.append("1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 = 0) c on b.cost_id = c.cost_id\\nLEFT JOIN (SELECT b.cost_id,d.\u65e5\u671f,(ifnull(d.\u53d8\u52a8,0)+ifnull(c.\u603b\u91d1\u989d,0))as \u652f\u51fa\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 != 0) d on b.cost_id = d.cost_id\\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 = 0) c on b.cost_id = c.cost_id\\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY d.\u65e5\u671f) e on e.cost_id = b.cost_id and e.\u65e5\u671f = d.\u65e5\u671f\\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY d.\u65e5\u671f) b on concat(a.monthOfday,'\u53f7') = b.\u65e5\u671f\\nwhere a.monthOfday <= day(last_day('2023-08-12'))\\n\\n\\nUNION ALL\\n\\nSELECT concat(a.monthOfday,'\u53f7')AS \u65e5\u671f,ROUND(ifnull(b.\u6536\u5165,0),0)as \u5229\u6da6,'\u6536\u5165' as \u7c7b\u522b\\nFROM ( SELECT 1 as monthOfday UNION ALL SELECT 2 as monthOfday UNION ALL\\nSELECT 3 as monthOfday UNION ALL\\nSELECT 4 as monthOfday UNION ALL\\nSELECT 5 as monthOfday UNION ALL\\nSELECT 6 as monthOfday UNION ALL\\nSELECT 7 as monthOfday UNION ALL\\nSELECT 8 as monthOfday UNION ALL\\nSELECT 9 as monthOfday UNION ALL\\nSELECT 10 as monthOfday UNION ALL\\nSELECT 11 as monthOfday UNION ALL\\nSELECT 12 as monthOfday UNION ALL\\nSELECT 13 as monthOfday UNION ALL\\nSELECT 14 as monthOfday UNION ALL\\nSELECT 15 as monthOfday UNION ALL\\nSELECT 16 as monthOfday UNION ALL\\nSELECT 17 as monthOfday UNION ALL\\nSELECT 18 as monthOfday UNION ALL\\nSELECT 19 as monthOfday UNION ALL\\nSELECT 20 as monthOfday UNION ALL\\nSELECT 21 as monthOfday UNION ALL\\nSELECT 22 as monthOfday UNION ALL\\nSELECT 23 as monthOfday UNION ALL\\nSELECT 24 as monthOfday UNION ALL\\nSELECT 25 as monthOfday UNION ALL\\nSELECT 26 as monthOfday UNION ALL\\nSELECT 27 as monthOfday UNION ALL\\nSELECT 28 as monthOfday UNION ALL\\nSELECT 29 as monthOfday UNION ALL\\nSELECT 30 as monthOfday UNION ALL\\nSELECT 31 as monthOfday) a\\n\\nLEFT JOIN (SELECT concat(d.\u65e5\u671f,'\u53f7')as \u65e5\u671f,ifnull(TRUNCATE(((ifnull(d.\u53d8\u52a8,0)+ifnull(c.\u603b\u91d1\u989d,0))),2),0)As \u6536\u5165\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 != 0) d on b.cost_id = d.cost_id\\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,");
        sb.append("1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 = 0) c on b.cost_id = c.cost_id\\nLEFT JOIN (SELECT b.cost_id,d.\u65e5\u671f,(ifnull(d.\u53d8\u52a8,0)+ifnull(c.\u603b\u91d1\u989d,0))as \u652f\u51fa\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 != 0) d on b.cost_id = d.cost_id\\nLEFT JOIN (SELECT *\\nFROM uic_cost a \\nLEFT JOIN (SELECT b.cost_id,\\n(DATE_FORMAT(b.cost_detail_date,'%d')+0) as \u65e5\u671f,\\nsum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) AS \u603b\u91d1\u989d,\\nsum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0))as \u53d8\u52a8\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_detail_date) b on a.id = b.cost_id\\nWHERE a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697) and b.\u53d8\u52a8 = 0) c on b.cost_id = c.cost_id\\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY d.\u65e5\u671f) e on e.cost_id = b.cost_id and e.\u65e5\u671f = d.\u65e5\u671f\\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT('2023-08-12','%Y-%m') \\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY d.\u65e5\u671f) b on concat(a.monthOfday,'\u53f7') = b.\u65e5\u671f\\nwhere a.monthOfday <= day(last_day('2023-08-12'))\\n\",\"dsName\":\"\u6298\u7ebf\u56fe\"},{\"sql\":\"SELECT DATE_FORMAT(a.cost_date,'%Y-%m') as \u6708\u4efd,'\u90e8\u95e8' as \u90e8\u95e8,'\u9879\u76ee\u7ec4'  as \u9879\u76ee\u7ec4,\\nROUND(sum(a.mon_target_amount),0) as \u76ee\u6807\u6536\u5165,\\nROUND(sum(a.mon_profit_target_amount),0)as \u76ee\u6807\u5229\u6da6,\\nROUND(sum(a.mon_pay_amount),0) as \u652f\u51fa,ROUND(sum(a.mon_income_amount),0)as \u6536\u5165,\\nROUND((sum(a.mon_income_amount) - sum(a.mon_pay_amount)),0) as \u5229\u6da6  \\nFROM uic_cost a \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT(now(),'%Y-%m')\\nGROUP BY DATE_FORMAT(a.cost_date,'%Y-%m')\\norder by DATE_FORMAT(a.cost_date,'%Y-%m') desc\",\"dsName\":\"\u6536\u5165\u4e0e\u5229\u6da6\u76ee\u6807\"},{\"sql\":\"SELECT b.cost_id,b.cost_item_name,\\n\\nROUND(sum(if(b.cost_item_type = 0 ,b.cost_detail_amount/day(last_day('2023-08-12')),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),2)as \u91d1\u989d\\n\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY b.cost_item_id\\n\",\"dsName\":\"\u6536\u5165\u7ec4\u6210\"},{\"sql\":\"select day(last_day('2023-08-12')) as \u672c\u6708\u5929\u6570,DATE_FORMAT('2023-08-12',' %m\u6708 ')as \u6708\u4efd,(DATE_FORMAT(CURDATE(),'%d')-1)as \u5f53\u524d\u59291,\\n(case DATE_FORMAT('2023-08-12','%Y-%M') when  DATE_FORMAT(CURDATE(),'%Y-%M') then (DATE_FORMAT(CURDATE(),'%d')-1) else day(last_day('2023-08-12')) end )as \u5f53\u524d\u5929, round((case DATE_FORMAT('2023-08-12','%Y-%M') when  DATE_FORMAT(CURDATE(),'%Y-%M') then (DATE_FORMAT(CURDATE(),'%d')-1) else day(last_day('2023-08-12')) end )/ day(last_day('2023-08-12'))*100 ,1)as \u8fdb\u5ea6,DATE_FORMAT(now(),'%Y-%m-%d') as \u5f53\u524d\u65e5\u671f\",\"dsName\":\"\u65f6\u95f4\"},{\"sql\":\"SELECT if('1' = 1,e.dept_name,c.dept_name) as project_team_name,ifnull(f.\u6570\u91cf,'')as \u6570\u91cf,ifnull(f.accident_type,'\u751f\u4ea7\u4e8b\u6545')as accident_type\\nFROM\\nuic_dept a \\nLEFT JOIN uic_dept c on a.id = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nLEFT JOIN (SELECT if('1' = 1,e.dept_name,c.dept_name) as project_team_name,COUNT(*) AS \u6570\u91cf,a.accident_type,a.biz_dept\\nFROM uic_safety_accidents a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nwhere a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nand DATE_FORMAT(a.date,'%Y') = DATE_FORMAT('2023-08-12','%Y')\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept),a.accident_type\\nORDER BY COUNT(*) ASC\\n) f on a.id = f.biz_dept\\nwhere a.id IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nand  if('1' = 1,e.dept_name,c.dept_name) != '\u90d1\u5dde\u5206\u516c\u53f8'\\nAND if('1' = 1,e.dept_name,c.dept_name) != '\u84dd\u9886\u8d44\u6e90\u90e8'\\nAND if('1' = 1,e.dept_name,c.dept_name) != '\u516c\u5171\u90e8\u95e8'\\nORDER BY FIELD(e.dept_name,'\u8fd0\u8425\u4e00\u90e8','\u8fd0\u8425\u4e8c\u90e8','\u8fd0\u8425\u4e09\u90e8','\u8fd0\u8425\u56db\u90e8','\u8fd0\u8425\u4e94\u90e8','\u8fd0\u8425\u516d\u90e8','\u8fd0\u8425\u4e03\u90e8','\u8fd0\u8425\u516b\u90e8','\u8fd0\u8425\u4e5d\u90e8') desc\",\"dsName\":\"\u662f\u5426\u662f\u5de5\u4f24\"},{\"sql\":\"SELECT DATE_FORMAT(a.cost_date,'%Y\u5e74%m\u6708')as \u6708\u4efd,DATE_FORMAT(concat(DATE_FORMAT(a.cost_date,'%Y-%m'),'-',if(DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT(NOW(),'%Y-%m'),(DAY(now())-01),day(LAST_DAY(a.cost_date)))),'%Y-%m-%d')AS \u65e5\u671f \\nFROM uic_cost a \\nGROUP BY DATE_FORMAT(a.cost_date,'%Y-%m')\\nORDER BY a.cost_date DESC\\n\\n\\n\",\"dsName\":\"\u6708\u4efd\u9009\u62e9\"},{\"sql\":\"SELECT a.project_team_name,ifnull(IF(a.\u603b\u91d1\u989d > 0,round((c.\u603b\u91d1\u989d/a.\u603b\u91d1\u989d)*100,0),round((2-c.\u603b\u91d1\u989d/a.\u603b\u91d1\u989d)*100,0)),0)as \u6536\u5165\u5b8c\u6210\u60c5\u51b5,ifnull(if(d.\u603b\u91d1\u989d>0,round(((c.\u603b\u91d1\u989d - b.\u603b\u91d1\u989d)/d.\u603b\u91d1\u989d)*100,0),round((2-(c.\u603b\u91d1\u989d - b.\u603b\u91d1\u989d)/d.\u603b\u91d1\u989d)*100,0)),0) as \u5229\u6da6\u5b8c\u6210\u60c5\u51b5\\n FROM (SELECT '\u6536\u5165\u76ee\u6807' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,ROUND(sum(a.mon_target_amount),0) as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept))a \\nLEFT JOIN (\\nSELECT '\u652f\u51fa' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),0)as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN uic_dept c on a.biz_dept = c.id \\nLEFT JOIN uic_dept e on c.parent_id = e.id \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) b on a.project_team_name = b.project_team_name\\n\\nLEFT JOIN (\\nSELECT '\u6536\u5165' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),0)as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) c on a.project_team_name = c.project_team_name\\n\\nLEFT JOIN (\\nSELECT '\u5229\u6da6\u76ee\u6807' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,ROUND(sum(a.mon_profit_target_amount),0) as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) d on a.project_team_name = d.project_team_name\\n\\nORDER BY if(d.\u603b\u91d1\u989d>0,round(((c.\u603b\u91d1\u989d - b.\u603b\u91d1\u989d)/d.\u603b\u91d1\u989d)*100,1),round((2-(c.\u603b\u91d1\u989d - b.\u603b\u91d1\u989d)/d.\u603b\u91d1\u989d)*100,1)) asc\",\"dsName\":\"\u6708\u5229\u6da6\u5b8c\u6210\u60c5\u51b5\u6392\u540d\"},{\"sql\":\"SELECT a.project_team_name,ifnull(round((c.\u603b\u91d1\u989d/a.\u603b\u91d1\u989d)*100,0),0)as \u6536\u5165\u5b8c\u6210\u60c5\u51b5,ifnull(round(((c.\u603b\u91d1\u989d - b.\u603b\u91d1\u989d)/d.\u603b\u91d1\u989d)*100,1),0) as \u5229\u6da6\u5b8c\u6210\u60c5\u51b5\\n FROM (SELECT '\u6536\u5165\u76ee\u6807' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,ROUND(sum(a.mon_target_amount),0) as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept))a \\nLEFT JOIN (\\nSELECT '\u652f\u51fa' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),0)as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN uic_dept c on a.biz_dept = c.id \\nLEFT JOIN uic_dept e on c.parent_id = e.id \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) b on a.project_team_name = b.project_team_name\\n\\nLEFT JOIN (\\nSELECT '\u6536\u5165' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),0)as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) c on a.project_team_name = c.project_team_name\\n\\nLEFT JOIN (\\nSELECT '\u5229\u6da6\u76ee\u6807' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,ROUND(sum(a.mon_profit_target_amount),0) as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) d on a.project_team_name = d.project_team_name\\nORDER BY round((c.\u603b\u91d1\u989d/a.\u603b\u91d1\u989d)*100,0) asc\",\"dsName\":\"\u6708\u6536\u5165\u5b8c\u6210\u60c5\u51b5\u6392\u540d\"},{\"sql\":\"\\nSELECT '\u652f\u51fa' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')-1),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),0)as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN uic_dept c on a.biz_dept = c.id \\nLEFT JOIN uic_dept e on c.parent_id = e.id \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)\\n\\nUNION ALL\\n\\nSELECT '\u6536\u5165' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')-1),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),0)as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN uic_dept c on a.biz_dept = c.id --\\nLEFT JOIN uic_dept e on c.parent_id = e.id --\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)\\n\\nUNION ALL\\n\\nSELECT '\u5229\u6da6\u76ee\u6807' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,ROUND(sum(a.mon_profit_target_amount),0) as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id --\\nLEFT JOIN uic_dept e on c.parent_id = e.id --\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)\\nUNION ALL\\n\\nSELECT '\u6536\u5165\u76ee\u6807' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,ROUND(sum(a.mon_target_amount),0) as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)\",\"dsName\":\"\u6708\u6536\u652f\u6392\u540d\"},{\"sql\":\"SELECT '\u652f\u51fa' as \u7c7b\u578b,a.project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)))as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\n\\nUNION ALL\\n\\nSELECT '\u6536\u5165' as \u7c7b\u578b,a.project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),0)as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\n\\nUNION ALL\\n\\nSELECT '\u5229\u6da6\u76ee\u6807' as \u7c7b\u578b,a.project_team_name,concat(ROUND(ROUND(sum(a.mon_profit_target_amount),0)/10000,1) ,'\u4e07\u5143') as \u603b\u91d1\u989d\\nFROM uic_cost a \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\n\\nUNION ALL\\n\\nSELECT '\u6536\u5165\u76ee\u6807' as \u7c7b\u578b,a.project_team_name,concat(ROUND(ROUND(sum(a.mon_target_amount),0)/10000,1) ,'\u4e07\u5143') as \u603b\u91d1\u989d\\nFROM uic_cost a \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\",\"dsName\":\"\u672c\u6708\u6536\u652f\"},{\"sql\":\"SELECT a.project_team_name,sum(IF(a.\u603b\u91d1\u989d > 0,round((c.\u603b\u91d1\u989d/a.\u603b\u91d1\u989d)*100,0),round((2-c.\u603b\u91d1\u989d/a.\u603b\u91d1\u989d)*100,0)))as \u6536\u5165\u5b8c\u6210\u60c5\u51b5,sum(if(d.\u603b\u91d1\u989d>0,round(((c.\u603b\u91d1\u989d - b.\u603b\u91d1\u989d)/d.\u603b\u91d1\u989d)*100,0),round((2-(c.\u603b\u91d1\u989d - b.\u603b\u91d1\u989d)/d.\u603b\u91d1\u989d)*100,0))) as \u5229\u6da6\u5b8c\u6210\u60c5\u51b5\\n FROM (SELECT '\u6536\u5165\u76ee\u6807' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,ROUND(sum(a.mon_target_amount),0) as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept))a \\nLEFT JOIN (\\nSELECT '\u652f\u51fa' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),0)as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN uic_dept c on a.biz_dept = c.id \\nLEFT JOIN uic_dept e on c.parent_id = e.id \\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 1\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) b on a.project_team_name = b.project_team_name\\n\\nLEFT JOIN (\\nSELECT '\u6536\u5165' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,\\nROUND(sum(if(b.cost_item_type = 0 ,(b.cost_detail_amount/day(last_day('2023-08-12')))*(day('2023-08-12')),0)) + sum(if(b.cost_item_type = 1 ,b.cost_detail_amount,0)),0)as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_cost_detail b on a.id = b.cost_id \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand b.cost_item_source = 0\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) c on a.project_team_name = c.project_team_name\\n\\nLEFT JOIN (\\nSELECT '\u5229\u6da6\u76ee\u6807' as \u7c7b\u578b,if('1' = 1,e.dept_name,a.project_team_name) as project_team_name,ROUND(sum(a.mon_profit_target_amount),0) as \u603b\u91d1\u989d\\nFROM uic_cost a \\nLEFT JOIN uic_dept c on a.biz_dept = c.id\\nLEFT JOIN uic_dept e on c.parent_id = e.id\\nWHERE date_format(a.cost_date,'%Y-%m') = date_format('2023-08-12','%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY if('1' = 1 ,e.id,a.biz_dept)) d on a.project_team_name = d.project_team_name\\n\",\"dsName\":\"\u76ee\u6807\u5b8c\u6210\u8fdb\u5ea6\"},{\"sql\":\"SELECT a.id,a.dept_name,a.BJ FROM (SELECT a.parent_id,b.dept_name,group_concat(a.id separator ',')as id,0 as BJ FROM uic_dept a \\nLEFT JOIN uic_dept b on a.parent_id =b.id\\nWHERE a.is_deleted = 0\\nand b.dept_name is not NULL\\nand b.dept_name LIKE '\u8fd0\u8425%\u90e8'\\nGROUP BY a.parent_id\\nUNION ALL\\nSELECT a.parent_id,'\u5b89\u5fbd\u548c\u4e30'as dept_name,group_concat(a.id separator ',')as id,1 as BJ FROM uic_dept a \\nWHERE a.is_deleted = 0\\nand a.dept_category = 4\\nand a.dept_name is not NULL\\nand a.dept_name not LIKE '\u8003\u8bd5\u4f7f\u7528\u9879\u76ee\u7ec4'\\nand a.dept_name not LIKE '1'\\n) a \\nORDER BY FIELD(a.dept_name,'\u5b89\u5fbd\u548c\u4e30','\u8fd0\u8425\u4e00\u90e8','\u8fd0\u8425\u4e8c\u90e8','\u8fd0\u8425\u4e09\u90e8','\u8fd0\u8425\u56db\u90e8','\u8fd0\u8425\u4e94\u90e8','\u8fd0\u8425\u516d\u90e8','\u8fd0\u8425\u4e03\u90e8','\u8fd0\u8425\u516b\u90e8','\u8fd0\u8425\u4e5d\u90e8')\\n\",\"dsName\":\"\u90e8\u95e8\"},{\"sql\":\"SELECT a.id,a.dept_name FROM uic_dept a \\nWHERE a.is_deleted = 0\\nand a.id IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\",\"dsName\":\"\u9879\u76ee\u7ec4\"},{\"sql\":\"SELECT DATE_FORMAT(a.cost_date,'%Y-%m') as \u6708\u4efd,'\u90e8\u95e8' as \u90e8\u95e8,'\u9879\u76ee\u7ec4'  as \u9879\u76ee\u7ec4,sum(a.mon_target_amount) as \u76ee\u6807\u6536\u5165,\\nsum(a.mon_profit_target_amount)as \u76ee\u6807\u5229\u6da6,sum(a.mon_pay_amount) as \u652f\u51fa,sum(a.mon_income_amount)as \u6536\u5165,(sum(a.mon_income_amount) - sum(a.mon_pay_amount)) as \u5229\u6da6  \\nFROM uic_cost a \\nWHERE DATE_FORMAT(a.cost_date,'%Y-%m') = DATE_FORMAT(now(),'%Y-%m')\\nand a.biz_dept IN (1457886524741734402,1457886728656211969,1457886850760790018,1457886957933645825,1457887056956968961,1457887923055579138,1457888057113923585,1457888724226387970,1457888891193241602,1457889030775484417,1457889166155034625,1457889292407779330,1457889448972759042,1457889873557958658,1457890250487476226,1457890482231160833,1457890915930583041,1457891102996541442,1457891323742760962,1457891455808811010,1457891557587791873,1457891711233536002,1457891842968236034,1457892399812423681,1478534425938522114,1479268119372410882,1542675903077756929,1542694660605030402,1542694791907717121,1542694922224742401,1542695106639900674,1542695345434210306,1542695427227332610,1543117297185554433,1543117431738826753,1543118217772367873,1543118380440059905,1543118756488773634,1543118840311939073,1543119133137272834,1543119245955661826,1543119379724599297,1543119831170121729,1543120080676683778,1543120158757847041,1543120261551849474,1544228533088346113,1586193161414369282,1635819430170611713,1635819641651613697)\\nGROUP BY DATE_FORMAT(a.cost_date,'%Y-%m')\\norder by DATE_FORMAT(a.cost_date,'%Y-%m') desc\",\"dsName\":\"\u9879\u76ee\u7ec4\u76ee\u6807\"}]}]");
        efReportDBMT.setConnFileName(connFile);
        long begin = System.currentTimeMillis();
        efReportDBMT.getDataByMultiThread(sb.toString());
        long end = System.currentTimeMillis();
        System.out.println("\u603b\u8017\u65f6:" + (end - begin));
        System.out.println(efReportDBMT.dataList);
    }

    class Task
    implements Callable<Map<String, Object>> {
        private final int dsIndex;
        private final String dsName;
        private final String sql;
        private final String url;
        private final String username;
        private final String password;

        public Task(int dsIndex, String dsName, String url, String username, String password, String sql) {
            this.dsIndex = dsIndex;
            this.dsName = dsName;
            this.sql = sql;
            this.url = url;
            this.username = username;
            this.password = password;
        }

        @Override
        public Map<String, Object> call() {
            HashMap<String, Object> res = new HashMap<String, Object>();
            HashMap<Integer, List<Integer>> dsResult = new HashMap<Integer, List<Integer>>();
            JSONObject dsInfo = new JSONObject();
            try {
                DriverManager.setLoginTimeout(50);
                Connection conn = DriverManager.getConnection(this.url, this.username, this.password);
                conn.setAutoCommit(false);
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(this.sql);
                conn.commit();
                int count = 0;
                JSONArray columnArray = new JSONArray();
                ResultSetMetaData metaData = rs.getMetaData();
                while (rs.next()) {
                    ++count;
                    int colsLength = metaData.getColumnCount();
                    for (int i = 0; i < colsLength; ++i) {
                        int type;
                        int columnType;
                        List<Integer> dataList;
                        if (dsResult.containsKey(i)) {
                            dataList = (List)dsResult.get(i);
                        } else {
                            dataList = new ArrayList();
                            dsResult.put(i, dataList);
                        }
                        String fieldName = metaData.getColumnLabel(i + 1);
                        if (fieldName == null) {
                            fieldName = metaData.getColumnName(i + 1);
                        }
                        if ((columnType = metaData.getColumnType(i + 1)) == 1 || columnType == 12 || columnType == -1 || columnType == -15) {
                            type = 1;
                            dataList.add((Integer)rs.getBytes(i + 1));
                        } else if (columnType == -7 || columnType == -6 || columnType == 5 || columnType == 4) {
                            dataList.add(rs.getInt(i + 1));
                            type = 2;
                        } else if (columnType == 8 || columnType == 6 || columnType == 7) {
                            type = 3;
                            dataList.add((Integer)rs.getDouble(i + 1));
                        } else if (columnType == 91 || columnType == -15 || columnType == -16) {
                            type = 4;
                            Date date = rs.getDate(i + 1);
                            dataList.add((Integer)(date == null ? 0L : date.getTime()));
                        } else if (columnType == 92 || columnType == 93) {
                            type = 5;
                            Timestamp time = rs.getTimestamp(i + 1);
                            dataList.add((Integer)(time == null ? 0L : time.getTime()));
                        } else if (columnType == 16) {
                            type = 6;
                            dataList.add((Integer)((Object)Boolean.valueOf(rs.getBoolean(i + 1))));
                        } else if (columnType == -4) {
                            type = 7;
                            Blob blob = rs.getBlob(i + 1);
                            BufferedInputStream is = new BufferedInputStream(blob.getBinaryStream());
                            byte[] bytes = new byte[(int)blob.length()];
                            int len = bytes.length;
                            int read = 0;
                            for (int offset = 0; offset < len && (read = ((InputStream)is).read(bytes, offset, len - offset)) >= 0; offset += read) {
                            }
                            dataList.add((Integer)bytes);
                        } else if (columnType == 3 || columnType == 2) {
                            type = 9;
                            dataList.add((Integer)((Object)rs.getString(i + 1)));
                        } else if (columnType == -5) {
                            type = 8;
                            dataList.add((Integer)((Object)rs.getString(i + 1)));
                        } else if (columnType == -9) {
                            type = 10;
                            dataList.add((Integer)((Object)rs.getString(i + 1)));
                        } else if (columnType == 2005) {
                            int bytesRead;
                            type = 11;
                            Clob clob = rs.getClob(i + 1);
                            Reader reader = clob.getCharacterStream();
                            BufferedReader br = new BufferedReader(reader);
                            StringBuilder stringBuilder = new StringBuilder();
                            char[] buffer = new char[1024];
                            while ((bytesRead = br.read(buffer)) != -1) {
                                stringBuilder.append(buffer, 0, bytesRead);
                            }
                            byte[] bytes = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
                            dataList.add((Integer)bytes);
                        } else {
                            type = 1;
                            dataList.add((Integer)((Object)rs.getString(i + 1)));
                        }
                        if (count != 1) continue;
                        JSONObject fieldObj = new JSONObject();
                        fieldObj.put("fn", (Object)fieldName);
                        fieldObj.put("ft", (Object)type);
                        fieldObj.put("index", (Object)i);
                        columnArray.add((Object)fieldObj);
                    }
                }
                dsInfo.put("index", (Object)this.dsIndex);
                dsInfo.put("dsName", (Object)this.dsName);
                dsInfo.put("count", (Object)count);
                dsInfo.put("data", (Object)columnArray);
                res.put("dsInfo", dsInfo);
                res.put("dsResult", dsResult);
                res.put("dsIndex", this.dsIndex);
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                dsInfo.put("index", (Object)this.dsIndex);
                dsInfo.put("dsName", (Object)this.dsName);
                dsInfo.put("count", (Object)0);
                dsInfo.put("data", (Object)new JSONArray());
                res.put("dsInfo", dsInfo);
                res.put("dsResult", dsResult);
                res.put("dsIndex", this.dsIndex);
            }
            return res;
        }
    }
}

