/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public class Map {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static java.util.Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = Map.generateDefaultOption();
            String clazzName = Map.getClassName();
            JSONObject optionObj = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-5.4.2.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/china.js'></script>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("var myChart = echarts.init(document.getElementById('main'));");
                sb.append("var option = ");
                sb.append(option + ";");
                sb.append("myChart.setOption(option);");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static java.util.Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + Map.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                JSONArray legend;
                JSONObject legendObject;
                JSONArray yAxis;
                JSONObject yAxisObject;
                JSONArray xAxis;
                JSONObject xAxisObject;
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                optionJSON.put("categoryData", realDataJSON.get((Object)"categoryData"));
                optionJSON.put("seriesData", realDataJSON.get((Object)"seriesData"));
                optionJSON.put("valueData", realDataJSON.get((Object)"valueData"));
                optionJSON.put("labelFormatter", realDataJSON.get((Object)"labelFormatter"));
                if (optionJSON.containsKey((Object)"xAxis") && (xAxisObject = (xAxis = optionJSON.getJSONArray("xAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    xAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"yAxis") && (yAxisObject = (yAxis = optionJSON.getJSONArray("yAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    yAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"series")) {
                    JSONObject labelObject;
                    JSONObject seriesObject;
                    JSONArray seriesArray = optionJSON.getJSONArray("series");
                    if (seriesArray.size() > 0 && (seriesObject = seriesArray.getJSONObject(0)).containsKey((Object)"label") && (labelObject = seriesObject.getJSONObject("label")).containsKey((Object)"show")) {
                        boolean flag = labelObject.getBoolean("show");
                        optionJSON.put("labelShow", (Object)flag);
                    }
                    optionJSON.remove((Object)"series");
                }
                if (optionJSON.containsKey((Object)"legend") && (legendObject = (legend = optionJSON.getJSONArray("legend")).getJSONObject(0)).containsKey((Object)"data")) {
                    legendObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"animation")) {
                    optionJSON.remove((Object)"animation");
                    optionJSON.put("animation", (Object)true);
                }
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOptionByArea(String area) {
        StringBuffer sb = new StringBuffer();
        if ("china".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: 'china',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5317\u4eac',value:200},");
            sb.append("{name:'\u5929\u6d25',value:300},");
            sb.append("{name:'\u4e0a\u6d77',value:400},");
            sb.append("{name:'\u91cd\u5e86',value:100},");
            sb.append("{name:'\u6cb3\u5317',value:100},");
            sb.append("{name:'\u6cb3\u5357',value:100},");
            sb.append("{name:'\u4e91\u5357',value:100},");
            sb.append("{name:'\u8fbd\u5b81',value:100},");
            sb.append("{name:'\u9ed1\u9f99\u6c5f',value:100},");
            sb.append("{name:'\u6e56\u5357',value:100},");
            sb.append("{name:'\u5b89\u5fbd',value:100},");
            sb.append("{name:'\u5c71\u4e1c',value:100},");
            sb.append("{name:'\u65b0\u7586',value:100},");
            sb.append("{name:'\u6c5f\u82cf',value:100},");
            sb.append("{name:'\u6d59\u6c5f',value:100},");
            sb.append("{name:'\u6c5f\u897f',value:100},");
            sb.append("{name:'\u6e56\u5317',value:100},");
            sb.append("{name:'\u5e7f\u897f',value:100},");
            sb.append("{name:'\u7518\u8083',value:100},");
            sb.append("{name:'\u5c71\u897f',value:100},");
            sb.append("{name:'\u5185\u8499\u53e4',value:100},");
            sb.append("{name:'\u9655\u897f',value:100},");
            sb.append("{name:'\u5409\u6797',value:100},");
            sb.append("{name:'\u798f\u5efa',value:100},");
            sb.append("{name:'\u8d35\u5dde',value:100},");
            sb.append("{name:'\u5e7f\u4e1c',value:100},");
            sb.append("{name:'\u9752\u6d77',value:100},");
            sb.append("{name:'\u897f\u85cf',value:100},");
            sb.append("{name:'\u56db\u5ddd',value:100},");
            sb.append("{name:'\u5b81\u590f',value:100},");
            sb.append("{name:'\u6d77\u5357',value:100},");
            sb.append("{name:'\u53f0\u6e7e',value:100},");
            sb.append("{name:'\u9999\u6e2f',value:100},");
            sb.append("{name:'\u6fb3\u95e8',value:100}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'china',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name: '\u5317\u4eac',value:100},");
            sb.append("{name: '\u5929\u6d25',value:100},");
            sb.append("{name: '\u4e0a\u6d77',value:100},");
            sb.append("{name: '\u91cd\u5e86',value:100},");
            sb.append("{name: '\u6cb3\u5317',value:100},");
            sb.append("{name: '\u5b89\u5fbd',value:100},");
            sb.append("{name: '\u65b0\u7586',value:100},");
            sb.append("{name: '\u6d59\u6c5f',value:100},");
            sb.append("{name: '\u6c5f\u897f',value:100},");
            sb.append("{name: '\u5c71\u897f',value:100},");
            sb.append("{name: '\u5185\u8499\u53e4',value:100},");
            sb.append("{name: '\u5409\u6797',value:100},");
            sb.append("{name: '\u798f\u5efa',value:100},");
            sb.append("{name: '\u5e7f\u4e1c',value:100},");
            sb.append("{name: '\u897f\u85cf',value:100},");
            sb.append("{name: '\u56db\u5ddd',value:100},");
            sb.append("{name: '\u5b81\u590f',value:100},");
            sb.append("{name: '\u9999\u6e2f',value:100},");
            sb.append("{name: '\u6fb3\u95e8',value:100}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: 'china',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name: '\u5317\u4eac',value:100},");
            sb.append("{name: '\u5929\u6d25',value:100},");
            sb.append("{name: '\u4e0a\u6d77',value:100},");
            sb.append("{name: '\u5e7f\u4e1c',value:100},");
            sb.append("{name: '\u53f0\u6e7e',value:100},");
            sb.append("{name: '\u9999\u6e2f',value:100},");
            sb.append("{name: '\u6fb3\u95e8',value:100}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u56db\u5ddd".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u56db\u5ddd',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6210\u90fd\u5e02',value:200},");
            sb.append("{name: '\u6500\u679d\u82b1\u5e02',value:100},");
            sb.append("{name: '\u5fb7\u9633\u5e02',value:100},");
            sb.append("{name:'\u81ea\u8d21\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u56db\u5ddd',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name: '\u6500\u679d\u82b1\u5e02',value:100},");
            sb.append("{name: '\u6210\u90fd\u5e02',value:200},");
            sb.append("{name: '\u81ea\u8d21\u5e02',value:232},");
            sb.append("{name: '\u6cf8\u5dde\u5e02',value:400}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u56db\u5ddd',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name: '\u6500\u679d\u82b1\u5e02',value:100},");
            sb.append("{name: '\u6210\u90fd\u5e02',value:200},");
            sb.append("{name: '\u81ea\u8d21\u5e02',value:232},");
            sb.append("{name: '\u6cf8\u5dde\u5e02',value:400}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5b89\u5fbd".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5b89\u5fbd',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5408\u80a5\u5e02',value:200},");
            sb.append("{name: '\u829c\u6e56\u5e02',value:100},");
            sb.append("{name: '\u868c\u57e0\u5e02',value:100},");
            sb.append("{name:'\u9a6c\u978d\u5c71\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5b89\u5fbd',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5408\u80a5\u5e02',value:270},");
            sb.append("{name: '\u829c\u6e56\u5e02',value:120},");
            sb.append("{name: '\u868c\u57e0\u5e02',value:120},");
            sb.append("{name:'\u9a6c\u978d\u5c71\u5e02',value:320}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5b89\u5fbd',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5408\u80a5\u5e02',value:1100},");
            sb.append("{name: '\u829c\u6e56\u5e02',value:200},");
            sb.append("{name: '\u868c\u57e0\u5e02',value:400},");
            sb.append("{name:'\u9a6c\u978d\u5c71\u5e02',value:700}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u6fb3\u95e8".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6fb3\u95e8',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u82b1\u5730\u739b\u5802\u533a',value:2200},");
            sb.append("{name: '\u671b\u5fb7\u5858\u533a',value:2100},");
            sb.append("{name: '\u5927\u5802\u533a',value:1600},");
            sb.append("{name:'\u5723\u65b9\u6d4e\u5404\u5802\u533a',value:1700}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u6fb3\u95e8',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u82b1\u5730\u739b\u5802\u533a',value:1200},");
            sb.append("{name: '\u671b\u5fb7\u5858\u533a',value:1100},");
            sb.append("{name: '\u5927\u5802\u533a',value:1300},");
            sb.append("{name:'\u5723\u65b9\u6d4e\u5404\u5802\u533a',value:1300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6fb3\u95e8',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u82b1\u5730\u739b\u5802\u533a',value:1200},");
            sb.append("{name: '\u671b\u5fb7\u5858\u533a',value:2100},");
            sb.append("{name: '\u5927\u5802\u533a',value:4300},");
            sb.append("{name:'\u5723\u65b9\u6d4e\u5404\u5802\u533a',value:2300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5317\u4eac".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5317\u4eac',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e1c\u57ce\u533a',value:200},");
            sb.append("{name: '\u897f\u57ce\u533a',value:100},");
            sb.append("{name: '\u671d\u9633\u533a',value:100},");
            sb.append("{name:'\u77f3\u666f\u5c71\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5317\u4eac',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name: '\u77f3\u666f\u5c71\u533a',value:100},");
            sb.append("{name: '\u671d\u9633\u533a',value:200},");
            sb.append("{name: '\u897f\u57ce\u533a',value:232},");
            sb.append("{name: '\u4e1c\u57ce\u533a', value:400}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5317\u4eac',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name: '\u77f3\u666f\u5c71\u533a',value:100},");
            sb.append("{name: '\u671d\u9633\u533a',value:200},");
            sb.append("{name: '\u897f\u57ce\u533a',value:232},");
            sb.append("{name: '\u4e1c\u57ce\u533a',value:400}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u91cd\u5e86".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u91cd\u5e86',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e07\u5dde\u533a',value:200},");
            sb.append("{name: '\u6daa\u9675\u533a',value:100},");
            sb.append("{name: '\u6e1d\u4e2d\u533a',value:100},");
            sb.append("{name:'\u5927\u6e21\u53e3\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u91cd\u5e86',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e07\u5dde\u533a',value:1200},");
            sb.append("{name: '\u6daa\u9675\u533a',value:1100},");
            sb.append("{name: '\u6e1d\u4e2d\u533a',value:1300},");
            sb.append("{name:'\u5927\u6e21\u53e3\u533a',value:1300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u91cd\u5e86',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e07\u5dde\u533a',value:2200},");
            sb.append("{name: '\u6daa\u9675\u533a',value:1400},");
            sb.append("{name: '\u6e1d\u4e2d\u533a',value:4100},");
            sb.append("{name:'\u5927\u6e21\u53e3\u533a',value:4300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u798f\u5efa".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u798f\u5efa',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u798f\u5dde\u5e02',value:200},");
            sb.append("{name: '\u6cc9\u5dde\u5e02',value:100},");
            sb.append("{name: '\u4e09\u660e\u5e02',value:100},");
            sb.append("{name:'\u9f99\u5ca9\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u798f\u5efa',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u798f\u5dde\u5e02',value:200},");
            sb.append("{name: '\u6cc9\u5dde\u5e02',value:100},");
            sb.append("{name: '\u4e09\u660e\u5e02',value:100},");
            sb.append("{name:'\u9f99\u5ca9\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u798f\u5efa',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u798f\u5dde\u5e02',value:200},");
            sb.append("{name: '\u6cc9\u5dde\u5e02',value:100},");
            sb.append("{name: '\u4e09\u660e\u5e02',value:100},");
            sb.append("{name:'\u9f99\u5ca9\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u7518\u8083".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u7518\u8083',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5170\u5dde\u5e02',value:200},");
            sb.append("{name: '\u5609\u5cea\u5173\u5e02',value:100},");
            sb.append("{name: '\u91d1\u660c\u5e02',value:100},");
            sb.append("{name:'\u5929\u6c34\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u7518\u8083',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5170\u5dde\u5e02',value:1200},");
            sb.append("{name: '\u5609\u5cea\u5173\u5e02',value:1300},");
            sb.append("{name: '\u91d1\u660c\u5e02',value:200},");
            sb.append("{name:'\u5929\u6c34\u5e02',value:800}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u7518\u8083',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5170\u5dde\u5e02',value:700},");
            sb.append("{name: '\u5609\u5cea\u5173\u5e02',value:800},");
            sb.append("{name: '\u91d1\u660c\u5e02',value:1000},");
            sb.append("{name:'\u5929\u6c34\u5e02',value:1300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5e7f\u4e1c".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5e7f\u4e1c',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5e7f\u5dde\u5e02',value:200},");
            sb.append("{name: '\u97f6\u5173\u5e02',value:100},");
            sb.append("{name: '\u6df1\u5733\u5e02',value:100},");
            sb.append("{name:'\u6c5f\u95e8\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5e7f\u4e1c',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5e7f\u5dde\u5e02',value:400},");
            sb.append("{name: '\u97f6\u5173\u5e02',value:500},");
            sb.append("{name: '\u6df1\u5733\u5e02',value:600},");
            sb.append("{name:'\u6c5f\u95e8\u5e02',value:700}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5e7f\u4e1c',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5e7f\u5dde\u5e02',value:1400},");
            sb.append("{name: '\u97f6\u5173\u5e02',value:1500},");
            sb.append("{name: '\u6df1\u5733\u5e02',value:1600},");
            sb.append("{name:'\u6c5f\u95e8\u5e02',value:1700}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5e7f\u897f".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5e7f\u897f',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5357\u5b81\u5e02',value:1200},");
            sb.append("{name: '\u67f3\u5dde\u5e02',value:1100},");
            sb.append("{name: '\u6842\u6797\u5e02',value:1100},");
            sb.append("{name:'\u5317\u6d77\u5e02',value:1300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5e7f\u897f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5357\u5b81\u5e02',value:2200},");
            sb.append("{name: '\u67f3\u5dde\u5e02',value:2100},");
            sb.append("{name: '\u6842\u6797\u5e02',value:2100},");
            sb.append("{name:'\u5317\u6d77\u5e02',value:2300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5e7f\u897f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5357\u5b81\u5e02',value:700},");
            sb.append("{name: '\u67f3\u5dde\u5e02',value:800},");
            sb.append("{name: '\u6842\u6797\u5e02',value:900},");
            sb.append("{name:'\u5317\u6d77\u5e02',value:1300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u8d35\u5dde".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u8d35\u5dde',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u8d35\u9633\u5e02',value:200},");
            sb.append("{name: '\u516d\u76d8\u6c34\u5e02',value:100},");
            sb.append("{name: '\u9075\u4e49\u5e02',value:100},");
            sb.append("{name:'\u94dc\u4ec1\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u8d35\u5dde',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u8d35\u9633\u5e02',value:1200},");
            sb.append("{name: '\u516d\u76d8\u6c34\u5e02',value:1100},");
            sb.append("{name: '\u9075\u4e49\u5e02',value:1100},");
            sb.append("{name:'\u94dc\u4ec1\u5e02',value:1300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u8d35\u5dde',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u8d35\u9633\u5e02',value:600},");
            sb.append("{name: '\u516d\u76d8\u6c34\u5e02',value:700},");
            sb.append("{name: '\u9075\u4e49\u5e02',value:800},");
            sb.append("{name:'\u94dc\u4ec1\u5e02',value:900}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u6d77\u5357".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6d77\u5357',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e09\u4e9a\u5e02',value:200},");
            sb.append("{name: '\u6d77\u53e3\u5e02',value:100},");
            sb.append("{name: '\u743c\u6d77\u5e02',value:100},");
            sb.append("{name:'\u4e94\u6307\u5c71\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u6d77\u5357',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e09\u4e9a\u5e02',value:1200},");
            sb.append("{name: '\u6d77\u53e3\u5e02',value:1100},");
            sb.append("{name: '\u743c\u6d77\u5e02',value:1100},");
            sb.append("{name:'\u4e94\u6307\u5c71\u5e02',value:1300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6d77\u5357',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e09\u4e9a\u5e02',value:400},");
            sb.append("{name: '\u6d77\u53e3\u5e02',value:500},");
            sb.append("{name: '\u743c\u6d77\u5e02',value:600},");
            sb.append("{name:'\u4e94\u6307\u5c71\u5e02',value:800}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u6cb3\u5317".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6cb3\u5317',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u77f3\u5bb6\u5e84\u5e02',value:200},");
            sb.append("{name: '\u4fdd\u5b9a\u5e02',value:100},");
            sb.append("{name: '\u5510\u5c71\u5e02',value:100},");
            sb.append("{name:'\u90af\u90f8\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u6cb3\u5317',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u77f3\u5bb6\u5e84\u5e02',value:200},");
            sb.append("{name: '\u4fdd\u5b9a\u5e02',value:100},");
            sb.append("{name: '\u5510\u5c71\u5e02',value:100},");
            sb.append("{name:'\u90af\u90f8\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6cb3\u5317',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u77f3\u5bb6\u5e84\u5e02',value:200},");
            sb.append("{name: '\u4fdd\u5b9a\u5e02',value:100},");
            sb.append("{name: '\u5510\u5c71\u5e02',value:100},");
            sb.append("{name:'\u90af\u90f8\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u9ed1\u9f99\u6c5f".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u9ed1\u9f99\u6c5f',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u54c8\u5c14\u6ee8\u5e02',value:200},");
            sb.append("{name: '\u9f50\u9f50\u54c8\u5c14\u5e02',value:100},");
            sb.append("{name: '\u9e21\u897f\u5e02',value:100},");
            sb.append("{name:'\u53cc\u9e2d\u5c71\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u9ed1\u9f99\u6c5f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u54c8\u5c14\u6ee8\u5e02',value:200},");
            sb.append("{name: '\u9f50\u9f50\u54c8\u5c14\u5e02',value:100},");
            sb.append("{name: '\u9e21\u897f\u5e02',value:100},");
            sb.append("{name:'\u53cc\u9e2d\u5c71\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u9ed1\u9f99\u6c5f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u54c8\u5c14\u6ee8\u5e02',value:200},");
            sb.append("{name: '\u9f50\u9f50\u54c8\u5c14\u5e02',value:100},");
            sb.append("{name: '\u9e21\u897f\u5e02',value:100},");
            sb.append("{name:'\u53cc\u9e2d\u5c71\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u6cb3\u5357".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6cb3\u5357',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u90d1\u5dde\u5e02',value:200},");
            sb.append("{name: '\u5f00\u5c01\u5e02',value:100},");
            sb.append("{name: '\u6d1b\u9633\u5e02',value:100},");
            sb.append("{name:'\u65b0\u4e61\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u6cb3\u5357',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u90d1\u5dde\u5e02',value:200},");
            sb.append("{name: '\u5f00\u5c01\u5e02',value:100},");
            sb.append("{name: '\u6d1b\u9633\u5e02',value:100},");
            sb.append("{name:'\u65b0\u4e61\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6cb3\u5357',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u90d1\u5dde\u5e02',value:200},");
            sb.append("{name: '\u5f00\u5c01\u5e02',value:100},");
            sb.append("{name: '\u6d1b\u9633\u5e02',value:100},");
            sb.append("{name:'\u65b0\u4e61\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u6e56\u5317".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6e56\u5317',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6b66\u6c49\u5e02',value:200},");
            sb.append("{name: '\u8944\u9633\u5e02',value:100},");
            sb.append("{name: '\u9ec4\u77f3\u5e02',value:100},");
            sb.append("{name:'\u5b9c\u660c\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u6e56\u5317',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6b66\u6c49\u5e02',value:200},");
            sb.append("{name: '\u8944\u9633\u5e02',value:100},");
            sb.append("{name: '\u9ec4\u77f3\u5e02',value:100},");
            sb.append("{name:'\u5b9c\u660c\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6e56\u5317',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6b66\u6c49\u5e02',value:200},");
            sb.append("{name: '\u8944\u9633\u5e02',value:100},");
            sb.append("{name: '\u9ec4\u77f3\u5e02',value:100},");
            sb.append("{name:'\u5b9c\u660c\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u6e56\u5357".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6e56\u5357',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u957f\u6c99\u5e02',value:200},");
            sb.append("{name: '\u682a\u6d32\u5e02',value:100},");
            sb.append("{name: '\u6e58\u6f6d\u5e02',value:100},");
            sb.append("{name:'\u8861\u9633\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u6e56\u5357',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u957f\u6c99\u5e02',value:200},");
            sb.append("{name: '\u682a\u6d32\u5e02',value:100},");
            sb.append("{name: '\u6e58\u6f6d\u5e02',value:100},");
            sb.append("{name:'\u8861\u9633\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6e56\u5357',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u957f\u6c99\u5e02',value:200},");
            sb.append("{name: '\u682a\u6d32\u5e02',value:100},");
            sb.append("{name: '\u6e58\u6f6d\u5e02',value:100},");
            sb.append("{name:'\u8861\u9633\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u6c5f\u82cf".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6c5f\u82cf',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5357\u4eac\u5e02',value:200},");
            sb.append("{name: '\u65e0\u9521\u5e02',value:100},");
            sb.append("{name: '\u5f90\u5dde\u5e02',value:100},");
            sb.append("{name:'\u5e38\u5dde\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u6c5f\u82cf',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5357\u4eac\u5e02',value:200},");
            sb.append("{name: '\u65e0\u9521\u5e02',value:100},");
            sb.append("{name: '\u5f90\u5dde\u5e02',value:100},");
            sb.append("{name:'\u5e38\u5dde\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6c5f\u82cf',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5357\u4eac\u5e02',value:200},");
            sb.append("{name: '\u65e0\u9521\u5e02',value:100},");
            sb.append("{name: '\u5f90\u5dde\u5e02',value:100},");
            sb.append("{name:'\u5e38\u5dde\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u6c5f\u897f".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6c5f\u897f',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5357\u660c\u5e02',value:200},");
            sb.append("{name: '\u666f\u5fb7\u9547\u5e02',value:100},");
            sb.append("{name: '\u840d\u4e61\u5e02',value:100},");
            sb.append("{name:'\u4e5d\u6c5f\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u6c5f\u897f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5357\u660c\u5e02',value:200},");
            sb.append("{name: '\u666f\u5fb7\u9547\u5e02',value:100},");
            sb.append("{name: '\u840d\u4e61\u5e02',value:100},");
            sb.append("{name:'\u4e5d\u6c5f\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6c5f\u897f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u5357\u660c\u5e02',value:200},");
            sb.append("{name: '\u666f\u5fb7\u9547\u5e02',value:100},");
            sb.append("{name: '\u840d\u4e61\u5e02',value:100},");
            sb.append("{name:'\u4e5d\u6c5f\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5409\u6797".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5409\u6797',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u957f\u6625\u5e02',value:200},");
            sb.append("{name: '\u5409\u6797\u5e02',value:100},");
            sb.append("{name: '\u8fbd\u6e90\u5e02',value:100},");
            sb.append("{name:'\u56db\u5e73\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5409\u6797',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u957f\u6625\u5e02',value:200},");
            sb.append("{name: '\u5409\u6797\u5e02',value:100},");
            sb.append("{name: '\u8fbd\u6e90\u5e02',value:100},");
            sb.append("{name:'\u56db\u5e73\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5409\u6797',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u957f\u6625\u5e02',value:200},");
            sb.append("{name: '\u5409\u6797\u5e02',value:100},");
            sb.append("{name: '\u8fbd\u6e90\u5e02',value:100},");
            sb.append("{name:'\u56db\u5e73\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u8fbd\u5b81".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u8fbd\u5b81',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6c88\u9633\u5e02',value:200},");
            sb.append("{name: '\u5927\u8fde\u5e02',value:100},");
            sb.append("{name: '\u978d\u5c71\u5e02',value:100},");
            sb.append("{name:'\u629a\u987a\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u8fbd\u5b81',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6c88\u9633\u5e02',value:200},");
            sb.append("{name: '\u5927\u8fde\u5e02',value:100},");
            sb.append("{name: '\u978d\u5c71\u5e02',value:100},");
            sb.append("{name:'\u629a\u987a\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u8fbd\u5b81',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6c88\u9633\u5e02',value:200},");
            sb.append("{name: '\u5927\u8fde\u5e02',value:100},");
            sb.append("{name: '\u978d\u5c71\u5e02',value:100},");
            sb.append("{name:'\u629a\u987a\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5185\u8499\u53e4".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5185\u8499\u53e4',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u547c\u548c\u6d69\u7279\u5e02',value:200},");
            sb.append("{name: '\u5305\u5934\u5e02',value:100},");
            sb.append("{name: '\u4e4c\u6d77\u5e02',value:100},");
            sb.append("{name:'\u8d64\u5cf0\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5185\u8499\u53e4',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u547c\u548c\u6d69\u7279\u5e02',value:200},");
            sb.append("{name: '\u5305\u5934\u5e02',value:100},");
            sb.append("{name: '\u4e4c\u6d77\u5e02',value:100},");
            sb.append("{name:'\u8d64\u5cf0\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5185\u8499\u53e4',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u547c\u548c\u6d69\u7279\u5e02',value:200},");
            sb.append("{name: '\u5305\u5934\u5e02',value:100},");
            sb.append("{name: '\u4e4c\u6d77\u5e02',value:100},");
            sb.append("{name:'\u8d64\u5cf0\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5b81\u590f".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5b81\u590f',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u94f6\u5ddd\u5e02',value:200},");
            sb.append("{name: '\u77f3\u5634\u5c71\u5e02',value:100},");
            sb.append("{name: '\u5434\u5fe0\u5e02',value:100},");
            sb.append("{name:'\u56fa\u539f\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5b81\u590f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u94f6\u5ddd\u5e02',value:200},");
            sb.append("{name: '\u77f3\u5634\u5c71\u5e02',value:100},");
            sb.append("{name: '\u5434\u5fe0\u5e02',value:100},");
            sb.append("{name:'\u56fa\u539f\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5b81\u590f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u94f6\u5ddd\u5e02',value:200},");
            sb.append("{name: '\u77f3\u5634\u5c71\u5e02',value:100},");
            sb.append("{name: '\u5434\u5fe0\u5e02',value:100},");
            sb.append("{name:'\u56fa\u539f\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u9752\u6d77".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u9752\u6d77',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u897f\u5b81\u5e02',value:200},");
            sb.append("{name: '\u6d77\u4e1c\u5e02',value:100},");
            sb.append("{name: '\u6d77\u5317\u85cf\u65cf\u81ea\u6cbb\u5dde',value:100},");
            sb.append("{name:'\u9ec4\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u9752\u6d77',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u897f\u5b81\u5e02',value:200},");
            sb.append("{name: '\u6d77\u4e1c\u5e02',value:100},");
            sb.append("{name: '\u6d77\u5317\u85cf\u65cf\u81ea\u6cbb\u5dde',value:100},");
            sb.append("{name:'\u9ec4\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u9752\u6d77',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u897f\u5b81\u5e02',value:200},");
            sb.append("{name: '\u6d77\u4e1c\u5e02',value:100},");
            sb.append("{name: '\u6d77\u5317\u85cf\u65cf\u81ea\u6cbb\u5dde',value:100},");
            sb.append("{name:'\u9ec4\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5c71\u4e1c".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5c71\u4e1c',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6d4e\u5357\u5e02',value:200},");
            sb.append("{name: '\u9752\u5c9b\u5e02',value:100},");
            sb.append("{name: '\u6dc4\u535a\u5e02',value:100},");
            sb.append("{name:'\u67a3\u5e84\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5c71\u4e1c',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6d4e\u5357\u5e02',value:200},");
            sb.append("{name: '\u9752\u5c9b\u5e02',value:100},");
            sb.append("{name: '\u6dc4\u535a\u5e02',value:100},");
            sb.append("{name:'\u67a3\u5e84\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5c71\u4e1c',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6d4e\u5357\u5e02',value:200},");
            sb.append("{name: '\u9752\u5c9b\u5e02',value:100},");
            sb.append("{name: '\u6dc4\u535a\u5e02',value:100},");
            sb.append("{name:'\u67a3\u5e84\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u4e0a\u6d77".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u4e0a\u6d77',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u9ec4\u6d66\u533a',value:200},");
            sb.append("{name: '\u957f\u5b81\u533a',value:100},");
            sb.append("{name: '\u5f90\u6c47\u533a',value:100},");
            sb.append("{name:'\u666e\u9640\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u4e0a\u6d77',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u9ec4\u6d66\u533a',value:200},");
            sb.append("{name: '\u957f\u5b81\u533a',value:100},");
            sb.append("{name: '\u5f90\u6c47\u533a',value:100},");
            sb.append("{name:'\u666e\u9640\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u4e0a\u6d77',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u9ec4\u6d66\u533a',value:200},");
            sb.append("{name: '\u957f\u5b81\u533a',value:100},");
            sb.append("{name: '\u5f90\u6c47\u533a',value:100},");
            sb.append("{name:'\u666e\u9640\u533a',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5c71\u897f".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5c71\u897f',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u592a\u539f\u5e02',value:200},");
            sb.append("{name: '\u5927\u540c\u5e02',value:100},");
            sb.append("{name: '\u9633\u6cc9\u5e02',value:100},");
            sb.append("{name:'\u957f\u6cbb\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5c71\u897f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u592a\u539f\u5e02',value:200},");
            sb.append("{name: '\u5927\u540c\u5e02',value:100},");
            sb.append("{name: '\u9633\u6cc9\u5e02',value:100},");
            sb.append("{name:'\u957f\u6cbb\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5c71\u897f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u592a\u539f\u5e02',value:200},");
            sb.append("{name: '\u5927\u540c\u5e02',value:100},");
            sb.append("{name: '\u9633\u6cc9\u5e02',value:100},");
            sb.append("{name:'\u957f\u6cbb\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u9655\u897f".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u9655\u897f',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u897f\u5b89\u5e02',value:200},");
            sb.append("{name: '\u94dc\u5ddd\u5e02',value:100},");
            sb.append("{name: '\u5b9d\u9e21\u5e02',value:100},");
            sb.append("{name:'\u54b8\u9633\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u9655\u897f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u897f\u5b89\u5e02',value:200},");
            sb.append("{name: '\u94dc\u5ddd\u5e02',value:100},");
            sb.append("{name: '\u5b9d\u9e21\u5e02',value:100},");
            sb.append("{name:'\u54b8\u9633\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u9655\u897f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u897f\u5b89\u5e02',value:200},");
            sb.append("{name: '\u94dc\u5ddd\u5e02',value:100},");
            sb.append("{name: '\u5b9d\u9e21\u5e02',value:100},");
            sb.append("{name:'\u54b8\u9633\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u5929\u6d25".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5929\u6d25',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u548c\u5e73\u533a',value:200},");
            sb.append("{name: '\u6cb3\u4e1c\u533a',value:100},");
            sb.append("{name: '\u6cb3\u897f\u533a',value:100},");
            sb.append("{name:'\u5357\u5f00\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u5929\u6d25',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u548c\u5e73\u533a',value:200},");
            sb.append("{name: '\u6cb3\u4e1c\u533a',value:100},");
            sb.append("{name: '\u6cb3\u897f\u533a',value:100},");
            sb.append("{name:'\u5357\u5f00\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u5929\u6d25',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u548c\u5e73\u533a',value:200},");
            sb.append("{name: '\u6cb3\u4e1c\u533a',value:100},");
            sb.append("{name: '\u6cb3\u897f\u533a',value:100},");
            sb.append("{name:'\u5357\u5f00\u533a',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u53f0\u6e7e".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u53f0\u6e7e',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u53f0\u6e7e\u7701',value:200}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u53f0\u6e7e',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u53f0\u6e7e\u7701',value:400}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u53f0\u6e7e',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u53f0\u6e7e\u7701',value:800}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u9999\u6e2f".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u9999\u6e2f',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e1c\u533a',value:200},");
            sb.append("{name: '\u6e7e\u4ed4\u533a',value:100},");
            sb.append("{name: '\u4e2d\u897f\u533a',value:100},");
            sb.append("{name:'\u6cb9\u5c16\u65fa\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u9999\u6e2f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e1c\u533a',value:200},");
            sb.append("{name: '\u6e7e\u4ed4\u533a',value:100},");
            sb.append("{name: '\u4e2d\u897f\u533a',value:100},");
            sb.append("{name:'\u6cb9\u5c16\u65fa\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u9999\u6e2f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e1c\u533a',value:200},");
            sb.append("{name: '\u6e7e\u4ed4\u533a',value:100},");
            sb.append("{name: '\u4e2d\u897f\u533a',value:100},");
            sb.append("{name:'\u6cb9\u5c16\u65fa\u533a',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u65b0\u7586".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u65b0\u7586',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e4c\u9c81\u6728\u9f50\u5e02',value:200},");
            sb.append("{name: '\u514b\u62c9\u739b\u4f9d\u5e02',value:100},");
            sb.append("{name: '\u5410\u9c81\u756a\u5730\u533a',value:100},");
            sb.append("{name:'\u54c8\u5bc6\u5730\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u65b0\u7586',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e4c\u9c81\u6728\u9f50\u5e02',value:200},");
            sb.append("{name: '\u514b\u62c9\u739b\u4f9d\u5e02',value:100},");
            sb.append("{name: '\u5410\u9c81\u756a\u5730\u533a',value:100},");
            sb.append("{name:'\u54c8\u5bc6\u5730\u533a',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u65b0\u7586',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u4e4c\u9c81\u6728\u9f50\u5e02',value:200},");
            sb.append("{name: '\u514b\u62c9\u739b\u4f9d\u5e02',value:100},");
            sb.append("{name: '\u5410\u9c81\u756a\u5730\u533a',value:100},");
            sb.append("{name:'\u54c8\u5bc6\u5730\u533a',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u897f\u85cf".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u897f\u85cf',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u62c9\u8428\u5e02',value:200},");
            sb.append("{name: '\u660c\u90fd\u5e02',value:100},");
            sb.append("{name: '\u5c71\u5357\u5730\u533a',value:100},");
            sb.append("{name:'\u65e5\u5580\u5219\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u897f\u85cf',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u62c9\u8428\u5e02',value:200},");
            sb.append("{name: '\u660c\u90fd\u5e02',value:100},");
            sb.append("{name: '\u5c71\u5357\u5730\u533a',value:100},");
            sb.append("{name:'\u65e5\u5580\u5219\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u897f\u85cf',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u62c9\u8428\u5e02',value:200},");
            sb.append("{name: '\u660c\u90fd\u5e02',value:100},");
            sb.append("{name: '\u5c71\u5357\u5730\u533a',value:100},");
            sb.append("{name:'\u65e5\u5580\u5219\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u4e91\u5357".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u4e91\u5357',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6606\u660e\u5e02',value:200},");
            sb.append("{name: '\u66f2\u9756\u5e02',value:100},");
            sb.append("{name: '\u7389\u6eaa\u5e02',value:100},");
            sb.append("{name:'\u4e3d\u6c5f\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u4e91\u5357',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6606\u660e\u5e02',value:200},");
            sb.append("{name: '\u66f2\u9756\u5e02',value:100},");
            sb.append("{name: '\u7389\u6eaa\u5e02',value:100},");
            sb.append("{name:'\u4e3d\u6c5f\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u4e91\u5357',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u6606\u660e\u5e02',value:200},");
            sb.append("{name: '\u66f2\u9756\u5e02',value:100},");
            sb.append("{name: '\u7389\u6eaa\u5e02',value:100},");
            sb.append("{name:'\u4e3d\u6c5f\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        } else if ("\u6d59\u6c5f".equals(area)) {
            sb.append("{title:{");
            sb.append("text:'iphone\u9500\u91cf',");
            sb.append("left: 'center'");
            sb.append("},");
            sb.append("animation:false,");
            sb.append("initTimes:0,");
            sb.append("tooltip : {");
            sb.append("trigger: 'item'");
            sb.append("},");
            sb.append("legend: {");
            sb.append("orient: 'vertical',");
            sb.append("left: 'left',");
            sb.append("show:false,");
            sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
            sb.append("},");
            sb.append("visualMap: {");
            sb.append("min:0,");
            sb.append("max: 2500,");
            sb.append("left: 'left',");
            sb.append("top: 'bottom',");
            sb.append("text:['\u9ad8','\u4f4e'],");
            sb.append("show:false,");
            sb.append("calculable : true");
            sb.append("},");
            sb.append("series:[");
            sb.append("{");
            sb.append("name:'iphone3',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6d59\u6c5f',");
            sb.append("roam: false,");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u676d\u5dde\u5e02',value:200},");
            sb.append("{name: '\u5b81\u6ce2\u5e02',value:100},");
            sb.append("{name: '\u6e29\u5dde\u5e02',value:100},");
            sb.append("{name:'\u5609\u5174\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name:'iphone4',");
            sb.append("type:'map',");
            sb.append("mapType:'\u6d59\u6c5f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis: {");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u676d\u5dde\u5e02',value:200},");
            sb.append("{name: '\u5b81\u6ce2\u5e02',value:100},");
            sb.append("{name: '\u6e29\u5dde\u5e02',value:100},");
            sb.append("{name:'\u5609\u5174\u5e02',value:300}");
            sb.append("]");
            sb.append("},");
            sb.append("{");
            sb.append("name: 'iphone5',");
            sb.append("type: 'map',");
            sb.append("mapType: '\u6d59\u6c5f',");
            sb.append("label: {");
            sb.append("normal:{");
            sb.append("show: false");
            sb.append("},");
            sb.append("emphasis:{");
            sb.append("show: true");
            sb.append("}");
            sb.append("},");
            sb.append("data:[");
            sb.append("{name:'\u676d\u5dde\u5e02',value:200},");
            sb.append("{name: '\u5b81\u6ce2\u5e02',value:100},");
            sb.append("{name: '\u6e29\u5dde\u5e02',value:100},");
            sb.append("{name:'\u5609\u5174\u5e02',value:300}");
            sb.append("]}");
            sb.append("]}");
        }
        return sb.toString();
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{title:{");
        sb.append("text:'iphone\u9500\u91cf',");
        sb.append("left: 'center'");
        sb.append("},");
        sb.append("animation:false,");
        sb.append("initTimes:0,");
        sb.append("tooltip : {");
        sb.append("trigger: 'item'");
        sb.append("},");
        sb.append("legend: {");
        sb.append("orient: 'vertical',");
        sb.append("left: 'left',");
        sb.append("show:false,");
        sb.append("data:['iphone3','iphone4','iphone5'],type:'scroll'");
        sb.append("},");
        sb.append("visualMap: {");
        sb.append("min:0,");
        sb.append("max: 2500,");
        sb.append("left: 'left',");
        sb.append("top: 'bottom',");
        sb.append("text:['\u9ad8','\u4f4e'],");
        sb.append("show:false,");
        sb.append("calculable : true");
        sb.append("},");
        sb.append("series:[");
        sb.append("{");
        sb.append("name:'iphone3',");
        sb.append("type: 'map',");
        sb.append("mapType: 'china',");
        sb.append("roam: false,");
        sb.append("label: {");
        sb.append("normal:{");
        sb.append("show: false");
        sb.append("},");
        sb.append("emphasis:{");
        sb.append("show: true");
        sb.append("}");
        sb.append("},");
        sb.append("data:[");
        sb.append("{name:'\u5317\u4eac',value:200},");
        sb.append("{name:'\u5929\u6d25',value:300},");
        sb.append("{name:'\u4e0a\u6d77',value:400},");
        sb.append("{name:'\u91cd\u5e86',value:100},");
        sb.append("{name:'\u6cb3\u5317',value:100},");
        sb.append("{name:'\u6cb3\u5357',value:100},");
        sb.append("{name:'\u4e91\u5357',value:100},");
        sb.append("{name:'\u8fbd\u5b81',value:100},");
        sb.append("{name:'\u9ed1\u9f99\u6c5f',value:100},");
        sb.append("{name:'\u6e56\u5357',value:100},");
        sb.append("{name:'\u5b89\u5fbd',value:100},");
        sb.append("{name:'\u5c71\u4e1c',value:100},");
        sb.append("{name:'\u65b0\u7586',value:100},");
        sb.append("{name:'\u6c5f\u82cf',value:100},");
        sb.append("{name:'\u6d59\u6c5f',value:100},");
        sb.append("{name:'\u6c5f\u897f',value:100},");
        sb.append("{name:'\u6e56\u5317',value:100},");
        sb.append("{name:'\u5e7f\u897f',value:100},");
        sb.append("{name:'\u7518\u8083',value:100},");
        sb.append("{name:'\u5c71\u897f',value:100},");
        sb.append("{name:'\u5185\u8499\u53e4',value:100},");
        sb.append("{name:'\u9655\u897f',value:100},");
        sb.append("{name:'\u5409\u6797',value:100},");
        sb.append("{name:'\u798f\u5efa',value:100},");
        sb.append("{name:'\u8d35\u5dde',value:100},");
        sb.append("{name:'\u5e7f\u4e1c',value:100},");
        sb.append("{name:'\u9752\u6d77',value:100},");
        sb.append("{name:'\u897f\u85cf',value:100},");
        sb.append("{name:'\u56db\u5ddd',value:100},");
        sb.append("{name:'\u5b81\u590f',value:100},");
        sb.append("{name:'\u6d77\u5357',value:100},");
        sb.append("{name:'\u53f0\u6e7e',value:100},");
        sb.append("{name:'\u9999\u6e2f',value:100},");
        sb.append("{name:'\u6fb3\u95e8',value:100}");
        sb.append("]");
        sb.append("},");
        sb.append("{");
        sb.append("name:'iphone4',");
        sb.append("type:'map',");
        sb.append("mapType:'china',");
        sb.append("label: {");
        sb.append("normal:{");
        sb.append("show: false");
        sb.append("},");
        sb.append("emphasis: {");
        sb.append("show: true");
        sb.append("}");
        sb.append("},");
        sb.append("data:[");
        sb.append("{name: '\u5317\u4eac',value:100},");
        sb.append("{name: '\u5929\u6d25',value:100},");
        sb.append("{name: '\u4e0a\u6d77',value:100},");
        sb.append("{name: '\u91cd\u5e86',value:100},");
        sb.append("{name: '\u6cb3\u5317',value:100},");
        sb.append("{name: '\u5b89\u5fbd',value:100},");
        sb.append("{name: '\u65b0\u7586',value:100},");
        sb.append("{name: '\u6d59\u6c5f',value:100},");
        sb.append("{name: '\u6c5f\u897f',value:100},");
        sb.append("{name: '\u5c71\u897f',value:100},");
        sb.append("{name: '\u5185\u8499\u53e4',value:100},");
        sb.append("{name: '\u5409\u6797',value:100},");
        sb.append("{name: '\u798f\u5efa',value:100},");
        sb.append("{name: '\u5e7f\u4e1c',value:100},");
        sb.append("{name: '\u897f\u85cf',value:100},");
        sb.append("{name: '\u56db\u5ddd',value:100},");
        sb.append("{name: '\u5b81\u590f',value:100},");
        sb.append("{name: '\u9999\u6e2f',value:100},");
        sb.append("{name: '\u6fb3\u95e8',value:100}");
        sb.append("]");
        sb.append("},");
        sb.append("{");
        sb.append("name: 'iphone5',");
        sb.append("type: 'map',");
        sb.append("mapType: 'china',");
        sb.append("label: {");
        sb.append("normal:{");
        sb.append("show: false");
        sb.append("},");
        sb.append("emphasis:{");
        sb.append("show: true");
        sb.append("}");
        sb.append("},");
        sb.append("data:[");
        sb.append("{name: '\u5317\u4eac',value:100},");
        sb.append("{name: '\u5929\u6d25',value:100},");
        sb.append("{name: '\u4e0a\u6d77',value:100},");
        sb.append("{name: '\u5e7f\u4e1c',value:100},");
        sb.append("{name: '\u53f0\u6e7e',value:100},");
        sb.append("{name: '\u9999\u6e2f',value:100},");
        sb.append("{name: '\u6fb3\u95e8',value:100}");
        sb.append("]}");
        sb.append("]}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        Set keySet;
        JSONObject hyperLinkObj;
        JSONObject backColorObj;
        path = path.replace(".html", ".plugin");
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String showLabel = optionObject.getString("showLabel");
        String area = optionObject.getString("area");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legend = legendArray.getJSONObject(0);
        JSONArray legendData = new JSONArray();
        for (int i = 0; i < seriesDatas.length; ++i) {
            legendData.add((Object)seriesDatas[i]);
        }
        legend.put("data", (Object)legendData);
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            if (optionObject.containsKey((Object)"isParam")) {
                String are = optionObject.getString("paramValue");
                seriesObject.put("mapType", (Object)are);
                seriesObject.put("area", (Object)are);
                area = are;
            } else {
                seriesObject.put("mapType", (Object)area);
            }
            seriesObject.put("type", (Object)"map");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (showLabel != null && showLabel.equals("true")) {
                JSONObject showLabelObj = new JSONObject();
                showLabelObj.put("show", (Object)true);
                showLabelObj.put("formatter", (Object)labelFormatter);
                seriesObject.put("label", (Object)showLabelObj);
            }
            if (optionObject.containsKey((Object)"map-top")) {
                String top = optionObject.getString("map-top");
                seriesObject.put("top", (Object)top);
            }
            if (optionObject.containsKey((Object)"map-bottom")) {
                String bottom = optionObject.getString("map-bottom");
                seriesObject.put("bottom", (Object)bottom);
            }
            if (optionObject.containsKey((Object)"map-left")) {
                String left = optionObject.getString("map-left");
                seriesObject.put("left", (Object)left);
            }
            if (optionObject.containsKey((Object)"map-right")) {
                String right = optionObject.getString("map-right");
                seriesObject.put("right", (Object)right);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                JSONObject dataObject = new JSONObject();
                String cData = categoryDatas[j];
                if ("china".equals(area)) {
                    if (cData.endsWith("\u7701")) {
                        cData = cData.substring(0, cData.length() - 1);
                    } else if (cData.endsWith("\u76f4\u8f96\u5e02")) {
                        cData = cData.substring(0, cData.length() - 3);
                    } else if (cData.endsWith("\u5e02")) {
                        cData = cData.substring(0, cData.length() - 1);
                    } else if (cData.endsWith("\u56de\u65cf\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    } else if (cData.endsWith("\u58ee\u65cf\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    } else if (cData.endsWith("\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 6);
                    } else if (cData.endsWith("\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 3);
                    } else if (cData.endsWith("\u7279\u522b\u884c\u653f\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    }
                }
                dataObject.put("name", (Object)cData);
                dataObject.put("value", (Object)valueDatas[i + j * seriesDatas.length]);
                seriesDataArray.add((Object)dataObject);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        optionObject.put("series", (Object)seriesArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsArray.add((Object)(jsResourcePath + "/echarts-5.4.2.min.js"));
        jsArray.add((Object)(jsResourcePath + "/map/china.js"));
        jsArray.add((Object)(jsResourcePath + "/map/anhui.js"));
        jsArray.add((Object)(jsResourcePath + "/map/aomen.js"));
        jsArray.add((Object)(jsResourcePath + "/map/beijing.js"));
        jsArray.add((Object)(jsResourcePath + "/map/chongqing.js"));
        jsArray.add((Object)(jsResourcePath + "/map/fujian.js"));
        jsArray.add((Object)(jsResourcePath + "/map/gansu.js"));
        jsArray.add((Object)(jsResourcePath + "/map/guangdong.js"));
        jsArray.add((Object)(jsResourcePath + "/map/guangxi.js"));
        jsArray.add((Object)(jsResourcePath + "/map/guizhou.js"));
        jsArray.add((Object)(jsResourcePath + "/map/hainan.js"));
        jsArray.add((Object)(jsResourcePath + "/map/hebei.js"));
        jsArray.add((Object)(jsResourcePath + "/map/heilongjiang.js"));
        jsArray.add((Object)(jsResourcePath + "/map/henan.js"));
        jsArray.add((Object)(jsResourcePath + "/map/hubei.js"));
        jsArray.add((Object)(jsResourcePath + "/map/hunan.js"));
        jsArray.add((Object)(jsResourcePath + "/map/jiangsu.js"));
        jsArray.add((Object)(jsResourcePath + "/map/jiangxi.js"));
        jsArray.add((Object)(jsResourcePath + "/map/jilin.js"));
        jsArray.add((Object)(jsResourcePath + "/map/liaoning.js"));
        jsArray.add((Object)(jsResourcePath + "/map/neimenggu.js"));
        jsArray.add((Object)(jsResourcePath + "/map/ningxia.js"));
        jsArray.add((Object)(jsResourcePath + "/map/qinghai.js"));
        jsArray.add((Object)(jsResourcePath + "/map/shandong.js"));
        jsArray.add((Object)(jsResourcePath + "/map/shanghai.js"));
        jsArray.add((Object)(jsResourcePath + "/map/shanxi.js"));
        jsArray.add((Object)(jsResourcePath + "/map/shanxi1.js"));
        jsArray.add((Object)(jsResourcePath + "/map/sichuan.js"));
        jsArray.add((Object)(jsResourcePath + "/map/tianjin.js"));
        jsArray.add((Object)(jsResourcePath + "/map/taiwan.js"));
        jsArray.add((Object)(jsResourcePath + "/map/xianggang.js"));
        jsArray.add((Object)(jsResourcePath + "/map/xinjiang.js"));
        jsArray.add((Object)(jsResourcePath + "/map/xizang.js"));
        jsArray.add((Object)(jsResourcePath + "/map/yunnan.js"));
        jsArray.add((Object)(jsResourcePath + "/map/zhejiang.js"));
        jsBuffer.append(jsArray.toString());
        cssBuffer.append(new JSONArray().toString());
        long time = new Random().nextLong();
        if (time < 0L) {
            time = 0L - time;
        }
        domBuffer.append("<div id='main_" + time + "' style='width:100%;height:100%;'></div>");
        scriptBuffer.append("var myChart_" + time + " = echarts.init(document.getElementById('main_" + time + "'));");
        scriptBuffer.append("var option_" + time + " = ");
        scriptBuffer.append(optionObject.toString());
        scriptBuffer.append(";");
        scriptBuffer.append("myChart_" + time + ".setOption(option_" + time + ");");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        String repaintRegions = reportInfoObj.getString("repaintRegions");
        JSONObject repaintRegionsObj = JSONObject.parseObject((String)repaintRegions);
        if (hyperLinkArray != null && repaintRegionsObj != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ");");
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1');");
            scriptBuffer.append("});");
        } else if (repaintRegionsObj != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        } else if (hyperLinkArray != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);});");
        }
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write("");
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        String resultStr = null;
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String showLabel = optionObject.getString("showLabel");
        String area = optionObject.getString("area");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legend = legendArray.getJSONObject(0);
        JSONArray legendData = new JSONArray();
        for (int i = 0; i < seriesDatas.length; ++i) {
            legendData.add((Object)seriesDatas[i]);
        }
        legend.put("data", (Object)legendData);
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            if (optionObject.containsKey((Object)"isParam")) {
                String are = optionObject.getString("paramValue");
                seriesObject.put("mapType", (Object)are);
                seriesObject.put("area", (Object)are);
                area = are;
            } else {
                seriesObject.put("mapType", (Object)area);
            }
            seriesObject.put("type", (Object)"map");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (showLabel != null && showLabel.equals("true")) {
                JSONObject showLabelObj = new JSONObject();
                showLabelObj.put("show", (Object)true);
                showLabelObj.put("formatter", (Object)labelFormatter);
                seriesObject.put("label", (Object)showLabelObj);
            }
            if (optionObject.containsKey((Object)"map-top")) {
                String top = optionObject.getString("map-top");
                seriesObject.put("top", (Object)top);
            }
            if (optionObject.containsKey((Object)"map-bottom")) {
                String bottom = optionObject.getString("map-bottom");
                seriesObject.put("bottom", (Object)bottom);
            }
            if (optionObject.containsKey((Object)"map-left")) {
                String left = optionObject.getString("map-left");
                seriesObject.put("left", (Object)left);
            }
            if (optionObject.containsKey((Object)"map-right")) {
                String right = optionObject.getString("map-right");
                seriesObject.put("right", (Object)right);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                JSONObject dataObject = new JSONObject();
                String cData = categoryDatas[j];
                if ("china".equals(area)) {
                    if (cData.endsWith("\u7701")) {
                        cData = cData.substring(0, cData.length() - 1);
                    } else if (cData.endsWith("\u76f4\u8f96\u5e02")) {
                        cData = cData.substring(0, cData.length() - 3);
                    } else if (cData.endsWith("\u5e02")) {
                        cData = cData.substring(0, cData.length() - 1);
                    } else if (cData.endsWith("\u56de\u65cf\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    } else if (cData.endsWith("\u58ee\u65cf\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    } else if (cData.endsWith("\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 6);
                    } else if (cData.endsWith("\u81ea\u6cbb\u533a")) {
                        cData = cData.substring(0, cData.length() - 3);
                    } else if (cData.endsWith("\u7279\u522b\u884c\u653f\u533a")) {
                        cData = cData.substring(0, cData.length() - 5);
                    }
                }
                dataObject.put("name", (Object)cData);
                dataObject.put("value", (Object)valueDatas[i + j * seriesDatas.length]);
                seriesDataArray.add((Object)dataObject);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        optionObject.put("series", (Object)seriesArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/china.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/anhui.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/aomen.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/beijing.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/chongqing.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/fujian.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/gansu.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/guangdong.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/guangxi.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/guizhou.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hainan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hebei.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/heilongjiang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/henan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hubei.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/hunan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/jiangsu.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/jiangxi.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/jilin.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/liaoning.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/neimenggu.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/ningxia.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/qinghai.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shandong.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shanghai.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shanxi.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/shanxi1.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/sichuan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/tianjin.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/taiwan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/xianggang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/xinjiang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/xizang.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/yunnan.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/map/zhejiang.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(optionObject.toString());
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u4e2d\u56fd\u5730\u56fe";
    }

    public static String getClassName() {
        return "Map";
    }

    public static void main(String[] args) {
        System.out.println(Map.generateDefaultOptionByArea("\u5317\u4eac"));
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        String area = optionJson.getString("area");
        if (area == null) {
            area = "china";
        } else if (area.contains("@")) {
            area = "china";
        }
        JSONObject defaultJson = JSONObject.parseObject((String)Map.generateDefaultOptionByArea(area));
        JSONArray seriesArray = optionJson.getJSONArray("series");
        JSONArray seriesDefaultObj = (JSONArray)defaultJson.get((Object)"series");
        for (int i = 0; i < seriesDefaultObj.size(); ++i) {
            JSONObject seriesObject = seriesDefaultObj.getJSONObject(i);
            if (optionJson.containsKey((Object)"labelShow")) {
                boolean flag = optionJson.getBoolean("labelShow");
                JSONObject labelObject = new JSONObject();
                labelObject.put("show", (Object)flag);
                seriesObject.put("label", (Object)labelObject);
            }
            if (optionJson.containsKey((Object)"map-top")) {
                String top = optionJson.getString("map-top");
                seriesObject.put("top", (Object)top);
            }
            if (optionJson.containsKey((Object)"map-bottom")) {
                String bottom = optionJson.getString("map-bottom");
                seriesObject.put("bottom", (Object)bottom);
            }
            if (optionJson.containsKey((Object)"map-left")) {
                String left = optionJson.getString("map-left");
                seriesObject.put("left", (Object)left);
            }
            if (!optionJson.containsKey((Object)"map-right")) continue;
            String right = optionJson.getString("map-right");
            seriesObject.put("right", (Object)right);
        }
        optionJson.put("series", (Object)seriesDefaultObj);
        return optionJson.toString();
    }
}

