/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.postgresql.core.EncodingPredictor;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;
import org.postgresql.util.GT;

public class ServerErrorMessage
implements Serializable {
    private static Log LOGGER = Logger.getLogger(ServerErrorMessage.class.getName());
    private static final Character SEVERITY = Character.valueOf('S');
    private static final Character MESSAGE = Character.valueOf('M');
    private static final Character DETAIL = Character.valueOf('D');
    private static final Character HINT = Character.valueOf('H');
    private static final Character POSITION = Character.valueOf('P');
    private static final Character WHERE = Character.valueOf('W');
    private static final Character FILE = Character.valueOf('F');
    private static final Character LINE = Character.valueOf('L');
    private static final Character ROUTINE = Character.valueOf('R');
    private static final Character SQLSTATE = Character.valueOf('C');
    private static final Character ERRORCODE = Character.valueOf('c');
    private static final Character INTERNAL_POSITION = Character.valueOf('p');
    private static final Character INTERNAL_QUERY = Character.valueOf('q');
    private static final Character SOCKET_ADDRESS = Character.valueOf('a');
    private final Map<Character, String> m_mesgParts = new HashMap<Character, String>();
    private String query;

    public ServerErrorMessage(EncodingPredictor.DecodeResult serverError, String socketAddress) {
        this(serverError.result, socketAddress);
        if (serverError.encoding != null) {
            this.m_mesgParts.put(MESSAGE, this.m_mesgParts.get(MESSAGE) + GT.tr(" (pgjdbc: autodetected server-encoding to be {0}, if the message is not readable, please check database logs and/or host, port, dbname, user, password, pg_hba.conf)", serverError.encoding));
        }
    }

    public ServerErrorMessage(String p_serverError) {
        char[] l_chars = p_serverError.toCharArray();
        int l_length = l_chars.length;
        for (int l_pos = 0; l_pos < l_length; ++l_pos) {
            char l_mesgType = l_chars[l_pos];
            if (l_mesgType == '\u0000') continue;
            int l_startString = ++l_pos;
            while (l_pos < l_length && l_chars[l_pos] != '\u0000') {
                ++l_pos;
            }
            String l_mesgPart = new String(l_chars, l_startString, l_pos - l_startString);
            this.m_mesgParts.put(Character.valueOf(l_mesgType), l_mesgPart);
        }
    }

    public ServerErrorMessage(String p_serverError, String socketAddress) {
        this(p_serverError);
        this.m_mesgParts.put(SOCKET_ADDRESS, socketAddress);
    }

    public String getSQLState() {
        return this.m_mesgParts.get(SQLSTATE);
    }

    public String getERRORCODE() {
        return this.m_mesgParts.get(ERRORCODE);
    }

    public String getMessage() {
        return this.m_mesgParts.get(MESSAGE);
    }

    public String getSeverity() {
        return this.m_mesgParts.get(SEVERITY);
    }

    public String getDetail() {
        return this.m_mesgParts.get(DETAIL);
    }

    public String getHint() {
        return this.m_mesgParts.get(HINT);
    }

    public int getPosition() {
        return this.getIntegerPart(POSITION);
    }

    public String getWhere() {
        return this.m_mesgParts.get(WHERE);
    }

    public String getFile() {
        return this.m_mesgParts.get(FILE);
    }

    public int getLine() {
        return this.getIntegerPart(LINE);
    }

    public String getRoutine() {
        return this.m_mesgParts.get(ROUTINE);
    }

    public String getInternalQuery() {
        return this.m_mesgParts.get(INTERNAL_QUERY);
    }

    public int getInternalPosition() {
        return this.getIntegerPart(INTERNAL_POSITION);
    }

    private int getIntegerPart(Character c) {
        String s = this.m_mesgParts.get(c);
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public void setErrorQuery(String query) {
        this.query = query;
    }

    private String lineErrorMessage() {
        StringBuilder lineMessBuilder = new StringBuilder();
        int errIndex = Math.max(this.getPosition(), this.getInternalPosition());
        if (errIndex == 0) {
            return "";
        }
        String message = this.getInternalQuery();
        String queryStr = this.query;
        ErrMessageResult errMessageResult = message == null ? this.errMessageForQuery(queryStr, errIndex) : this.errMessageForInternalQuery(message, errIndex, queryStr);
        String lineStr = String.format(Locale.ROOT, "Line %d:", errMessageResult.getLine());
        char[] location = new char[lineStr.length() + errMessageResult.getScroffset()];
        for (int i = 0; i < lineStr.length() + errMessageResult.getScroffset(); ++i) {
            location[i] = 32;
        }
        String locationStr = String.valueOf(location) + '^';
        lineMessBuilder.append("\n  ").append(lineStr).append(" ").append(errMessageResult.getLineMess());
        lineMessBuilder.append("\n  ").append(locationStr);
        return lineMessBuilder.toString();
    }

    private ErrMessageResult errMessageForQuery(String queryStr, int errIndex) {
        int line = 1;
        int scroffset = 0;
        String lineMess = queryStr;
        char[] chars = queryStr.toCharArray();
        for (int i = 0; i <= Math.min(errIndex, chars.length - 1); ++i) {
            char ch = chars[i];
            if (ch != '\n') continue;
            ++line;
            scroffset = errIndex - (i + 1);
            lineMess = lineMess.substring(lineMess.indexOf("\n") + 1);
        }
        if (scroffset == 0) {
            scroffset = errIndex;
        }
        if (lineMess.contains("\n")) {
            lineMess = lineMess.substring(0, lineMess.indexOf("\n"));
        }
        return new ErrMessageResult(line, scroffset, lineMess);
    }

    private ErrMessageResult errMessageForInternalQuery(String message, int errIndex, String queryStr) {
        int line = 1;
        int scroffset = 0;
        String lineMess = null;
        String errStr = message.substring(errIndex);
        if ((message = message.trim()).startsWith("DECLARE")) {
            message = message.substring(message.indexOf("DECLARE") + 7).trim();
        }
        if (message.startsWith("\n")) {
            message = message.substring(1);
        }
        if (queryStr.startsWith("\n")) {
            queryStr = queryStr.substring(1);
        }
        String[] lines = queryStr.split("\n");
        if (errStr.contains("\n")) {
            errStr = errStr.substring(0, errStr.indexOf("\n"));
        }
        block0: for (int i = 0; i < lines.length; ++i) {
            if (queryStr.startsWith(message)) {
                line = i + 1;
                for (String errLine : queryStr.split("\n")) {
                    if (!errLine.contains(errStr)) continue;
                    lineMess = errLine;
                    scroffset = lineMess.indexOf(errStr) == 0 ? 1 : lineMess.indexOf(errStr);
                    break block0;
                }
                break;
            }
            queryStr = queryStr.substring(queryStr.indexOf("\n") + 1);
        }
        return new ErrMessageResult(line, scroffset, lineMess);
    }

    public String toString() {
        StringBuilder l_totalMessage = new StringBuilder();
        String l_message = this.m_mesgParts.get(SOCKET_ADDRESS);
        l_message = this.m_mesgParts.get(SEVERITY);
        if (l_message != null) {
            l_totalMessage.append(l_message).append(": ");
        }
        if ((l_message = this.m_mesgParts.get(MESSAGE)) != null) {
            l_totalMessage.append(l_message);
        }
        if (this.query != null) {
            l_totalMessage.append(this.lineErrorMessage());
        }
        if ((l_message = this.m_mesgParts.get(DETAIL)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Detail: {0}", l_message));
        }
        if ((l_message = this.m_mesgParts.get(HINT)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Hint: {0}", l_message));
        }
        if ((l_message = this.m_mesgParts.get(POSITION)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Position: {0}", l_message));
        }
        if ((l_message = this.m_mesgParts.get(WHERE)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Where: {0}", l_message));
        }
        if (LOGGER.isTraceEnabled()) {
            String l_internalPosition;
            String l_internalQuery = this.m_mesgParts.get(INTERNAL_QUERY);
            if (l_internalQuery != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Internal Query: {0}", l_internalQuery));
            }
            if ((l_internalPosition = this.m_mesgParts.get(INTERNAL_POSITION)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Internal Position: {0}", l_internalPosition));
            }
            String l_file = this.m_mesgParts.get(FILE);
            String l_line = this.m_mesgParts.get(LINE);
            String l_routine = this.m_mesgParts.get(ROUTINE);
            if (l_file != null || l_line != null || l_routine != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Location: File: {0}, Routine: {1}, Line: {2}", l_file, l_routine, l_line));
            }
            if ((l_message = this.m_mesgParts.get(SQLSTATE)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Server SQLState: {0}", l_message));
            }
        }
        return l_totalMessage.toString();
    }

    private static class ErrMessageResult {
        private int line;
        private int scroffset;
        private String lineMess;

        public ErrMessageResult(int line, int scroffset, String lineMess) {
            this.line = line;
            this.scroffset = scroffset;
            this.lineMess = lineMess;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getLine() {
            return this.line;
        }

        public int getScroffset() {
            return this.scroffset;
        }

        public void setScroffset(int scroffset) {
            this.scroffset = scroffset;
        }

        public String getLineMess() {
            return this.lineMess;
        }

        public void setLineMess(String lineMess) {
            this.lineMess = lineMess;
        }
    }
}

