/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.struct;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.postgresql.struct.FieldMeta;
import org.postgresql.struct.PgCompositeMetaData;

public class StructDescriptor {
    private final PgCompositeMetaData metaData;

    private StructDescriptor(PgCompositeMetaData metaData) {
        this.metaData = metaData;
    }

    public static StructDescriptor createDescriptor(String fullTypeName, Connection conn) throws SQLException {
        List<FieldMeta> fields = StructDescriptor.loadFieldsFromPg(fullTypeName, conn);
        return new StructDescriptor(new PgCompositeMetaData(fields));
    }

    public ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    private static List<FieldMeta> loadFieldsFromPg(String fullTypeName, Connection conn) throws SQLException {
        String schema = null;
        String type = fullTypeName;
        if (fullTypeName.contains(".")) {
            String[] parts = fullTypeName.split("\\.");
            schema = parts[0];
            type = parts[1];
        }
        String sql = "SELECT a.attnum, a.attname,        t.typname AS typename,        t.typlen, a.atttypmod, a.attnotnull,        format_type(a.atttypid, a.atttypmod) AS formatted_type FROM pg_type ct JOIN pg_namespace n ON ct.typnamespace = n.oid JOIN pg_class c ON c.oid = ct.typrelid JOIN pg_attribute a ON a.attrelid = c.oid JOIN pg_type t ON t.oid = a.atttypid WHERE ct.typname = ? " + (schema != null ? "AND n.nspname = ? " : "") + "AND a.attnum > 0 AND NOT a.attisdropped ORDER BY a.attnum";
        ArrayList<FieldMeta> list = new ArrayList<FieldMeta>();
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, type);
            if (schema != null) {
                ps.setString(2, schema);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    FieldMeta f = new FieldMeta();
                    f.index = rs.getInt("attnum");
                    f.name = rs.getString("attname");
                    f.typeName = rs.getString("typename");
                    f.typeLength = rs.getInt("typlen");
                    f.typeMod = rs.getInt("atttypmod");
                    f.notNull = rs.getBoolean("attnotnull");
                    f.formattedType = rs.getString("formatted_type");
                    list.add(f);
                }
            }
        }
        return list;
    }
}

