/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.struct;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.postgresql.struct.FieldMeta;

public class PgCompositeMetaData
implements ResultSetMetaData {
    private final List<FieldMeta> fields;

    public PgCompositeMetaData(List<FieldMeta> fields) {
        this.fields = fields;
    }

    @Override
    public int getColumnCount() {
        return this.fields.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnName(int i) {
        return this.fields.get((int)(i - 1)).name;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int i) {
        return 12;
    }

    @Override
    public String getColumnTypeName(int i) {
        return this.fields.get((int)(i - 1)).typeName;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnDisplaySize(int i) {
        return this.fields.get((int)(i - 1)).typeLength;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int i) {
        return this.parsePrecision(this.fields.get(i - 1));
    }

    @Override
    public int getScale(int i) {
        return this.parseScale(this.fields.get(i - 1));
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int isNullable(int i) {
        return this.fields.get((int)(i - 1)).notNull ? 0 : 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    private int parsePrecision(FieldMeta f) {
        return "numeric".equals(f.typeName) ? f.typeMod - 4 >> 16 & 0xFFFF : 0;
    }

    private int parseScale(FieldMeta f) {
        return "numeric".equals(f.typeName) ? f.typeMod - 4 & 0xFFFF : 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

