/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pgvector;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.postgresql.PGConnection;
import org.postgresql.pgvector.PGhalfvec;
import org.postgresql.pgvector.PGsparsevec;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;

public class PGvector
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    private float[] vec;

    public PGvector() {
        this.type = "floatvector";
    }

    public PGvector(float[] v) {
        this();
        this.vec = v;
    }

    public <T extends Number> PGvector(List<T> v) {
        this();
        if (v == null) {
            this.vec = null;
        } else {
            this.vec = new float[v.size()];
            int i = 0;
            for (Number f : v) {
                this.vec[i++] = f.floatValue();
            }
        }
    }

    public PGvector(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s == null) {
            this.vec = null;
        } else {
            String[] sp = s.substring(1, s.length() - 1).split(",");
            this.vec = new float[sp.length];
            for (int i = 0; i < sp.length; ++i) {
                this.vec[i] = Float.parseFloat(sp[i]);
            }
        }
    }

    @Override
    public String getValue() {
        if (this.vec == null) {
            return null;
        }
        return Arrays.toString(this.vec).replace(" ", "");
    }

    @Override
    public int lengthInBytes() {
        return this.vec == null ? 0 : 4 + this.vec.length * 4;
    }

    @Override
    public void setByteValue(byte[] value, int offset) throws SQLException {
        int dim = ByteConverter.int2(value, offset);
        short unused = ByteConverter.int2(value, offset + 2);
        if (unused != 0) {
            throw new SQLException("expected unused to be 0");
        }
        this.vec = new float[dim];
        for (int i = 0; i < dim; ++i) {
            this.vec[i] = ByteConverter.float4(value, offset + 4 + i * 4);
        }
    }

    @Override
    public void toBytes(byte[] bytes, int offset) {
        if (this.vec == null) {
            return;
        }
        ByteConverter.int2(bytes, offset, this.vec.length);
        ByteConverter.int2(bytes, offset + 2, 0);
        for (int i = 0; i < this.vec.length; ++i) {
            ByteConverter.float4(bytes, offset + 4 + i * 4, this.vec[i]);
        }
    }

    public float[] toArray() {
        return this.vec;
    }

    public static void addVectorType(Connection conn) throws SQLException {
        conn.unwrap(PGConnection.class).addDataType("floatvector", PGvector.class);
    }

    public static void registerTypes(Connection conn) throws SQLException {
        PGvector.addVectorType(conn);
        conn.unwrap(PGConnection.class).addDataType("halfvec", PGhalfvec.class);
        conn.unwrap(PGConnection.class).addDataType("sparsevec", PGsparsevec.class);
    }
}

