/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import org.postgresql.core.PGStream;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.TypeTransferModeRegistry;
import org.postgresql.core.v3.V3ParameterList;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGpoint;
import org.postgresql.jdbc.UUIDArrayAssistant;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.StreamWrapper;

class SimpleParameterList
implements V3ParameterList {
    private static Log LOGGER = Logger.getLogger(SimpleParameterList.class.getName());
    private static final byte IN = 1;
    private static final byte OUT = 2;
    private static final byte INOUT = 3;
    private static final byte TEXT = 0;
    private static final byte BINARY = 4;
    private final String[] paramLiteralValues;
    private final Object[] paramValues;
    private final int[] paramTypes;
    private final byte[] flags;
    private final byte[][] encoded;
    private final TypeTransferModeRegistry transferModeRegistry;
    private final boolean[] isACompatibilityFunctions;
    private final String[] compatibilityModes;
    private static final Object NULL_OBJECT = new Object();
    private int pos = 0;

    SimpleParameterList(int paramCount, TypeTransferModeRegistry transferModeRegistry) {
        this.paramLiteralValues = new String[paramCount];
        this.paramValues = new Object[paramCount];
        this.paramTypes = new int[paramCount];
        this.encoded = new byte[paramCount][];
        this.flags = new byte[paramCount];
        this.transferModeRegistry = transferModeRegistry;
        this.compatibilityModes = new String[paramCount];
        this.isACompatibilityFunctions = new boolean[paramCount];
    }

    @Override
    public void registerOutParameter(int index, int sqlType) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        int n = index - 1;
        this.flags[n] = (byte)(this.flags[n] | 2);
    }

    @Override
    public void bindRegisterOutParameter(int index, int oid, boolean isACompatibilityFunction) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramTypes[index - 1] = oid;
        this.compatibilityModes[index - 1] = "ORA";
        this.isACompatibilityFunctions[index - 1] = isACompatibilityFunction;
    }

    private void bind(int index, Object value, int oid, byte binary) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.encoded[--index] = null;
        this.paramValues[index] = value;
        this.flags[index] = (byte)(this.direction(index) | 1 | binary);
        if (oid == 0 && this.paramTypes[index] != 0 && value == NULL_OBJECT) {
            return;
        }
        this.paramTypes[index] = oid;
        this.pos = index + 1;
    }

    @Override
    public int getParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public int getOutParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if ((this.direction(i) & 2) != 2) continue;
            ++count;
        }
        if (count == 0) {
            count = 1;
        }
        return count;
    }

    @Override
    public int getInParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void setIntParameter(int index, int value) throws SQLException {
        byte[] data = new byte[4];
        ByteConverter.int4(data, 0, value);
        this.bind(index, data, 23, (byte)4);
    }

    @Override
    public void setLiteralParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)0);
        this.saveLiteralValueForClientLogic(index, value);
    }

    @Override
    public void setStringParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)0);
        this.saveLiteralValueForClientLogic(index, value);
    }

    @Override
    public void setBinaryParameter(int index, byte[] value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)4);
    }

    @Override
    public void saveLiteralValueForClientLogic(int index, String value) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramLiteralValues[--index] = value;
    }

    @Override
    public String[] getLiteralValues() {
        return this.paramLiteralValues;
    }

    @Override
    public void setClientLogicBytea(int index, byte[] data, int offset, int length, int customOid) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), customOid, (byte)4);
    }

    @Override
    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 17, (byte)4);
    }

    @Override
    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        this.bind(index, new StreamWrapper(stream, length), 17, (byte)4);
    }

    @Override
    public void setBytea(int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 17, (byte)4);
    }

    @Override
    public void setBlob(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 88, (byte)4);
    }

    @Override
    public void setBlob(int index, InputStream stream, int length) throws SQLException {
        try {
            int i = Math.min(stream.available(), length);
            byte[] tmp = new byte[i];
            int len = stream.read(tmp);
            if (len == -1) {
                LOGGER.trace("Failed to read the inputstream:", new SQLException("Failed to read the inputstream"));
            }
            this.setBlob(index, tmp, 0, tmp.length);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void setText(int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 25, (byte)0);
    }

    @Override
    public void setNull(int index, int oid) throws SQLException {
        byte binaryTransfer = 0;
        if (oid == 88 || oid == 17) {
            binaryTransfer = 4;
        }
        if (this.transferModeRegistry.useBinaryForReceive(oid)) {
            binaryTransfer = 4;
        }
        this.bind(index, NULL_OBJECT, oid, binaryTransfer);
    }

    @Override
    public String toString(int index, boolean standardConformingStrings) {
        if (this.paramValues[--index] == null) {
            return "?";
        }
        if (this.paramValues[index] == NULL_OBJECT) {
            return "(NULL)";
        }
        if ((this.flags[index] & 4) == 4) {
            switch (this.paramTypes[index]) {
                case 21: {
                    short s = ByteConverter.int2((byte[])this.paramValues[index], 0);
                    return SimpleParameterList.quoteAndCast(Short.toString(s), "int2", standardConformingStrings);
                }
                case 23: {
                    int i = ByteConverter.int4((byte[])this.paramValues[index], 0);
                    return SimpleParameterList.quoteAndCast(Integer.toString(i), "int4", standardConformingStrings);
                }
                case 20: {
                    long l = ByteConverter.int8((byte[])this.paramValues[index], 0);
                    return SimpleParameterList.quoteAndCast(Long.toString(l), "int8", standardConformingStrings);
                }
                case 700: {
                    float f = ByteConverter.float4((byte[])this.paramValues[index], 0);
                    if (Float.isNaN(f)) {
                        return "('NaN'::real)";
                    }
                    return SimpleParameterList.quoteAndCast(Float.toString(f), "float", standardConformingStrings);
                }
                case 701: {
                    double d = ByteConverter.float8((byte[])this.paramValues[index], 0);
                    if (Double.isNaN(d)) {
                        return "('NaN'::double precision)";
                    }
                    return SimpleParameterList.quoteAndCast(Double.toString(d), "double precision", standardConformingStrings);
                }
                case 2950: {
                    String uuid = new UUIDArrayAssistant().buildElement((byte[])this.paramValues[index], 0, 16).toString();
                    return SimpleParameterList.quoteAndCast(uuid, "uuid", standardConformingStrings);
                }
                case 600: {
                    PGpoint pgPoint = new PGpoint();
                    pgPoint.setByteValue((byte[])this.paramValues[index], 0);
                    return SimpleParameterList.quoteAndCast(pgPoint.toString(), "point", standardConformingStrings);
                }
                case 603: {
                    PGbox pgBox = new PGbox();
                    pgBox.setByteValue((byte[])this.paramValues[index], 0);
                    return SimpleParameterList.quoteAndCast(pgBox.toString(), "box", standardConformingStrings);
                }
            }
            return "?";
        }
        String param = this.paramValues[index].toString();
        int paramType = this.paramTypes[index];
        if (paramType == 1114) {
            return SimpleParameterList.quoteAndCast(param, "timestamp", standardConformingStrings);
        }
        if (paramType == 1184) {
            return SimpleParameterList.quoteAndCast(param, "timestamp with time zone", standardConformingStrings);
        }
        if (paramType == 1083) {
            return SimpleParameterList.quoteAndCast(param, "time", standardConformingStrings);
        }
        if (paramType == 1266) {
            return SimpleParameterList.quoteAndCast(param, "time with time zone", standardConformingStrings);
        }
        if (paramType == 1082) {
            return SimpleParameterList.quoteAndCast(param, "date", standardConformingStrings);
        }
        if (paramType == 1186) {
            return SimpleParameterList.quoteAndCast(param, "interval", standardConformingStrings);
        }
        return SimpleParameterList.quoteAndCast(param, null, standardConformingStrings);
    }

    private static String quoteAndCast(String text, String type, boolean standardConformingStrings) {
        StringBuilder sb = new StringBuilder((text.length() + 10) / 10 * 11);
        sb.append("('");
        try {
            Utils.escapeLiteral(sb, text, standardConformingStrings);
        }
        catch (SQLException e) {
            sb.append('\u0000');
        }
        sb.append("'");
        if (type != null) {
            sb.append("::");
            sb.append(type);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2 || this.paramValues[i] != null) continue;
            throw new PSQLException(GT.tr("No value specified for parameter {0}.", i + 1), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void convertFunctionOutParameters() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) != 2) continue;
            if (this.compatibilityModes[i] != null && this.compatibilityModes[i].equalsIgnoreCase("ORA")) {
                if (this.isACompatibilityFunctions[i] && i == 0) {
                    this.paramTypes[i] = 2278;
                }
                this.paramValues[i] = "null";
                continue;
            }
            this.paramTypes[i] = 2278;
            this.paramValues[i] = "null";
        }
    }

    private static void streamBytea(PGStream pgStream, StreamWrapper wrapper) throws IOException {
        byte[] rawData = wrapper.getBytes();
        if (rawData != null) {
            pgStream.send(rawData, wrapper.getOffset(), wrapper.getLength());
            return;
        }
        pgStream.sendStream(wrapper.getStream(), wrapper.getLength());
    }

    @Override
    public int[] getTypeOIDs() {
        return this.paramTypes;
    }

    int getTypeOID(int index) {
        return this.paramTypes[index - 1];
    }

    boolean hasUnresolvedTypes() {
        for (int paramType : this.paramTypes) {
            if (paramType != 0) continue;
            return true;
        }
        return false;
    }

    void setResolvedType(int index, int oid) {
        if (this.paramTypes[index - 1] == 0) {
            this.paramTypes[index - 1] = oid;
        } else if (this.paramTypes[index - 1] != oid) {
            throw new IllegalArgumentException("Can't change resolved type for param: " + index + " from " + this.paramTypes[index - 1] + " to " + oid);
        }
    }

    boolean isNull(int index) {
        return this.paramValues[index - 1] == NULL_OBJECT;
    }

    boolean isBinary(int index) {
        return (this.flags[index - 1] & 4) != 0;
    }

    private byte direction(int index) {
        return (byte)(this.flags[index] & 3);
    }

    int getV3Length(int index) {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't getV3Length() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            return ((byte[])this.paramValues[index]).length;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            return ((StreamWrapper)this.paramValues[index]).getLength();
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encodeUTF8(this.paramValues[index].toString());
        }
        return this.encoded[index].length;
    }

    void writeV3Value(int index, PGStream pgStream) throws IOException {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't writeV3Value() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            pgStream.send((byte[])this.paramValues[index]);
            return;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            SimpleParameterList.streamBytea(pgStream, (StreamWrapper)this.paramValues[index]);
            return;
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encodeUTF8((String)this.paramValues[index]);
        }
        pgStream.send(this.encoded[index]);
    }

    @Override
    public ParameterList copy() {
        SimpleParameterList newCopy = new SimpleParameterList(this.paramValues.length, this.transferModeRegistry);
        System.arraycopy(this.paramLiteralValues, 0, newCopy.paramLiteralValues, 0, this.paramLiteralValues.length);
        System.arraycopy(this.paramValues, 0, newCopy.paramValues, 0, this.paramValues.length);
        System.arraycopy(this.paramTypes, 0, newCopy.paramTypes, 0, this.paramTypes.length);
        System.arraycopy(this.flags, 0, newCopy.flags, 0, this.flags.length);
        newCopy.pos = this.pos;
        return newCopy;
    }

    @Override
    public void clear() {
        Arrays.fill(this.paramValues, null);
        Arrays.fill(this.paramTypes, 0);
        Arrays.fill((Object[])this.encoded, null);
        Arrays.fill(this.flags, (byte)0);
        this.pos = 0;
    }

    @Override
    public SimpleParameterList[] getSubparams() {
        return null;
    }

    @Override
    public Object[] getValues() {
        return this.paramValues;
    }

    @Override
    public int[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public byte[] getFlags() {
        return this.flags;
    }

    @Override
    public byte[][] getEncoding() {
        return this.encoded;
    }

    @Override
    public void appendAll(ParameterList list) throws SQLException {
        if (list instanceof SimpleParameterList) {
            SimpleParameterList spl = (SimpleParameterList)list;
            int inParamCount = spl.getInParameterCount();
            if (this.pos + inParamCount > this.paramValues.length) {
                throw new PSQLException(GT.tr("Added parameters index out of range: {0}, number of columns: {1}.", this.pos + inParamCount, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
            }
            System.arraycopy(spl.getValues(), 0, this.paramValues, this.pos, inParamCount);
            System.arraycopy(spl.getParamTypes(), 0, this.paramTypes, this.pos, inParamCount);
            System.arraycopy(spl.getFlags(), 0, this.flags, this.pos, inParamCount);
            System.arraycopy(spl.getEncoding(), 0, this.encoded, this.pos, inParamCount);
            this.pos += inParamCount;
        }
    }

    public String toString() {
        StringBuilder ts = new StringBuilder("<[");
        if (this.paramValues.length > 0) {
            ts.append(this.toString(1, true));
            for (int c = 2; c <= this.paramValues.length; ++c) {
                ts.append(" ,").append(this.toString(c, true));
            }
        }
        ts.append("]>");
        return ts.toString();
    }
}

