/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Fall {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = Fall.generateDefaultOption();
            String clazzName = Fall.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-5.4.2.min.js'></script>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("var myChart = echarts.init(document.getElementById('main'));");
                sb.append("var option = ");
                sb.append(option + ";");
                sb.append("myChart.setOption(option);");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + Fall.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                JSONObject legendObject;
                JSONArray legend;
                JSONArray yAxis;
                JSONObject yAxisObject;
                JSONArray xAxis;
                JSONObject xAxisObject;
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                optionJSON.put("categoryData", realDataJSON.get((Object)"categoryData"));
                optionJSON.put("seriesData", realDataJSON.get((Object)"seriesData"));
                optionJSON.put("valueData", realDataJSON.get((Object)"valueData"));
                if (optionJSON.containsKey((Object)"xAxis") && (xAxisObject = (xAxis = optionJSON.getJSONArray("xAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    xAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"yAxis") && (yAxisObject = (yAxis = optionJSON.getJSONArray("yAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    yAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"series")) {
                    JSONObject seriesObject;
                    JSONArray seriesArray = optionJSON.getJSONArray("series");
                    if (seriesArray.size() > 0 && (seriesObject = seriesArray.getJSONObject(0)).containsKey((Object)"label")) {
                        JSONObject labelObject = seriesObject.getJSONObject("label");
                        if (labelObject.containsKey((Object)"show")) {
                            boolean flag = labelObject.getBoolean("show");
                            optionJSON.put("labelShow", (Object)flag);
                        }
                        if (labelObject.containsKey((Object)"color")) {
                            String labelColor = labelObject.getString("color");
                            optionJSON.put("labelColor", (Object)labelColor);
                        }
                        if (labelObject.containsKey((Object)"fontSize")) {
                            String fontSize = labelObject.getString("fontSize");
                            optionJSON.put("labelSize", (Object)fontSize);
                        }
                    }
                    optionJSON.remove((Object)"series");
                }
                if (optionJSON.containsKey((Object)"legend") && (legend = optionJSON.getJSONArray("legend")).size() != 0 && (legendObject = legend.getJSONObject(0)).containsKey((Object)"data")) {
                    legendObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"animation")) {
                    optionJSON.remove((Object)"animation");
                    optionJSON.put("animation", (Object)true);
                }
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{title: {");
        sb.append("    text: '\u6df1\u5733\u6708\u6700\u4f4e\u751f\u6d3b\u8d39\u7ec4\u6210'");
        sb.append("},");
        sb.append("animation:false,");
        sb.append("initTimes:0,");
        sb.append("tooltip : {");
        sb.append("    trigger: 'axis',");
        sb.append("            axisPointer : {");
        sb.append("        type : 'shadow'");
        sb.append("    },");
        sb.append("},");
        sb.append("xAxis: {");
        sb.append("    type : 'category',");
        sb.append("            splitLine: {show:false},");
        sb.append("    data : ['\u603b\u8d39\u7528','\u623f\u79df','\u6c34\u7535\u8d39','\u4ea4\u901a\u8d39','\u4f19\u98df\u8d39','\u65e5\u7528\u54c1\u6570']");
        sb.append("},");
        sb.append("yAxis: {");
        sb.append("    type : 'value'");
        sb.append("},");
        sb.append("series: [");
        sb.append("{");
        sb.append("    name: '\u8f85\u52a9',");
        sb.append("            type: 'bar',");
        sb.append("        stack:  '\u603b\u91cf',");
        sb.append("        itemStyle: {");
        sb.append("    normal: {");
        sb.append("        barBorderColor: 'rgba(0,0,0,0)',");
        sb.append("                color: 'rgba(0,0,0,0)'");
        sb.append("    },");
        sb.append("    emphasis: {");
        sb.append("        barBorderColor: 'rgba(0,0,0,0)',");
        sb.append("                color: 'rgba(0,0,0,0)'");
        sb.append("    }");
        sb.append("},");
        sb.append("    data:[0, 1200, 300, 200, 200, 300],");
        sb.append("    backAss:[0, 1200, 300, 200, 200, 300]");
        sb.append("},");
        sb.append("{");
        sb.append("    name: '\u751f\u6d3b\u8d39',");
        sb.append("            type: 'bar',");
        sb.append("        stack: '\u603b\u91cf',");
        sb.append("        label: {");
        sb.append("    normal: {");
        sb.append("        show: true,");
        sb.append("                position: 'inside'");
        sb.append("    }");
        sb.append("},");
        sb.append("    orgData:[{value:2900}, {value:-1700}, {value:-900}, {value:-100}, {value:700}, {value:-600}],");
        sb.append("    data:[{value:2900}, {value:1700}, {value:900}, {value:100}, {value:700}, {value:600}],");
        sb.append("    backData:[{value:2900}, {value:1700}, {value:900}, {value:100}, {value:700}, {value:600}]");
        sb.append("}");
        sb.append("]}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        Set keySet;
        JSONObject hyperLinkObj;
        JSONObject backColorObj;
        int i;
        path = path.replace(".html", ".plugin");
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String pColor = optionObject.getString("pColor");
        String nColor = optionObject.getString("nColor");
        String fColor = optionObject.getString("fColor");
        String eColor = optionObject.getString("eColor");
        int startNum = 0;
        if (optionObject.containsKey((Object)"startNum")) {
            startNum = optionObject.getIntValue("startNum");
        }
        boolean isLastTrue = false;
        if (optionObject.containsKey((Object)"isLastTrue")) {
            isLastTrue = optionObject.getBoolean("isLastTrue");
        }
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i2 = 0; i2 < categoryStrs.length; ++i2) {
            if (categoryList.contains(categoryStrs[i2])) continue;
            categoryList.add(categoryStrs[i2]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i3 = 0; i3 < categoryDatas.length; ++i3) {
            categoryDatas[i3] = (String)categoryList.get(i3);
        }
        JSONArray categoryArray = new JSONArray();
        for (int i4 = 0; i4 < categoryDatas.length; ++i4) {
            categoryArray.add((Object)categoryDatas[i4]);
        }
        JSONArray xAxisArray = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject = xAxisArray.getJSONObject(0);
        xAxisObject.put("data", (Object)categoryArray);
        String[] valueDatas = valueData.split(",");
        float[] orgDatas = new float[valueDatas.length];
        String dataArr = "var dataArr = [";
        for (int i5 = 0; i5 < valueDatas.length; ++i5) {
            dataArr = i5 != valueDatas.length - 1 ? dataArr + "'" + valueDatas[i5] + "'," : dataArr + "'" + valueDatas[i5] + "']";
            String data = valueDatas[i5];
            if (data.contains("(")) {
                data = data.substring(1, data.length() - 1);
                data = data.substring(0, data.length());
                data = "-" + data;
            }
            orgDatas[i5] = Float.parseFloat(data);
        }
        String[] ass1 = new String[valueDatas.length];
        String[] dis1 = new String[valueDatas.length];
        String[] ass2 = new String[valueDatas.length];
        String[] dis2 = new String[valueDatas.length];
        JSONArray datasArray = new JSONArray();
        for (i = 0; i < orgDatas.length; ++i) {
            float lastEnd;
            JSONObject object = new JSONObject();
            float data = orgDatas[i];
            float start = startNum;
            float end = (float)startNum + data;
            if (i == 0) {
                object.put("start", (Object)Float.valueOf(start));
                object.put("end", (Object)Float.valueOf(end));
                datasArray.add((Object)object);
                continue;
            }
            JSONObject lastObj = datasArray.getJSONObject(i - 1);
            start = lastEnd = lastObj.getFloatValue("end");
            end = start + data;
            object.put("start", (Object)Float.valueOf(start));
            object.put("end", (Object)Float.valueOf(end));
            datasArray.add((Object)object);
        }
        for (i = 0; i < datasArray.size(); ++i) {
            JSONObject dataObj = datasArray.getJSONObject(i);
            float start = dataObj.getFloatValue("start");
            float end = dataObj.getFloatValue("end");
            if (start == 0.0f) {
                if (end > 0.0f) {
                    ass1[i] = "-";
                    dis1[i] = end == 0.0f ? "-" : String.valueOf(end);
                    ass2[i] = "-";
                    dis2[i] = "-";
                    continue;
                }
                ass1[i] = "-";
                dis1[i] = "-";
                ass2[i] = "-";
                if (end == 0.0f) {
                    dis2[i] = "-";
                    continue;
                }
                dis2[i] = String.valueOf(end);
                continue;
            }
            if (start > 0.0f) {
                if (end > 0.0f) {
                    if (end > start) {
                        ass1[i] = String.valueOf(start);
                        dis1[i] = String.valueOf(end - start);
                        ass2[i] = "-";
                        dis2[i] = "-";
                        continue;
                    }
                    ass1[i] = String.valueOf(end);
                    dis1[i] = start - end == 0.0f ? "-" : String.valueOf(start - end);
                    ass2[i] = "-";
                    dis2[i] = "-";
                    continue;
                }
                ass1[i] = "-";
                dis1[i] = String.valueOf(start);
                ass2[i] = "-";
                if (end == 0.0f) {
                    dis2[i] = "-";
                    continue;
                }
                dis2[i] = String.valueOf(end);
                continue;
            }
            if (end < 0.0f) {
                if (end > start) {
                    ass2[i] = String.valueOf(end);
                    dis2[i] = String.valueOf(start - end);
                    ass1[i] = "-";
                    dis1[i] = "-";
                    continue;
                }
                ass2[i] = String.valueOf(start);
                dis2[i] = end - start == 0.0f ? "-" : String.valueOf(end - start);
                ass1[i] = "-";
                dis1[i] = "-";
                continue;
            }
            ass1[i] = "-";
            dis1[i] = end == 0.0f ? "-" : String.valueOf(end);
            ass2[i] = "-";
            dis2[i] = String.valueOf(start);
        }
        if (isLastTrue) {
            float lastData = orgDatas[orgDatas.length - 1];
            if (lastData > 0.0f) {
                ass1[orgDatas.length - 1] = "-";
                dis1[orgDatas.length - 1] = String.valueOf(lastData);
                ass2[orgDatas.length - 1] = "-";
                dis2[orgDatas.length - 1] = "-";
            } else if (lastData < 0.0f) {
                ass1[orgDatas.length - 1] = "-";
                dis1[orgDatas.length - 1] = "-";
                ass2[orgDatas.length - 1] = "-";
                dis2[orgDatas.length - 1] = String.valueOf(lastData);
            } else {
                ass1[orgDatas.length - 1] = "-";
                dis1[orgDatas.length - 1] = "-";
                ass2[orgDatas.length - 1] = "-";
                dis2[orgDatas.length - 1] = String.valueOf(lastData);
            }
        }
        JSONArray seriesArray = new JSONArray();
        JSONObject assObject1 = new JSONObject();
        assObject1.put("type", (Object)"bar");
        assObject1.put("name", (Object)"");
        assObject1.put("stack", (Object)"\u603b\u91cf");
        JSONObject itemStyle1 = new JSONObject();
        JSONObject normal1 = new JSONObject();
        normal1.put("barBorderColor", (Object)"rgba(0,0,0,0)");
        normal1.put("color", (Object)"rgba(0,0,0,0)");
        itemStyle1.put("normal", (Object)normal1);
        JSONObject emphasis1 = new JSONObject();
        emphasis1.put("barBorderColor", (Object)"rgba(0,0,0,0)");
        emphasis1.put("color", (Object)"rgba(0,0,0,0)");
        itemStyle1.put("emphasis", (Object)emphasis1);
        assObject1.put("itemStyle", (Object)itemStyle1);
        assObject1.put("data", (Object)ass1);
        seriesArray.add((Object)assObject1);
        JSONObject disObject1 = new JSONObject();
        disObject1.put("type", (Object)"bar");
        disObject1.put("name", (Object)"");
        disObject1.put("stack", (Object)"\u603b\u91cf");
        JSONObject label2 = new JSONObject();
        JSONObject normal2 = new JSONObject();
        normal2.put("show", (Object)false);
        normal2.put("position", (Object)"inside");
        label2.put("normal", (Object)normal2);
        disObject1.put("label", (Object)label2);
        JSONArray seriesDataArray = new JSONArray();
        for (int j = 0; j < orgDatas.length; ++j) {
            JSONObject itemStyle;
            JSONObject dObj = new JSONObject();
            float tData = orgDatas[j];
            dObj.put("value", (Object)dis1[j]);
            if (fColor != null && j == 0) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)fColor);
                dObj.put("itemStyle", (Object)itemStyle);
                seriesDataArray.add((Object)dObj);
                continue;
            }
            if (eColor != null && j == orgDatas.length - 1) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)eColor);
                dObj.put("itemStyle", (Object)itemStyle);
                seriesDataArray.add((Object)dObj);
                continue;
            }
            if (tData >= 0.0f) {
                if (pColor != null) {
                    itemStyle = new JSONObject();
                    itemStyle.put("color", (Object)pColor);
                    dObj.put("itemStyle", (Object)itemStyle);
                }
            } else if (nColor != null) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)nColor);
                dObj.put("itemStyle", (Object)itemStyle);
            }
            seriesDataArray.add((Object)dObj);
        }
        disObject1.put("data", (Object)seriesDataArray);
        seriesArray.add((Object)disObject1);
        JSONObject assObject2 = new JSONObject();
        assObject2.put("type", (Object)"bar");
        assObject2.put("name", (Object)"");
        assObject2.put("stack", (Object)"\u603b\u91cf");
        JSONObject itemStyle3 = new JSONObject();
        JSONObject normal3 = new JSONObject();
        normal3.put("barBorderColor", (Object)"rgba(0,0,0,0)");
        normal3.put("color", (Object)"rgba(0,0,0,0)");
        itemStyle3.put("normal", (Object)normal3);
        JSONObject emphasis3 = new JSONObject();
        emphasis3.put("barBorderColor", (Object)"rgba(0,0,0,0)");
        emphasis3.put("color", (Object)"rgba(0,0,0,0)");
        itemStyle3.put("emphasis", (Object)emphasis3);
        assObject2.put("itemStyle", (Object)itemStyle3);
        assObject2.put("data", (Object)ass2);
        seriesArray.add((Object)assObject2);
        JSONObject disObject2 = new JSONObject();
        disObject2.put("type", (Object)"bar");
        disObject2.put("name", (Object)"");
        disObject2.put("stack", (Object)"\u603b\u91cf");
        JSONObject label4 = new JSONObject();
        JSONObject normal4 = new JSONObject();
        normal4.put("show", (Object)false);
        normal4.put("position", (Object)"inside");
        label4.put("normal", (Object)normal4);
        disObject2.put("label", (Object)label4);
        JSONArray seriesDataArray1 = new JSONArray();
        for (int j = 0; j < orgDatas.length; ++j) {
            JSONObject itemStyle;
            JSONObject dObj = new JSONObject();
            float tData = orgDatas[j];
            dObj.put("value", (Object)dis2[j]);
            if (fColor != null && j == 0) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)fColor);
                dObj.put("itemStyle", (Object)itemStyle);
                seriesDataArray1.add((Object)dObj);
                continue;
            }
            if (eColor != null && j == orgDatas.length - 1) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)eColor);
                dObj.put("itemStyle", (Object)itemStyle);
                seriesDataArray1.add((Object)dObj);
                continue;
            }
            if (tData >= 0.0f) {
                if (pColor != null) {
                    itemStyle = new JSONObject();
                    itemStyle.put("color", (Object)pColor);
                    dObj.put("itemStyle", (Object)itemStyle);
                }
            } else if (nColor != null) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)nColor);
                dObj.put("itemStyle", (Object)itemStyle);
            }
            seriesDataArray1.add((Object)dObj);
        }
        disObject2.put("data", (Object)seriesDataArray1);
        seriesArray.add((Object)disObject2);
        optionObject.put("series", (Object)seriesArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        JSONArray cssArray = new JSONArray();
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsArray.add((Object)(jsResourcePath + "/echarts-5.4.2.min.js"));
        jsBuffer.append(jsArray.toString());
        cssBuffer.append(cssArray.toString());
        long time = System.currentTimeMillis();
        domBuffer.append("<div id='main_" + time + "' style='width:100%;height:100%;'></div>");
        scriptBuffer.append("var myChart_" + time + " = echarts.init(document.getElementById('main_" + time + "'));");
        scriptBuffer.append("var option_" + time + " = ");
        scriptBuffer.append(optionObject.toString());
        scriptBuffer.append(";");
        scriptBuffer.append("myChart_" + time + ".setOption(option_" + time + ");");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        String repaintRegions = reportInfoObj.getString("repaintRegions");
        JSONObject repaintRegionsObj = JSONObject.parseObject((String)repaintRegions);
        if (hyperLinkArray != null && repaintRegionsObj != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);");
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i6 = 0; i6 < kAv.length; ++i6) {
                String echartParam;
                String paramStr = kAv[i6];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1');");
            scriptBuffer.append("});");
        } else if (repaintRegionsObj != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i7 = 0; i7 < kAv.length; ++i7) {
                String echartParam;
                String paramStr = kAv[i7];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        } else if (hyperLinkArray != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ");});");
        }
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        int i;
        String resultStr = null;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String pColor = optionObject.getString("pColor");
        String nColor = optionObject.getString("nColor");
        String fColor = optionObject.getString("fColor");
        String eColor = optionObject.getString("eColor");
        int startNum = 0;
        if (optionObject.containsKey((Object)"startNum")) {
            startNum = optionObject.getIntValue("startNum");
        }
        boolean isLastTrue = false;
        if (optionObject.containsKey((Object)"isLastTrue")) {
            isLastTrue = optionObject.getBoolean("isLastTrue");
        }
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i2 = 0; i2 < categoryStrs.length; ++i2) {
            if (categoryList.contains(categoryStrs[i2])) continue;
            categoryList.add(categoryStrs[i2]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i3 = 0; i3 < categoryDatas.length; ++i3) {
            categoryDatas[i3] = (String)categoryList.get(i3);
        }
        JSONArray categoryArray = new JSONArray();
        for (int i4 = 0; i4 < categoryDatas.length; ++i4) {
            categoryArray.add((Object)categoryDatas[i4]);
        }
        JSONArray xAxisArray = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject = xAxisArray.getJSONObject(0);
        xAxisObject.put("data", (Object)categoryArray);
        String[] valueDatas = valueData.split(",");
        float[] orgDatas = new float[valueDatas.length];
        String dataArr = "var dataArr = [";
        for (int i5 = 0; i5 < valueDatas.length; ++i5) {
            dataArr = i5 != valueDatas.length - 1 ? dataArr + "'" + valueDatas[i5] + "'," : dataArr + "'" + valueDatas[i5] + "']";
            String data = valueDatas[i5];
            if (data.contains("(")) {
                data = data.substring(1, data.length() - 1);
                data = data.substring(0, data.length());
                data = "-" + data;
            }
            orgDatas[i5] = Float.parseFloat(data);
        }
        String[] ass1 = new String[valueDatas.length];
        String[] dis1 = new String[valueDatas.length];
        String[] ass2 = new String[valueDatas.length];
        String[] dis2 = new String[valueDatas.length];
        JSONArray datasArray = new JSONArray();
        for (i = 0; i < orgDatas.length; ++i) {
            float lastEnd;
            JSONObject object = new JSONObject();
            float data = orgDatas[i];
            float start = startNum;
            float end = (float)startNum + data;
            if (i == 0) {
                object.put("start", (Object)Float.valueOf(start));
                object.put("end", (Object)Float.valueOf(end));
                datasArray.add((Object)object);
                continue;
            }
            JSONObject lastObj = datasArray.getJSONObject(i - 1);
            start = lastEnd = lastObj.getFloatValue("end");
            end = start + data;
            object.put("start", (Object)Float.valueOf(start));
            object.put("end", (Object)Float.valueOf(end));
            datasArray.add((Object)object);
        }
        for (i = 0; i < datasArray.size(); ++i) {
            JSONObject dataObj = datasArray.getJSONObject(i);
            float start = dataObj.getFloatValue("start");
            float end = dataObj.getFloatValue("end");
            if (start == 0.0f) {
                if (end > 0.0f) {
                    ass1[i] = "-";
                    dis1[i] = end == 0.0f ? "-" : String.valueOf(end);
                    ass2[i] = "-";
                    dis2[i] = "-";
                    continue;
                }
                ass1[i] = "-";
                dis1[i] = "-";
                ass2[i] = "-";
                if (end == 0.0f) {
                    dis2[i] = "-";
                    continue;
                }
                dis2[i] = String.valueOf(end);
                continue;
            }
            if (start > 0.0f) {
                if (end > 0.0f) {
                    if (end > start) {
                        ass1[i] = String.valueOf(start);
                        dis1[i] = String.valueOf(end - start);
                        ass2[i] = "-";
                        dis2[i] = "-";
                        continue;
                    }
                    ass1[i] = String.valueOf(end);
                    dis1[i] = start - end == 0.0f ? "-" : String.valueOf(start - end);
                    ass2[i] = "-";
                    dis2[i] = "-";
                    continue;
                }
                ass1[i] = "-";
                dis1[i] = String.valueOf(start);
                ass2[i] = "-";
                if (end == 0.0f) {
                    dis2[i] = "-";
                    continue;
                }
                dis2[i] = String.valueOf(end);
                continue;
            }
            if (end < 0.0f) {
                if (end > start) {
                    ass2[i] = String.valueOf(end);
                    dis2[i] = String.valueOf(start - end);
                    ass1[i] = "-";
                    dis1[i] = "-";
                    continue;
                }
                ass2[i] = String.valueOf(start);
                dis2[i] = end - start == 0.0f ? "-" : String.valueOf(end - start);
                ass1[i] = "-";
                dis1[i] = "-";
                continue;
            }
            ass1[i] = "-";
            dis1[i] = end == 0.0f ? "-" : String.valueOf(end);
            ass2[i] = "-";
            dis2[i] = String.valueOf(start);
        }
        if (isLastTrue) {
            float lastData = orgDatas[orgDatas.length - 1];
            if (lastData > 0.0f) {
                ass1[orgDatas.length - 1] = "-";
                dis1[orgDatas.length - 1] = String.valueOf(lastData);
                ass2[orgDatas.length - 1] = "-";
                dis2[orgDatas.length - 1] = "-";
            } else if (lastData < 0.0f) {
                ass1[orgDatas.length - 1] = "-";
                dis1[orgDatas.length - 1] = "-";
                ass2[orgDatas.length - 1] = "-";
                dis2[orgDatas.length - 1] = String.valueOf(lastData);
            } else {
                ass1[orgDatas.length - 1] = "-";
                dis1[orgDatas.length - 1] = "-";
                ass2[orgDatas.length - 1] = "-";
                dis2[orgDatas.length - 1] = String.valueOf(lastData);
            }
        }
        JSONArray seriesArray = new JSONArray();
        JSONObject assObject1 = new JSONObject();
        assObject1.put("type", (Object)"bar");
        assObject1.put("name", (Object)"");
        assObject1.put("stack", (Object)"\u603b\u91cf");
        JSONObject itemStyle1 = new JSONObject();
        JSONObject normal1 = new JSONObject();
        normal1.put("barBorderColor", (Object)"rgba(0,0,0,0)");
        normal1.put("color", (Object)"rgba(0,0,0,0)");
        itemStyle1.put("normal", (Object)normal1);
        JSONObject emphasis1 = new JSONObject();
        emphasis1.put("barBorderColor", (Object)"rgba(0,0,0,0)");
        emphasis1.put("color", (Object)"rgba(0,0,0,0)");
        itemStyle1.put("emphasis", (Object)emphasis1);
        assObject1.put("itemStyle", (Object)itemStyle1);
        assObject1.put("data", (Object)ass1);
        seriesArray.add((Object)assObject1);
        JSONObject disObject1 = new JSONObject();
        disObject1.put("type", (Object)"bar");
        disObject1.put("name", (Object)"");
        disObject1.put("stack", (Object)"\u603b\u91cf");
        JSONObject label2 = new JSONObject();
        JSONObject normal2 = new JSONObject();
        normal2.put("show", (Object)false);
        normal2.put("position", (Object)"inside");
        label2.put("normal", (Object)normal2);
        disObject1.put("label", (Object)label2);
        JSONArray seriesDataArray = new JSONArray();
        for (int j = 0; j < orgDatas.length; ++j) {
            JSONObject itemStyle;
            JSONObject dObj = new JSONObject();
            float tData = orgDatas[j];
            dObj.put("value", (Object)dis1[j]);
            if (fColor != null && j == 0) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)fColor);
                dObj.put("itemStyle", (Object)itemStyle);
                seriesDataArray.add((Object)dObj);
                continue;
            }
            if (eColor != null && j == orgDatas.length - 1) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)eColor);
                dObj.put("itemStyle", (Object)itemStyle);
                seriesDataArray.add((Object)dObj);
                continue;
            }
            if (tData >= 0.0f) {
                if (pColor != null) {
                    itemStyle = new JSONObject();
                    itemStyle.put("color", (Object)pColor);
                    dObj.put("itemStyle", (Object)itemStyle);
                }
            } else if (nColor != null) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)nColor);
                dObj.put("itemStyle", (Object)itemStyle);
            }
            seriesDataArray.add((Object)dObj);
        }
        disObject1.put("data", (Object)seriesDataArray);
        seriesArray.add((Object)disObject1);
        JSONObject assObject2 = new JSONObject();
        assObject2.put("type", (Object)"bar");
        assObject2.put("name", (Object)"");
        assObject2.put("stack", (Object)"\u603b\u91cf");
        JSONObject itemStyle3 = new JSONObject();
        JSONObject normal3 = new JSONObject();
        normal3.put("barBorderColor", (Object)"rgba(0,0,0,0)");
        normal3.put("color", (Object)"rgba(0,0,0,0)");
        itemStyle3.put("normal", (Object)normal3);
        JSONObject emphasis3 = new JSONObject();
        emphasis3.put("barBorderColor", (Object)"rgba(0,0,0,0)");
        emphasis3.put("color", (Object)"rgba(0,0,0,0)");
        itemStyle3.put("emphasis", (Object)emphasis3);
        assObject2.put("itemStyle", (Object)itemStyle3);
        assObject2.put("data", (Object)ass2);
        seriesArray.add((Object)assObject2);
        JSONObject disObject2 = new JSONObject();
        disObject2.put("type", (Object)"bar");
        disObject2.put("name", (Object)"");
        disObject2.put("stack", (Object)"\u603b\u91cf");
        JSONObject label4 = new JSONObject();
        JSONObject normal4 = new JSONObject();
        normal4.put("show", (Object)false);
        normal4.put("position", (Object)"inside");
        label4.put("normal", (Object)normal4);
        disObject2.put("label", (Object)label4);
        JSONArray seriesDataArray1 = new JSONArray();
        for (int j = 0; j < orgDatas.length; ++j) {
            JSONObject itemStyle;
            JSONObject dObj = new JSONObject();
            float tData = orgDatas[j];
            dObj.put("value", (Object)dis2[j]);
            if (fColor != null && j == 0) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)fColor);
                dObj.put("itemStyle", (Object)itemStyle);
                seriesDataArray1.add((Object)dObj);
                continue;
            }
            if (eColor != null && j == orgDatas.length - 1) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)eColor);
                dObj.put("itemStyle", (Object)itemStyle);
                seriesDataArray1.add((Object)dObj);
                continue;
            }
            if (tData >= 0.0f) {
                if (pColor != null) {
                    itemStyle = new JSONObject();
                    itemStyle.put("color", (Object)pColor);
                    dObj.put("itemStyle", (Object)itemStyle);
                }
            } else if (nColor != null) {
                itemStyle = new JSONObject();
                itemStyle.put("color", (Object)nColor);
                dObj.put("itemStyle", (Object)itemStyle);
            }
            seriesDataArray1.add((Object)dObj);
        }
        disObject2.put("data", (Object)seriesDataArray1);
        seriesArray.add((Object)disObject2);
        optionObject.put("series", (Object)seriesArray);
        optionObject.put("animation", (Object)false);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(optionObject.toString());
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u7011\u5e03\u56fe";
    }

    public static String getClassName() {
        return "Fall";
    }

    public static void main(String[] args) {
        String data = "(300)";
        if (data.contains("(")) {
            data = data.substring(1, data.length() - 1);
            data = data.substring(0, data.length());
            data = "-" + data;
        }
        System.out.println(Float.parseFloat(data));
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        JSONObject defaultJson = JSONObject.parseObject((String)Fall.generateDefaultOption());
        JSONArray xAxisArray = optionJson.getJSONArray("xAxis");
        JSONObject xAxisObj = xAxisArray.getJSONObject(0);
        JSONObject xAxisDefaultObj = (JSONObject)defaultJson.get((Object)"xAxis");
        xAxisObj.put("data", xAxisDefaultObj.get((Object)"data"));
        JSONArray seriesDefaultObj = (JSONArray)defaultJson.get((Object)"series");
        if (optionJson.containsKey((Object)"labelShow")) {
            boolean flag = optionJson.getBoolean("labelShow");
            for (int i = 0; i < seriesDefaultObj.size(); ++i) {
                JSONObject seriesObject = seriesDefaultObj.getJSONObject(i);
                JSONObject labelObject = new JSONObject();
                labelObject.put("show", (Object)flag);
                seriesObject.put("label", (Object)labelObject);
            }
        }
        optionJson.put("series", (Object)seriesDefaultObj);
        return optionJson.toString();
    }
}

