/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CustomPlugin_Echarts {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption, String echartsOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option;
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String clazzName = CustomPlugin_Echarts.getClassName();
            if (echartsOption == null) {
                option = CustomPlugin_Echarts.generateDefaultOption();
                clazzName = CustomPlugin_Echarts.getClassName();
            } else {
                option = echartsOption;
                clazzName = json.getString("pluginName");
            }
            String pngPath1 = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath1);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath1);
                JSONObject pluginOption = new JSONObject();
                if (echartsOption != null) {
                    pluginOption.put("PluginOption", (Object)option);
                    pluginOption.put("PluginDefaultOption", (Object)option);
                } else {
                    pluginOption.put("PluginOption", (Object)("option=" + option + ";"));
                    pluginOption.put("PluginDefaultOption", (Object)("option=" + option + ";"));
                }
                pluginOption.put("PluginData", (Object)new JSONObject());
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", pluginOption.toString());
            } else {
                String defaultOption;
                if (echartsOption != null) {
                    defaultOption = "var " + echartsOption;
                } else {
                    JSONObject charts = JSONObject.parseObject((String)option);
                    defaultOption = charts.toJSONString();
                    defaultOption = "var option = " + defaultOption;
                }
                String jsResourceHttp = websiteName + jsResourcePath;
                String uuid = UUID.randomUUID().toString();
                String fileName = uuid + ".html";
                String htmlPath = path + File.separator + fileName;
                String pngPath = path + File.separator + clazzName + ".png";
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-5.4.2.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-gl.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-liquidfill.min.ex.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-wordCloud-5.min.js'></script>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("var myChart = echarts.init(document.getElementById('main'));");
                sb.append(defaultOption + ";");
                sb.append("myChart.setOption(option);");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                if (htmlPath.contains(":") && htmlPath.startsWith("/")) {
                    htmlPath = htmlPath.substring(1, htmlPath.length());
                    pngPath = pngPath.substring(1, pngPath.length());
                }
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, URLEncoder.encode(pngPath, "UTF-8"));
                JSONObject pluginOption = new JSONObject();
                if (echartsOption != null) {
                    pluginOption.put("PluginOption", (Object)option);
                    pluginOption.put("PluginDefaultOption", (Object)option);
                } else {
                    pluginOption.put("PluginOption", (Object)("option=" + option + ";"));
                    pluginOption.put("PluginDefaultOption", (Object)("option=" + option + ";"));
                }
                pluginOption.put("PluginData", (Object)new JSONObject());
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", pluginOption.toString());
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + CustomPlugin_Echarts.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{\n");
        sb.append("        xAxis: {\n");
        sb.append("    type: 'category',\n");
        sb.append("            data: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']\n");
        sb.append(" },\n");
        sb.append("yAxis: {\n");
        sb.append("    type: 'value'\n");
        sb.append("},\n");
        sb.append("series: [\n");
        sb.append("{\n");
        sb.append("    data: [150, 230, 224, 218, 135, 147, 260],\n");
        sb.append("    type: 'line'\n");
        sb.append("\n}");
        sb.append("\n]");
        sb.append("\n}");
        return sb.toString();
    }

    public static int generatePluginHtml(String resource, String option, int width, int height, String path, String reportInfo) {
        String repaintRegions;
        JSONObject repaintRegionsObj;
        int i;
        JSONObject resourceObj = JSONObject.parseObject((String)resource);
        String jsResourcePath = resourceObj.getString("path");
        option = option.replaceAll("@base", jsResourcePath);
        JSONObject charts = JSONObject.parseObject((String)option);
        String options = charts.getString("PluginOption");
        String pluginData = charts.getString("PluginData");
        JSONArray jsArray = resourceObj.getJSONArray("js");
        JSONArray cssArray = resourceObj.getJSONArray("css");
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        for (i = 0; i < jsArray.size(); ++i) {
            sb.append("<script type='text/javascript' src='" + jsResourcePath + "/Custom_Echarts/js/" + jsArray.getString(i) + "'></script>");
        }
        for (i = 0; i < cssArray.size(); ++i) {
            sb.append("<link rel='stylesheet' href='" + jsResourcePath + "/Custom_Echarts/css/" + cssArray.getString(i) + "' type='text/css'>");
        }
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var pluginData;");
        sb.append("function refresh(option){");
        sb.append("  pluginData = JSON.parse(option.data);");
        sb.append("  var myChart = echarts.init(document.getElementById('main'));");
        sb.append("   myChart.resize();");
        sb.append("}\n");
        sb.append("$(document).ready(function(){");
        sb.append("$('#main').css('width',$(window.frameElement).attr('ow')==undefined?$(window.frameElement).width():$(window.frameElement).attr('ow'));");
        sb.append("$('#main').css('height',$(window.frameElement).attr('oh')==undefined?$(window.frameElement).height():$(window.frameElement).attr('oh'));");
        sb.append("pluginData = " + pluginData + ";");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append(options);
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("window.addEventListener('resize',function(){");
        sb.append("    myChart.resize();");
        sb.append("});");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        if (hyperLinkArray != null) {
            sb.append("var hyperLinkArray = [];");
            sb.append("var obj = {};");
            sb.append("var paramExpression ;");
            JSONObject hyperLinkObj = hyperLinkArray.getJSONObject(0);
            Set keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    sb.append("obj." + key + "=" + value + ";");
                    continue;
                }
                sb.append("obj." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                sb.append("paramExpression = '" + value + "';");
            }
            sb.append("hyperLinkArray.push(obj);");
            sb.append("myChart.on('click', function (params) {var changeParam='';var hyperParam = paramExpression;var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray[0].Params = changeParam;parent.Link.Fn.hyperlink(hyperLinkArray)});");
        }
        if ((repaintRegionsObj = JSONObject.parseObject((String)(repaintRegions = reportInfoObj.getString("repaintRegions")))) != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i2 = 0; i2 < kAv.length; ++i2) {
                String echartParam;
                String paramStr = kAv[i2];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("CONTROLVALUE".equals(key) || "X-AXIS".equals(key) || "Y-AXIS".equals(key)) continue;
                String val = paramStrs[1].replaceAll("'", "");
                String echartParam2 = paramStrs[0] + "=" + val + ";";
                echartSb.append(echartParam2);
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            sb.append("myChart.on('click', function (params) {parent.Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        }
        sb.append("$('#main').on('dblclick' , function(params){var pWidth = $(window.parent.document).find('.x-data-bg_block').width();var pHeight = $(window.parent.document).find('.x-data-bg_block').height();var url = $(window.frameElement).attr('src');parent.Link.Fn.layerOpen(pWidth , pHeight , url);});");
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(sb.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr;
        JSONObject charts = JSONObject.parseObject((String)option);
        String options = charts.getString("PluginOption");
        String pluginData = charts.getString("PluginData");
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-gl.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-liquidfill.min.ex.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var pluginData;");
        sb.append("function refresh(option){");
        sb.append("  pluginData = JSON.parse(option.data);");
        sb.append("  var myChart = echarts.init(document.getElementById('main'));");
        sb.append("   myChart.resize();");
        sb.append("}\n");
        sb.append("$(document).ready(function(){");
        sb.append("$('#main').css('width',$(window.frameElement).attr('ow')==undefined?$(window.frameElement).width():$(window.frameElement).attr('ow'));");
        sb.append("$('#main').css('height',$(window.frameElement).attr('oh')==undefined?$(window.frameElement).height():$(window.frameElement).attr('oh'));");
        sb.append("pluginData = " + pluginData + ";");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append(options);
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("window.addEventListener('resize',function(){");
        sb.append("    myChart.resize();");
        sb.append("});");
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write("");
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String getPluginName() {
        return "\u81ea\u5b9a\u4e49Echarts\u63d2\u4ef6";
    }

    public static String getClassName() {
        return "CustomPlugin_Echarts";
    }

    public static void main(String[] args) {
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        return optionJson.toString();
    }
}

