/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import javax.imageio.stream.FileImageInputStream;

public class BarPlugin {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public String getPluginDefaultImage(int width, int height, String html) {
        return null;
    }

    public static String getParamDialog() {
        JSONObject object = new JSONObject();
        String option = BarPlugin.generateDefaultOption();
        object.put("option", JSONObject.parse((String)option));
        String config = BarPlugin.generateConfig();
        object.put("config", (Object)config);
        return object.toString();
    }

    public void setParamList(String paramList) {
    }

    public static String generateHtml(int width, int height, String option) {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='../../../lib/echarts/echarts-4.1.0.min.js'></script>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = {");
        sb.append(option);
        sb.append("}");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        return sb.toString();
    }

    public static int generatePluginHtml(String option, int width, int height, String path) {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='http://localhost:8080/js/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='http://localhost:8080/lib/echarts/echarts-4.1.0.min.js'></script>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(option);
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(sb.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{title:{text:'\u9500\u91cf\u56fe'},");
        sb.append("animation:false,");
        sb.append("legend:{data:['\u82f9\u679c', '\u9999\u8549']},");
        sb.append("xAxis: {type: 'category', data: ['2011', '2012', '2013', '2014', '2015', '2016', '2017']},");
        sb.append("yAxis: {type: 'value'},");
        sb.append("series: [");
        sb.append("{name:'\u82f9\u679c', data: [120, 200, 150, 80, 70, 110, 130],type: 'bar'},");
        sb.append("{name:'\u9999\u8549', data:[130,210,160,90,80,120,140],type:'bar'}");
        sb.append("]}");
        return sb.toString();
    }

    public static String generateConfig() {
        StringBuffer sb = new StringBuffer();
        sb.append("<div class='layui-tab'>            <ul class='layui-tab-title' id='lay_expend'>                <li class='layui-this'>\u6807<br>\u9898</li>                <li>\u56fe<br>\u4f8b</li>                <li>\u7f51<br>\u683c</li>            </ul>            <div class='layui-tab-content' style='width: 100%;height:100%;padding:5px'>                <div class='layui-tab-item layui-show' id='title'                     style='overflow: auto;white-space: normal;height:100%'>                    <div id='chart' style='' class='chart'>                        <!--<label>\u663e\u793a\u56fe\u4f8b</label><input type='checkbox' id='ct_exp'><br/>-->                        <div style='width: 100%;text-align: center;margin-bottom:5px;font-size:20px'>                            <a style='display: inline-grid;'>\u6807 \u9898</a>                        </div>                        <table style='width: 100%; display: table;'>                            <tbody>                            <tr>                                <td style='width:100px;'>\u663e\u793a\u6807\u9898</td>                                <td style='width:130px;'><select id='titleShow'>                                    <option value='1' selected>\u663e\u793a</option>                                    <option value='0'>\u4e0d\u663e\u793a</option>                                </select></td>                            </tr>                            <tr>                                <td>\u6807\u9898\u6587\u672c</td>                                <td><input type='text' id='titleText' autocomplete='off'></td>                            </tr>                            <tr>                                <td>\u80cc\u666f\u989c\u8272</td>                                <td>                                    <div style='width: 100px;margin-right:5px;display:table-cell'><input type='text'                                                                                                         id='titleBgInput'                                                                                                         style='margin-right:5px;' value='#000000'>                                    </div>                                    <div id='titleBg'                                         style='width: 80px; display: table-cell; height: 29px; border: 1px solid rgb(213, 213, 213); background-color: rgb(255, 255, 255);'></div>                                </td>                            </tr>                            <tr>                                <td>\u4e0a\u8fb9\u8ddd</td>                                <td><input type='text' id='title-top' autocomplete='off' class='position'                                           placeholder='' value='0'></td>                            </tr>                            <tr>                                <td>\u4e0b\u8fb9\u8ddd</td>                                <td><input type='text' id='title-bottom' autocomplete='off' class='position'                                           placeholder='' value='0'></td>                            </tr>                            <tr>                                <td>\u5de6\u8fb9\u8ddd</td>                                <td><input type='text' id='title-left' autocomplete='off' class='position'                                           placeholder='' value='0'></td>                            </tr>                            <tr>                                <td>\u53f3\u8fb9\u8ddd</td>                                <td><input type='text' id='title-right' autocomplete='off' class='position'                                           placeholder='' value='0'></td>                            </tr>                            <tr>                                <td>\u6587\u672c\u6837\u5f0f</td>                                <td></td>                            </tr>                            <tr>                                <td>\u989c\u8272</td>                                <td>                                    <div style='width: 100px;margin-right:5px;display:table-cell'><input type='text'                                                                                                         id='titleColorInput'                                                                                                         style='margin-right:5px;'                                                                                                         value='#ffffff'>                                    </div>                                    <div id='titleColor'                                         style='width: 80px; display: table-cell; height: 29px; border: 1px solid rgb(213, 213, 213); background-color: black;'></div>                                </td>                            </tr>                            <tr>                                <td>\u5b57\u4f53\u98ce\u683c</td>                                <td><select id='titleStyle'>                                    <option value='normal'>\u6b63\u5e38</option>                                    <option value='italic'>\u659c\u4f53</option>                                    <option value='oblique'>\u503e\u659c</option>                                </select></td>                            </tr>                            <tr>                                <td>\u5b57\u4f53\u7c97\u7ec6</td>                                <td><select id='titleWeight'>                                    <option value='normal'>\u6b63\u5e38</option>                                    <option value='bold' selected>\u52a0\u7c97</option>                                </select></td>                            </tr>                            <tr>                                <td>\u5b57\u4f53\u540d\u79f0</td>                                <td><select id='titleFont'>                                    <option value='Bitstream Vera Sans'>Bitstream Vera Sans</option>                                    <option value='DejaVu Sans'>DejaVu Sans</option>                                    <option value='DejaVu Sans Mono'>DejaVu Sans Mono</option>                                    <option value='\u5b8b\u4f53'>\u5b8b\u4f53</option>                                </select></td>                            </tr>                            <tr>                                <td>\u5b57\u4f53\u5927\u5c0f</td>                                <td><input type='text' autocomplete='off' id='titleSize'></td>                            </tr>                            </tbody>                        </table>                        <div class='link-top' style='margin: 10px 0'></div>                    </div>                </div>                <div class='layui-tab-item' id='legend' style='overflow: auto;white-space: normal;height:100%'>                    <div class='chart'>                        <div style='width:100%;text-align: center;margin-bottom:5px;font-size:20px'>                            <a style='display: inline-grid;'>\u56fe \u4f8b</a>                        </div>                        <table style='width:100%;display:table;table-layout:fixed'>                            <tbody>                            <tr>                                <td style='width:88px;'>\u5217\u8868\u5e03\u5c40</td>                                <td style='width:114px;'><select id='legendOrient'>                                    <option value='horizontal'>\u6c34\u5e73</option>                                    <option value='vertical'>\u5782\u76f4</option>                                </select></td>                            </tr>                            <tr>                                <td>\u6587\u672c\u5bf9\u9f50</td>                                <td><select id='legendAlign'>                                    <option value='auto'>\u81ea\u52a8</option>                                    <option value='left'>\u5de6</option>                                    <option value='right'>\u53f3</option>                                </select></td>                            </tr>                            <tr>                                <td>\u663e\u793a\u56fe\u4f8b</td>                                <td><select id='legendShow'>                                    <option value='1' selected>\u663e\u793a</option>                                    <option value='0'>\u4e0d\u663e\u793a</option>                                </select></td>                            </tr>                            <tr>                                <td>\u80cc\u666f\u989c\u8272</td>                                <td>                                    <div style='width: 100px;margin-right:5px;display:table-cell'>                                        <input type='text' id='legendBgInput' style='margin-right:5px;' value='#FFFFFF'>                                    </div>                                    <div id='legendBg'                                         style='width: 80px; display: table-cell; height: 29px; border: 1px solid rgb(213, 213, 213); background-color: white;'></div>                                </td>                            </tr>                            <tr>                                <td>\u4e0a\u8fb9\u8ddd</td>                                <td><input type='text' autocomplete='off' id='legend-top' class='position' value='0'></td>                            </tr>                            <tr>                                <td>\u4e0b\u8fb9\u8ddd</td>                                <td><input type='text' autocomplete='off' id='legend-bottom' class='position' value='0'></td>                            </tr>                            <tr>                                <td>\u5de6\u8fb9\u8ddd</td>                                <td><input type='text' autocomplete='off' id='legend-left' class='position' value='0'></td>                            </tr>                            <tr>                                <td>\u53f3\u8fb9\u8ddd</td>                                <td><input type='text' autocomplete='off' id='legend-right' class='position' value='0'></td>                            </tr>                            <tr>                                <td>\u6587\u672c\u6837\u5f0f</td>                                <td></td>                            </tr>                            <tr>                                <td>\u989c\u8272</td>                                <td>                                    <div style='width: 100px;margin-right:5px;display:table-cell'>                                        <input type='text' id='legendColorInput' style='margin-right:5px;' value='#000000'>                                    </div>                                    <div id='legendColor'                                         style='width: 80px; display: table-cell; height: 29px; border: 1px solid rgb(213, 213, 213); background-color: black;'></div>                                </td>                            </tr>                            <tr>                                <td>\u5b57\u4f53\u98ce\u683c</td>                                <td><select id='legendStyle'>                                    <option value='normal'>\u6b63\u5e38</option>                                    <option value='italic'>\u659c\u4f53</option>                                    <option value='oblique'>\u503e\u659c</option>                                </select></td>                            </tr>                            <tr>                                <td>\u5b57\u4f53\u7c97\u7ec6</td>                                <td><select id='legendWeight'>                                    <option value='normal'>\u6b63\u5e38</option>                                    <option value='bold'>\u52a0\u7c97</option>                                </select></td>                            </tr>                            <tr>                                <td>\u5b57\u4f53\u540d\u79f0</td>                                <td><select id='legendFamily'>                                    <option value='Bitstream Vera Sans'>Bitstream Vera Sans</option>                                    <option value='DejaVu Sans'>DejaVu Sans</option>                                    <option value='DejaVu Sans Mono'>DejaVu Sans Mono</option>                                    <option value='\u5b8b\u4f53'>\u5b8b\u4f53</option>                                </select></td>                            </tr>                            <tr>                                <td>\u5b57\u4f53\u5927\u5c0f</td>                                <td><input type='text' autocomplete='off' id='legendSize' value='12'></td>                            </tr>                            </tbody>                        </table>                        <div class='link-top' style='margin: 10px 0'></div>                    </div>                </div>                <div class='layui-tab-item' id='grid' style='overflow: auto;white-space: normal;height:100%'>                    <div class='chart'>                        <div style='width: 100%;text-align: center;margin-bottom:5px;font-size:20px'>                            <a style='display: inline-grid;'>\u7f51 \u683c</a>                        </div>                        <table style='width: 100%;display:table;table-layout:fixed'>                            <tr>                                <td style='width:88px;'>\u663e\u793a\u7f51\u683c</td>                                <td style='width:114px;'>                                    <select id='gridShow'>                                        <option value='1'>\u663e\u793a</option>                                        <option value='0' selected>\u4e0d\u663e\u793a</option>                                    </select>                                </td>                            </tr>                            <tr>                                <td>\u662f\u5426\u5305\u542b<br>\u523b\u5ea6\u6807\u7b7e</td>                                <td>                                    <select id='containLabel'>                                        <option value='1'>\u5305\u542b</option>                                        <option value='0' selected>\u4e0d\u5305\u542b</option>                                    </select>                                </td>                            </tr>                            <tr>                                <td>\u80cc\u666f\u989c\u8272</td>                                <td>                                    <div style='width: 100px;display:table-cell'><input type='text' id='gridBgInput' style='margin-right:5px;' value='#ffffff'></div>                                    <div id='gridBg' style='width: 80px;display:table-cell;height:29px;border:1px solid #D5D5D5;'></div>                                </td>                            </tr>                            <tr><td>\u4e0a\u8fb9\u8ddd</td><td><input type='text' autocomplete='off' id='grid-top' class='position' value='0'></td></tr>                            <tr><td>\u4e0b\u8fb9\u8ddd</td><td><input type='text' autocomplete='off' id='grid-bottom' class='position' value='0'></td></tr>                            <tr><td>\u5de6\u8fb9\u8ddd</td><td><input type='text' autocomplete='off' id='grid-left' class='position' value='0'></td></tr>                            <tr><td>\u53f3\u8fb9\u8ddd</td><td><input type='text' autocomplete='off' id='grid-right' class='position' value='0'></td></tr>                        </table>                        <div class='link-top' style='margin: 10px 0'></div>                    </div>                </div>            </div>        </div>");
        return sb.toString();
    }

    public static String generateImage() {
        URL classPath = new BarPlugin().getClass().getClassLoader().getResource("");
        String path = classPath.getPath();
        byte[] data = null;
        FileImageInputStream input = null;
        try {
            input = new FileImageInputStream(new File(path + File.separator + "echarts.png"));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int numBytesRead = 0;
            while ((numBytesRead = input.read(buf)) != -1) {
                output.write(buf, 0, numBytesRead);
            }
            data = output.toByteArray();
            output.close();
            input.close();
        }
        catch (FileNotFoundException ex1) {
            ex1.printStackTrace();
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        return new String(data);
    }

    public static void main(String[] args) {
        String option = BarPlugin.generateDefaultOption();
        String path = "D:" + File.separator + "a.html";
        BarPlugin.generatePluginHtml(option, 600, 400, path);
    }

    public static int generatePluginPng(String htmlPath, int width, int height, String pngPath) throws Exception {
        htmlPath = URLEncoder.encode(htmlPath, "UTF-8");
        pngPath = URLEncoder.encode(pngPath, "UTF-8");
        int result = engine.Er_ExportPluginImage(htmlPath, width, height, pngPath);
        return result;
    }
}

