/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public class Scatter {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = Scatter.generateDefaultOption();
            String clazzName = Scatter.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-5.4.2.min.js'></script>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("function format(data) {     return Math.sqrt(data[2]) / 5e2;};");
                sb.append("var myChart = echarts.init(document.getElementById('main'));");
                sb.append("var option = ");
                sb.append(option + ";");
                sb.append("option.series[0].symbolSize = format;");
                sb.append("myChart.setOption(option);");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + Scatter.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                JSONArray yAxis;
                JSONObject yAxisObject;
                JSONArray xAxis;
                JSONObject xAxisObject;
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                optionJSON.put("categoryData", realDataJSON.get((Object)"categoryData"));
                optionJSON.put("seriesData", realDataJSON.get((Object)"seriesData"));
                optionJSON.put("valueData", realDataJSON.get((Object)"valueData"));
                optionJSON.put("xData", realDataJSON.get((Object)"xData"));
                optionJSON.put("yData", realDataJSON.get((Object)"yData"));
                if (optionJSON.containsKey((Object)"xAxis") && (xAxisObject = (xAxis = optionJSON.getJSONArray("xAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    xAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"yAxis") && (yAxisObject = (yAxis = optionJSON.getJSONArray("yAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    yAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"animation")) {
                    optionJSON.remove((Object)"animation");
                    optionJSON.put("animation", (Object)true);
                }
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        JSONArray dataArray = new JSONArray();
        JSONArray array = new JSONArray();
        array.add((Object)44056);
        array.add((Object)81.8);
        array.add((Object)23968973);
        array.add((Object)"Australia");
        array.add((Object)2015);
        dataArray.add((Object)array);
        JSONArray array1 = new JSONArray();
        array1.add((Object)43294);
        array1.add((Object)81.7);
        array1.add((Object)35939927);
        array1.add((Object)"Canada");
        array1.add((Object)2015);
        dataArray.add((Object)array1);
        JSONArray array2 = new JSONArray();
        array2.add((Object)13334);
        array2.add((Object)76.9);
        array2.add((Object)1376048943);
        array2.add((Object)"China");
        array2.add((Object)2015);
        dataArray.add((Object)array2);
        JSONArray array3 = new JSONArray();
        array3.add((Object)21291);
        array3.add((Object)78.5);
        array3.add((Object)11389562);
        array3.add((Object)"Cuba");
        array3.add((Object)2015);
        dataArray.add((Object)array3);
        JSONArray array4 = new JSONArray();
        array4.add((Object)38923);
        array4.add((Object)80.8);
        array4.add((Object)5503457);
        array4.add((Object)"Finland");
        array4.add((Object)2015);
        dataArray.add((Object)array4);
        sb.append("{");
        sb.append("animation:false,");
        sb.append("initTimes:0,");
        sb.append("   title: {");
        sb.append("        text: '\u6563\u5217\u56fe'");
        sb.append("    },");
        sb.append("   tooltip: {");
        sb.append("        show: true,");
        sb.append("        formatter: '{a}:{b}<br />{c}'");
        sb.append("    },");
        sb.append("    legend: {");
        sb.append("        data: ['2015'],type:'scroll'");
        sb.append("    },");
        sb.append("    xAxis: {");
        sb.append("        splitLine: {");
        sb.append("            lineStyle: {");
        sb.append("                type: 'dashed'");
        sb.append("            }");
        sb.append("        }");
        sb.append("    },");
        sb.append("    yAxis: {");
        sb.append("        splitLine: {");
        sb.append("            lineStyle: {");
        sb.append("                type: 'dashed'");
        sb.append("            }");
        sb.append("        },");
        sb.append("        scale: true");
        sb.append("    },");
        sb.append("    series: [{");
        sb.append("    name: '2015',");
        sb.append("            data: " + dataArray.toString() + ",");
        sb.append("            type: 'scatter',");
        sb.append("    emphasis: {");
        sb.append("        label: {");
        sb.append("            show: true,");
        sb.append("            position: 'top'");
        sb.append("        }");
        sb.append("    }");
        sb.append("}]");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        Set keySet;
        JSONObject hyperLinkObj;
        JSONObject backColorObj;
        path = path.replace(".html", ".plugin");
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String xData = (String)optionObject.get((Object)"xData");
        String yData = (String)optionObject.get((Object)"yData");
        boolean labelShow = false;
        if (optionObject.containsKey((Object)"labelShow")) {
            labelShow = (Boolean)optionObject.get((Object)"labelShow");
        }
        String labelText = (String)optionObject.get((Object)"labelText");
        JSONArray legendArray = new JSONArray();
        JSONArray nameArray = new JSONArray();
        JSONArray dataArrays = new JSONArray();
        String[] categoryDatas = categoryData.split(",");
        String[] xDatas = xData.split(",");
        String[] yDatas = yData.split(",");
        String[] valueDatas = valueData.split(",");
        double max = 10.0;
        for (int i = 0; i < valueDatas.length; ++i) {
            String data = valueDatas[i];
            double da = Double.parseDouble(data);
            if (!(da > max)) continue;
            max = da;
        }
        max /= 100.0;
        String[] seriesDatas = seriesData.split(",");
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONArray seriesArray = new JSONArray();
            legendArray.add((Object)seriesDatas[i]);
            for (int j = 0; j < categoryDatas.length; ++j) {
                JSONArray dataArray = new JSONArray();
                dataArray.add((Object)Double.parseDouble(xDatas[j + i * categoryDatas.length]));
                dataArray.add((Object)Double.parseDouble(yDatas[j + i * categoryDatas.length]));
                dataArray.add((Object)Double.parseDouble(valueDatas[j + i * categoryDatas.length]));
                dataArray.add((Object)categoryDatas[j]);
                dataArray.add((Object)seriesDatas[i]);
                seriesArray.add((Object)dataArray);
            }
            dataArrays.add((Object)seriesArray);
        }
        JSONArray legendArr = optionObject.getJSONArray("legend");
        JSONObject legendObj = legendArr.getJSONObject(0);
        legendObj.put("data", (Object)legendArray);
        JSONArray seriesArr = optionObject.getJSONArray("series");
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject labelObj;
            JSONObject emphasisObj;
            JSONObject seriesObj;
            if (i < seriesArr.size()) {
                seriesObj = seriesArr.getJSONObject(i);
                seriesObj.put("data", (Object)dataArrays.getJSONArray(i));
                seriesObj.put("name", (Object)seriesDatas[i]);
                emphasisObj = new JSONObject();
                labelObj = new JSONObject();
                labelObj.put("show", (Object)true);
                labelObj.put("position", (Object)"top");
                emphasisObj.put("label", (Object)labelObj);
                seriesObj.put("emphasis", (Object)emphasisObj);
                continue;
            }
            seriesObj = new JSONObject();
            seriesObj.put("data", (Object)dataArrays.getJSONArray(i));
            seriesObj.put("name", (Object)seriesDatas[i]);
            seriesObj.put("type", (Object)"scatter");
            emphasisObj = new JSONObject();
            labelObj = new JSONObject();
            labelObj.put("show", (Object)true);
            labelObj.put("position", (Object)"top");
            emphasisObj.put("label", (Object)labelObj);
            seriesObj.put("emphasis", (Object)emphasisObj);
            JSONObject labelObj1 = new JSONObject();
            labelObj.put("show", (Object)true);
            seriesObj.put("label", (Object)labelObj1);
            seriesArr.add((Object)seriesObj);
        }
        optionObject.put("series", (Object)seriesArr);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        JSONArray cssArray = new JSONArray();
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsArray.add((Object)(jsResourcePath + "/echarts-5.4.2.min.js"));
        jsBuffer.append(jsArray.toString());
        cssBuffer.append(cssArray.toString());
        long time = new Random().nextLong();
        if (time < 0L) {
            time = 0L - time;
        }
        domBuffer.append("<div id='main_" + time + "' style='width:100%;height:100%;'></div>");
        scriptBuffer.append("var myChart_" + time + " = echarts.init(document.getElementById('main_" + time + "'));");
        scriptBuffer.append("var option_" + time + " = ");
        scriptBuffer.append(optionObject.toString());
        scriptBuffer.append(";");
        scriptBuffer.append("function format(data) {     return data[2] / " + max + ";};");
        scriptBuffer.append("function format1(param) {      return param.data[2];};");
        scriptBuffer.append("function format2(param) {   return param.data[4] + '<br/>' + param.data[2];};");
        for (int i = 0; i < seriesDatas.length; ++i) {
            scriptBuffer.append("option_" + time + ".series[" + i + "].symbolSize = format;");
            scriptBuffer.append("option_" + time + ".series[" + i + "].emphasis.label.formatter = format1;");
            scriptBuffer.append("if(option_" + time + ".series[" + i + "].label != undefined){option_" + time + ".series[" + i + "].label.formatter = format1;option_" + time + ".series[" + i + "].label.show = " + labelShow + ";}");
        }
        scriptBuffer.append("myChart_" + time + ".setOption(option_" + time + ");");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        String repaintRegions = reportInfoObj.getString("repaintRegions");
        JSONObject repaintRegionsObj = JSONObject.parseObject((String)repaintRegions);
        if (hyperLinkArray != null && repaintRegionsObj != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);");
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1');");
            scriptBuffer.append("});");
        } else if (repaintRegionsObj != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        } else if (hyperLinkArray != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);});");
        }
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        JSONObject backColorObj;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String xData = (String)optionObject.get((Object)"xData");
        String yData = (String)optionObject.get((Object)"yData");
        boolean labelShow = false;
        if (optionObject.containsKey((Object)"labelShow")) {
            labelShow = (Boolean)optionObject.get((Object)"labelShow");
        }
        String labelText = (String)optionObject.get((Object)"labelText");
        JSONArray legendArray = new JSONArray();
        JSONArray nameArray = new JSONArray();
        JSONArray dataArrays = new JSONArray();
        String[] categoryDatas = categoryData.split(",");
        String[] xDatas = xData.split(",");
        String[] yDatas = yData.split(",");
        String[] valueDatas = valueData.split(",");
        double max = 10.0;
        for (int i = 0; i < valueDatas.length; ++i) {
            String data = valueDatas[i];
            double da = Double.parseDouble(data);
            if (!(da > max)) continue;
            max = da;
        }
        max /= 100.0;
        String[] seriesDatas = seriesData.split(",");
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONArray seriesArray = new JSONArray();
            legendArray.add((Object)seriesDatas[i]);
            for (int j = 0; j < categoryDatas.length; ++j) {
                JSONArray dataArray = new JSONArray();
                dataArray.add((Object)Double.parseDouble(xDatas[j + i * categoryDatas.length]));
                dataArray.add((Object)Double.parseDouble(yDatas[j + i * categoryDatas.length]));
                dataArray.add((Object)Double.parseDouble(valueDatas[j + i * categoryDatas.length]));
                dataArray.add((Object)categoryDatas[j]);
                dataArray.add((Object)seriesDatas[i]);
                seriesArray.add((Object)dataArray);
            }
            dataArrays.add((Object)seriesArray);
        }
        JSONArray legendArr = optionObject.getJSONArray("legend");
        JSONObject legendObj = legendArr.getJSONObject(0);
        legendObj.put("data", (Object)legendArray);
        JSONArray seriesArr = optionObject.getJSONArray("series");
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject labelObj;
            JSONObject emphasisObj;
            JSONObject seriesObj;
            if (i < seriesArr.size()) {
                seriesObj = seriesArr.getJSONObject(i);
                seriesObj.put("data", (Object)dataArrays.getJSONArray(i));
                seriesObj.put("name", (Object)seriesDatas[i]);
                emphasisObj = new JSONObject();
                labelObj = new JSONObject();
                labelObj.put("show", (Object)true);
                labelObj.put("position", (Object)"top");
                emphasisObj.put("label", (Object)labelObj);
                seriesObj.put("emphasis", (Object)emphasisObj);
                continue;
            }
            seriesObj = new JSONObject();
            seriesObj.put("data", (Object)dataArrays.getJSONArray(i));
            seriesObj.put("name", (Object)seriesDatas[i]);
            seriesObj.put("type", (Object)"scatter");
            emphasisObj = new JSONObject();
            labelObj = new JSONObject();
            labelObj.put("show", (Object)true);
            labelObj.put("position", (Object)"top");
            emphasisObj.put("label", (Object)labelObj);
            seriesObj.put("emphasis", (Object)emphasisObj);
            JSONObject labelObj1 = new JSONObject();
            labelObj.put("show", (Object)true);
            seriesObj.put("label", (Object)labelObj1);
            seriesArr.add((Object)seriesObj);
        }
        optionObject.put("series", (Object)seriesArr);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(optionObject.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        String resultStr = null;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String xData = (String)optionObject.get((Object)"xData");
        String yData = (String)optionObject.get((Object)"yData");
        boolean labelShow = false;
        if (optionObject.containsKey((Object)"labelShow")) {
            labelShow = (Boolean)optionObject.get((Object)"labelShow");
        }
        String labelText = (String)optionObject.get((Object)"labelText");
        JSONArray legendArray = new JSONArray();
        JSONArray nameArray = new JSONArray();
        JSONArray dataArrays = new JSONArray();
        String[] categoryDatas = categoryData.split(",");
        String[] xDatas = xData.split(",");
        String[] yDatas = yData.split(",");
        String[] valueDatas = valueData.split(",");
        double max = 10.0;
        for (int i = 0; i < valueDatas.length; ++i) {
            String data = valueDatas[i];
            double da = Double.parseDouble(data);
            if (!(da > max)) continue;
            max = da;
        }
        max /= 100.0;
        String[] seriesDatas = seriesData.split(",");
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONArray seriesArray = new JSONArray();
            legendArray.add((Object)seriesDatas[i]);
            for (int j = 0; j < categoryDatas.length; ++j) {
                JSONArray dataArray = new JSONArray();
                dataArray.add((Object)Double.parseDouble(xDatas[j + i * categoryDatas.length]));
                dataArray.add((Object)Double.parseDouble(yDatas[j + i * categoryDatas.length]));
                dataArray.add((Object)Double.parseDouble(valueDatas[j + i * categoryDatas.length]));
                dataArray.add((Object)categoryDatas[j]);
                dataArray.add((Object)seriesDatas[i]);
                seriesArray.add((Object)dataArray);
            }
            dataArrays.add((Object)seriesArray);
        }
        JSONArray legendArr = optionObject.getJSONArray("legend");
        JSONObject legendObj = legendArr.getJSONObject(0);
        legendObj.put("data", (Object)legendArray);
        JSONArray seriesArr = optionObject.getJSONArray("series");
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject labelObj;
            JSONObject emphasisObj;
            JSONObject seriesObj;
            if (i < seriesArr.size()) {
                seriesObj = seriesArr.getJSONObject(i);
                seriesObj.put("data", (Object)dataArrays.getJSONArray(i));
                seriesObj.put("name", (Object)seriesDatas[i]);
                emphasisObj = new JSONObject();
                labelObj = new JSONObject();
                labelObj.put("show", (Object)true);
                labelObj.put("position", (Object)"top");
                emphasisObj.put("label", (Object)labelObj);
                seriesObj.put("emphasis", (Object)emphasisObj);
                continue;
            }
            seriesObj = new JSONObject();
            seriesObj.put("data", (Object)dataArrays.getJSONArray(i));
            seriesObj.put("name", (Object)seriesDatas[i]);
            seriesObj.put("type", (Object)"scatter");
            emphasisObj = new JSONObject();
            labelObj = new JSONObject();
            labelObj.put("show", (Object)true);
            labelObj.put("position", (Object)"top");
            emphasisObj.put("label", (Object)labelObj);
            seriesObj.put("emphasis", (Object)emphasisObj);
            JSONObject labelObj1 = new JSONObject();
            labelObj.put("show", (Object)true);
            seriesObj.put("label", (Object)labelObj1);
            seriesArr.add((Object)seriesObj);
        }
        optionObject.put("series", (Object)seriesArr);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/bmap.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("function format(data) {     return data[2] / " + max + ";};");
        sb.append("function format1(param) {      return param.data[2];};");
        sb.append("$(document).ready(function(){");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(optionObject.toString());
        sb.append(";");
        for (int i = 0; i < seriesDatas.length; ++i) {
            sb.append("option.series[" + i + "].symbolSize = format;");
            sb.append("option.series[" + i + "].emphasis.label.formatter = format1;");
            sb.append("if(option.series[" + i + "].label != undefined){option.series[" + i + "].label.formatter = format1;option.series[" + i + "].label.show = " + labelShow + ";}");
        }
        sb.append("myChart.setOption(option);");
        sb.append("window.addEventListener('resize',function(){");
        sb.append("    myChart.resize();");
        sb.append("});");
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u6563\u5217\u56fe";
    }

    public static String getClassName() {
        return "Scatter";
    }

    public static void main(String[] args) {
        System.out.println(Scatter.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        JSONObject defaultJson = JSONObject.parseObject((String)Scatter.generateDefaultOption());
        JSONArray seriesDefaultObj = (JSONArray)defaultJson.get((Object)"series");
        if (optionJson.containsKey((Object)"labelShow")) {
            boolean flag = optionJson.getBoolean("labelShow");
            for (int i = 0; i < seriesDefaultObj.size(); ++i) {
                JSONObject seriesObject = seriesDefaultObj.getJSONObject(i);
                JSONObject labelObject = new JSONObject();
                labelObject.put("show", (Object)flag);
                seriesObject.put("label", (Object)labelObject);
            }
        }
        optionJson.put("series", (Object)seriesDefaultObj);
        return optionJson.toString();
    }
}

