/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.database;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import sun.misc.BASE64Encoder;

public class EFReportDB {
    public static String[] defaultDB = new String[]{"SQLITE", "MYSQL", "POSTGRESQL", "SQL SERVER", "ORACLE", "SYBASE", "DB2", "INFORMIX", "HIVE", "SAP", "ODBC", "IGNITE", "JSON", "HTTP", "ACCESS", "EXCEL"};
    public Class clz;
    public Object instance;
    public Connection connection = null;
    public ResultSet rs;
    public PreparedStatement ps;
    public JSONObject connObject = new JSONObject();
    public JSONObject httpResult = new JSONObject();
    public String connFileName;
    public int indexNum = -1;
    public long lastUpdateTime = 0L;
    public String connUrl;
    public String connUserName;
    public String connPass;
    public long lastConnectTime = 0L;

    public boolean setConnFileName(String fileName) {
        try {
            String str;
            this.connFileName = fileName;
            File jsonFile = new File(fileName);
            this.lastUpdateTime = jsonFile.lastModified();
            FileInputStream fis = new FileInputStream(jsonFile);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader in = new BufferedReader(inputStreamReader);
            StringBuffer sb = new StringBuffer();
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
            in.close();
            String jsonText = sb.toString();
            JSONArray jsonArray = JSONArray.parseArray((String)jsonText);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                String name = object.getString("name");
                this.connObject.put(name, (Object)object);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setConnObject(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            String name = object.getString("name");
            this.connObject.put(name, (Object)object);
        }
    }

    public boolean forClassWithFirst(String path) {
        try {
            String str;
            File jsonFile = new File(path);
            FileInputStream fis = new FileInputStream(jsonFile);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader in = new BufferedReader(inputStreamReader);
            StringBuffer sb = new StringBuffer();
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
            in.close();
            String jsonText = sb.toString();
            JSONArray jsonArray = JSONArray.parseArray((String)jsonText);
            JSONObject object = jsonArray.getJSONObject(0);
            String type = object.getString("type");
            if ("SQLITE".equals(type)) {
                Class.forName("org.sqlite.JDBC");
            } else if ("ORACLE".equals(type)) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
            } else if ("MYSQL".equals(type)) {
                Class.forName("com.mysql.cj.jdbc.Driver");
            } else if ("SQL SERVER".equals(type)) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            } else if ("POSTGRESQL".equals(type)) {
                Class.forName("org.postgresql.Driver");
            } else if ("ODBC".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("EXCEL".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("ACCESS".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("SAP".equals(type)) {
                Class.forName("com.sap.db.jdbc.Driver");
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String connName, String url) {
        block34: {
            JSONObject object = this.connObject.getJSONObject(connName);
            String username = object.getString("username");
            String password = object.getString("password");
            String type = object.getString("type");
            this.connUrl = url;
            this.connUserName = username;
            this.connPass = password;
            try {
                List<String> dbList = Arrays.asList(defaultDB);
                if (!dbList.contains(type)) {
                    String className = "com.efreport.database." + type;
                    this.clz = Class.forName(className);
                    this.instance = this.clz.newInstance();
                    Method setM = this.clz.getMethod("setConnFileName", String.class);
                    setM.invoke(this.instance, this.connFileName);
                    Method method = this.clz.getMethod("connect", String.class, String.class);
                    boolean flag = (Boolean)method.invoke(this.instance, connName, url);
                    return flag;
                }
                if ("HTTP".equals(type)) {
                    this.indexNum = -1;
                    HttpURLConnection connection = null;
                    InputStream is = null;
                    BufferedReader br = null;
                    String result = null;
                    try {
                        url = url.replace(" ", "%20");
                        URL httpUrl = new URL(url);
                        connection = (HttpURLConnection)httpUrl.openConnection();
                        connection.setRequestMethod("GET");
                        connection.setConnectTimeout(15000);
                        connection.setReadTimeout(60000);
                        connection.connect();
                        if (connection.getResponseCode() == 200) {
                            is = connection.getInputStream();
                            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                            StringBuffer sbf = new StringBuffer();
                            String temp = null;
                            while ((temp = br.readLine()) != null) {
                                sbf.append(temp);
                                sbf.append("\r\n");
                            }
                            result = sbf.toString();
                            this.httpResult = JSONObject.parseObject((String)result);
                        }
                        break block34;
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                        break block34;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block34;
                    }
                    finally {
                        if (null != br) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (null != is) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        connection.disconnect();
                    }
                }
                if ("JSON".equals(type)) {
                    this.indexNum = -1;
                    File file = new File(url);
                    String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
                    this.httpResult = JSONObject.parseObject((String)content);
                } else {
                    if (this.connection != null && !this.connection.isClosed()) {
                        return true;
                    }
                    this.connection = DriverManager.getConnection(url, username, password);
                    long times = System.currentTimeMillis();
                    Date date = new Date(times);
                    this.lastConnectTime = date.getTime();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean connect(String url, String username, String password) {
        try {
            this.connection = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getTableName(String type, String url, String username, String password, int page, int pageSize, String keyword) {
        JSONObject res = new JSONObject();
        JSONArray tables = new JSONArray();
        String sql = null;
        if (type.equals("ORACLE")) {
            sql = "SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER='" + username + "'";
        } else if (type.equals("SQL SERVER")) {
            sql = "SELECT NAME AS TABLE_NAME FROM sysobjects Where xtype='U' ORDER BY name";
        } else if (type.equals("MYSQL")) {
            sql = "SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema=(select database()) AND table_type='BASE TABLE'";
        } else if (type.equals("POSTGRESQL")) {
            sql = "select TABLE_NAME from INFORMATION_SCHEMA.tables where table_type='BASE TABLE' and table_name not like 'pg_%' and table_name not like 'sql_%'";
        } else if (type.equals("SQLITE")) {
            sql = "SELECT NAME AS TABLE_NAME FROM sqlite_master WHERE type='table'";
        } else if (type.equals("ODBC")) {
            sql = "SELECT NAME AS TABLE_NAME FROM sqlite_master WHERE type='table'";
        } else if (type.equals("SAP")) {
            sql = "select OBJECT_NAME AS TABLE_NAME from objects WHERE schema_name='_SYS_BIC'";
        }
        try {
            List<String> dbs = Arrays.asList(defaultDB);
            if (!dbs.contains(type)) {
                String className = "com.efreport.database." + type;
                Class<?> clazz = Class.forName(className);
                Method getTableM = clazz.getMethod("getTableName", String.class, String.class, String.class, String.class);
                return (String)getTableM.invoke(null, type, url, username, password);
            }
            if ("SQLITE".equals(type)) {
                Class.forName("org.sqlite.JDBC");
            } else if ("ORACLE".equals(type)) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
            } else if ("MYSQL".equals(type)) {
                Class.forName("com.mysql.cj.jdbc.Driver");
            } else if ("SQL SERVER".equals(type)) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            } else if ("POSTGRESQL".equals(type)) {
                Class.forName("org.postgresql.Driver");
            } else if ("ODBC".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("EXCEL".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("ACCESS".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("SAP".equals(type)) {
                Class.forName("com.sap.db.jdbc.Driver");
            }
            if ("ODBC".equals(type)) {
                Connection connection = DriverManager.getConnection(url);
                Statement stmt = connection.createStatement();
                DatabaseMetaData dbmd = connection.getMetaData();
                ResultSet rs = dbmd.getTables(null, null, "%", null);
                while (rs.next()) {
                    String tableName = rs.getString(3);
                    if (keyword != null) {
                        if (!tableName.contains(keyword)) continue;
                        tables.add((Object)tableName);
                        continue;
                    }
                    tables.add((Object)tableName);
                }
                stmt.close();
                connection.close();
                JSONArray pageArray = new JSONArray();
                int start = pageSize * (page - 1);
                int end = pageSize * page;
                for (int i = start; i < end; ++i) {
                    if (i >= tables.size()) continue;
                    String tableName = tables.getString(i);
                    pageArray.add((Object)tableName);
                }
                res.put("total", (Object)tables.size());
                res.put("page", (Object)pageArray);
                return res.toJSONString();
            }
            if ("HTTP".equals(type)) {
                HttpURLConnection connection = null;
                InputStream is = null;
                BufferedReader br = null;
                String result = null;
                try {
                    String jsonString;
                    url = url.replace(" ", "%20");
                    URL httpUrl = new URL(url);
                    connection = (HttpURLConnection)httpUrl.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(15000);
                    connection.setReadTimeout(60000);
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.connect();
                    if (connection.getResponseCode() != 200) return res.toJSONString();
                    is = connection.getInputStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = is.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                    }
                    result = jsonString = baos.toString();
                    JSONObject result1 = JSONObject.parseObject((String)result);
                    Set keys = result1.keySet();
                    Iterator iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        tables.add(iterator.next());
                    }
                    res.put("total", (Object)1);
                    res.put("page", (Object)tables);
                    return res.toJSONString();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return res.toJSONString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return res.toJSONString();
                }
                finally {
                    if (null != br) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (null != is) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    connection.disconnect();
                }
            }
            if ("JSON".equals(type)) {
                File file = new File(url);
                String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
                JSONObject result1 = JSONObject.parseObject((String)content);
                Set keys = result1.keySet();
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    tables.add(iterator.next());
                }
                res.put("total", (Object)1);
                res.put("page", (Object)tables);
                return res.toJSONString();
            } else {
                Connection connection = DriverManager.getConnection(url, username, password);
                PreparedStatement ps = connection.prepareStatement(sql);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    if (keyword != null) {
                        if (!tableName.contains(keyword)) continue;
                        tables.add((Object)tableName);
                        continue;
                    }
                    tables.add((Object)tableName);
                }
                rs.close();
                ps.close();
                connection.close();
                JSONArray pageArray = new JSONArray();
                int start = pageSize * (page - 1);
                int end = pageSize * page;
                for (int i = start; i < end; ++i) {
                    if (i >= tables.size()) continue;
                    String tableName = tables.getString(i);
                    pageArray.add((Object)tableName);
                }
                res.put("total", (Object)tables.size());
                res.put("page", (Object)pageArray);
            }
            return res.toJSONString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public JSONObject getResultsByPage(String connName, String sql, int count) {
        JSONObject object = this.connObject.getJSONObject(connName);
        String type = object.getString("type");
        JSONObject res = new JSONObject();
        ArrayList list = new ArrayList();
        try {
            if ("SQLITE".equals(type)) {
                Class.forName("org.sqlite.JDBC");
            } else if ("ORACLE".equals(type)) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
            } else if ("MYSQL".equals(type)) {
                Class.forName("com.mysql.cj.jdbc.Driver");
            } else if ("SQL SERVER".equals(type)) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            } else if ("POSTGRESQL".equals(type)) {
                Class.forName("org.postgresql.Driver");
            } else if ("ODBC".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("EXCEL".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("ACCESS".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("SAP".equals(type)) {
                Class.forName("com.sap.db.jdbc.Driver");
            }
            if (this.instance != null) {
                Method method = this.clz.getMethod("getResultsByPage", String.class, String.class, Integer.TYPE);
                JSONObject result = (JSONObject)method.invoke(this.instance, connName, sql, count);
                return result;
            }
            if ("HTTP".equals(type) || "JSON".equals(type)) {
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    res.put("total", (Object)value.size());
                    for (int i = 0; i < count; ++i) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        if (i >= value.size()) continue;
                        JSONObject object1 = value.getJSONObject(i);
                        if (object1 != null) {
                            for (String key1 : object1.keySet()) {
                                map.put(key1, object1.get((Object)key1));
                            }
                        }
                        list.add(map);
                    }
                    res.put("list", list);
                }
            } else {
                int total = 0;
                String totalSql = "select count(*) from (" + sql + ") A";
                PreparedStatement ps1 = this.connection.prepareStatement(totalSql);
                ResultSet rs1 = ps1.executeQuery();
                while (rs1.next()) {
                    total = rs1.getInt(1);
                }
                res.put("total", (Object)total);
                this.ps = this.connection.prepareStatement(sql);
                this.rs = this.ps.executeQuery();
                ResultSetMetaData metaData = this.rs.getMetaData();
                while (this.rs.next() && count > 0) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    int cols_len = metaData.getColumnCount();
                    for (int i = 0; i < cols_len; ++i) {
                        Object col_value;
                        String col_name = metaData.getColumnLabel(i + 1);
                        if (col_name == null) {
                            col_name = metaData.getColumnName(i + 1);
                        }
                        col_value = (col_value = this.rs.getObject(i + 1)) == null ? "" : col_value.toString();
                        map.put(col_name, col_value);
                    }
                    list.add(map);
                    --count;
                }
                res.put("list", list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean testConnection(String type, String url, String username, String password) {
        try {
            if ("SQLITE".equals(type)) {
                Class.forName("org.sqlite.JDBC");
            } else if ("ORACLE".equals(type)) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
            } else if ("MYSQL".equals(type)) {
                Class.forName("com.mysql.cj.jdbc.Driver");
            } else if ("SQL SERVER".equals(type)) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            } else if ("POSTGRESQL".equals(type)) {
                Class.forName("org.postgresql.Driver");
            } else if ("ODBC".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("EXCEL".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if ("ACCESS".equals(type)) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else {
                if ("HTTP".equals(type)) {
                    url = url.replace(" ", "%20");
                    HttpURLConnection connection = null;
                    InputStream is = null;
                    BufferedReader br = null;
                    try {
                        if ("HTTP".equals(type) && url.contains("?")) {
                            String[] urls = url.split("\\?");
                            url = urls[0];
                        }
                        URL httpUrl = new URL(url);
                        connection = (HttpURLConnection)httpUrl.openConnection();
                        connection.setRequestMethod("GET");
                        connection.setConnectTimeout(15000);
                        connection.setReadTimeout(60000);
                        connection.connect();
                        if (connection.getResponseCode() == 200) {
                            is = connection.getInputStream();
                            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                            StringBuffer sbf = new StringBuffer();
                            String temp = null;
                            while (true) {
                                if ((temp = br.readLine()) == null) {
                                    String result = sbf.toString();
                                    JSONObject.parseObject((String)result);
                                    boolean bl = true;
                                    return bl;
                                }
                                sbf.append(temp);
                                sbf.append("\r\n");
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                        boolean bl = false;
                        return bl;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        if (null != br) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (null != is) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        connection.disconnect();
                    }
                }
                if ("JSON".equals(type)) {
                    File file = new File(url);
                    FileUtils.readFileToString((File)file, (String)"UTF-8");
                    return true;
                }
                if ("SYBASE".equals(type)) {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                } else if ("DB2".equals(type)) {
                    Class.forName("com.ibm.db2.jcc.DB2Driver");
                } else if ("INFORMIX".equals(type)) {
                    Class.forName("com.informix.jdbc.IfxDriver");
                } else if ("HIVE".equals(type)) {
                    Class.forName("org.apache.hive.jdbc.HiveDriver");
                } else if ("SAP".equals(type)) {
                    Class.forName("com.sap.db.jdbc.Driver");
                } else if ("ODBC".equals(type)) {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                } else if ("EXCEL".equals(type)) {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                } else if ("ACCESS".equals(type)) {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                } else if ("IGNITE".equals(type)) {
                    Class.forName("org.apache.ignite.IgniteJdbcDriver");
                }
            }
            Connection connection = DriverManager.getConnection(url, username, password);
            connection.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getFieldNames(String sqlStr) {
        JSONArray names = new JSONArray();
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getFieldNames", String.class);
                String fields = (String)method.invoke(this.instance, sqlStr);
                return fields;
            }
            if (this.httpResult.size() > 0) {
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(0);
                    Iterator itemIterator = item.keySet().iterator();
                    while (itemIterator.hasNext()) {
                        names.add(itemIterator.next());
                    }
                }
            } else {
                PreparedStatement ps = this.connection.prepareStatement(sqlStr);
                this.rs = ps.executeQuery();
                ResultSetMetaData data = this.rs.getMetaData();
                for (int i = 1; i <= data.getColumnCount(); ++i) {
                    String columnName = data.getColumnLabel(i);
                    names.add((Object)columnName);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return names.toString();
    }

    public boolean next() {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("next", new Class[0]);
                boolean flag = (Boolean)method.invoke(this.instance, new Object[0]);
                return flag;
            }
            if (this.httpResult.size() > 0) {
                Iterator iterator = this.httpResult.keySet().iterator();
                if (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    JSONArray value = this.httpResult.getJSONArray(key);
                    if (this.indexNum < value.size() - 1) {
                        ++this.indexNum;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return this.rs.next();
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFieldTypeByIndex(int index) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getFieldTypeByIndex", Integer.TYPE);
                int res = (Integer)method.invoke(this.instance, index);
                return res;
            }
            if (this.httpResult.size() > 0) {
                int type = 1;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            try {
                                Integer.parseInt(value1);
                                type = 2;
                                return type;
                            }
                            catch (Exception e) {
                                try {
                                    Double.parseDouble(value1);
                                    type = 3;
                                }
                                catch (Exception e1) {
                                    type = 1;
                                    return type;
                                }
                            }
                            finally {
                                return type;
                            }
                        }
                        ++i;
                    }
                }
                return type;
            }
            ResultSetMetaData data = this.rs.getMetaData();
            int columnType = data.getColumnType(index);
            if (columnType == 1 || columnType == 12 || columnType == -1 || columnType == -9 || columnType == -15) {
                return 1;
            }
            if (columnType == -7 || columnType == -6 || columnType == 5 || columnType == 4) {
                return 2;
            }
            if (columnType == 8 || columnType == 6 || columnType == 7) {
                return 3;
            }
            if (columnType == 91 || columnType == -15 || columnType == -16) {
                return 4;
            }
            if (columnType == 92 || columnType == 93) {
                return 5;
            }
            if (columnType == 16) {
                return 6;
            }
            if (columnType == -4) {
                return 7;
            }
            if (columnType == 3 || columnType == 2) {
                return 9;
            }
            if (columnType == -5) {
                return 8;
            }
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getFieldNameByIndex(int index) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getFieldNameByIndex", Integer.TYPE);
                String res = (String)method.invoke(this.instance, index);
                return res;
            }
            if (this.httpResult.size() > 0) {
                String fieldName = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(0);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        if (i == index) {
                            return key1;
                        }
                        ++i;
                    }
                }
                return fieldName;
            }
            ResultSetMetaData data = this.rs.getMetaData();
            String columnType = data.getColumnLabel(index);
            return columnType;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getValueByIndex(int index, int type) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getValueByIndex", Integer.TYPE, Integer.TYPE);
                String res = (String)method.invoke(this.instance, index, type);
                return res;
            }
            if (this.httpResult.size() > 0) {
                String result = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            return value1;
                        }
                        ++i;
                    }
                }
                return result;
            }
            if (type == 1) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            if (type == 2) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            if (type == 3) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            if (type == 4) {
                Timestamp timestamp = this.rs.getTimestamp(index);
                if (timestamp == null) {
                    return "";
                }
                long time = timestamp.getTime();
                return String.valueOf(time);
            }
            if (type == 5) {
                Timestamp timestamp = this.rs.getTimestamp(index);
                if (timestamp == null) {
                    return "";
                }
                long time = timestamp.getTime();
                return String.valueOf(time);
            }
            if (type == 6) {
                return this.rs.getString(index) == null ? "" : this.rs.getString(index);
            }
            if (type == 7) {
                Blob blob = this.rs.getBlob(index);
                InputStream msgContent = blob.getBinaryStream();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] buffer = new byte[100];
                int n = 0;
                while (-1 != (n = msgContent.read(buffer))) {
                    output.write(buffer, 0, n);
                }
                return new BASE64Encoder().encode(output.toByteArray());
            }
            if (type == 8) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            if (type == 9) {
                String value = this.rs.getString(index);
                return value == null ? "" : value;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getIsNullByIndex(int index, int type) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getIsNullByIndex", Integer.TYPE, Integer.TYPE);
                boolean res = (Boolean)method.invoke(this.instance, index, type);
                return res;
            }
            if (this.httpResult.size() > 0) {
                Object result = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            return value1 == null;
                        }
                        ++i;
                    }
                }
                return true;
            }
            if (type == 1) {
                String value = this.rs.getString(index);
                return value == null;
            }
            if (type == 2) {
                String value = this.rs.getString(index);
                return value == null;
            }
            if (type == 3) {
                String value = this.rs.getString(index);
                return value == null;
            }
            if (type == 4) {
                Timestamp timestamp = this.rs.getTimestamp(index);
                return timestamp == null;
            }
            if (type == 5) {
                Timestamp timestamp = this.rs.getTimestamp(index);
                return timestamp == null;
            }
            if (type == 6) {
                return this.rs.getString(index) == null;
            }
            if (type == 7) {
                Blob blob = this.rs.getBlob(index);
                return blob == null;
            }
            if (type == 8) {
                String value = this.rs.getString(index);
                return value == null;
            }
            if (type == 9) {
                String value = this.rs.getString(index);
                return value == null;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public int getIntValueByIndex(int index) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getIntValueByIndex", Integer.TYPE);
                int res = (Integer)method.invoke(this.instance, index);
                return res;
            }
            if (this.httpResult.size() > 0) {
                String result = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            return Integer.parseInt(value1);
                        }
                        ++i;
                    }
                }
                return Integer.parseInt(result);
            }
            return this.rs.getInt(index);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getLongValueByIndex(int index) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getIntValueByIndex", Integer.TYPE);
                long res = (Long)method.invoke(this.instance, index);
                return res;
            }
            if (this.httpResult.size() > 0) {
                String result = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            return Long.parseLong(value1);
                        }
                        ++i;
                    }
                }
                return Long.parseLong(result);
            }
            return this.rs.getLong(index);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public double getDoubleValueByIndex(int index) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getIntValueByIndex", Integer.TYPE);
                double res = (Double)method.invoke(this.instance, index);
                return res;
            }
            if (this.httpResult.size() > 0) {
                String result = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            return Double.parseDouble(result);
                        }
                        ++i;
                    }
                }
                return Double.parseDouble(result);
            }
            return this.rs.getDouble(index);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String getStringValueByIndex(int index) {
        try {
            if (this.instance != null) {
                try {
                    Method method = this.clz.getMethod("getStringValueByIndex", Integer.TYPE);
                    String res = (String)method.invoke(this.instance, index);
                    return res;
                }
                catch (Exception e) {
                    Method method = this.clz.getMethod("getValueByIndex", Integer.TYPE, Integer.TYPE);
                    String res = (String)method.invoke(this.instance, index, 1);
                    return res;
                }
            }
            if (this.httpResult.size() > 0) {
                String result = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            return value1;
                        }
                        ++i;
                    }
                }
                return result;
            }
            return this.rs.getString(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getBooleanValueByIndex(int index) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getBooleanValueByIndex", Integer.TYPE);
                boolean res = (Boolean)method.invoke(this.instance, index);
                return res;
            }
            if (this.httpResult.size() > 0) {
                String result = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            return Boolean.parseBoolean(value1);
                        }
                        ++i;
                    }
                }
                return Boolean.parseBoolean(result);
            }
            return this.rs.getBoolean(index);
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getDateValueByIndex(int index) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getDateValueByIndex", Integer.TYPE);
                long res = (Long)method.invoke(this.instance, index);
                return res;
            }
            if (this.httpResult.size() > 0) {
                String result = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            return Long.parseLong(value1);
                        }
                        ++i;
                    }
                }
                return Long.parseLong(result);
            }
            Date date = this.rs.getDate(index);
            return date == null ? 0L : date.getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getDateTimeValueByIndex(int index) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("getDateTimeValueByIndex", Integer.TYPE);
                long res = (Long)method.invoke(this.instance, index);
                return res;
            }
            if (this.httpResult.size() > 0) {
                String result = null;
                for (String key : this.httpResult.keySet()) {
                    JSONArray value = this.httpResult.getJSONArray(key);
                    JSONObject item = value.getJSONObject(this.indexNum);
                    Iterator itemIterator = item.keySet().iterator();
                    int i = 1;
                    while (itemIterator.hasNext()) {
                        String key1 = (String)itemIterator.next();
                        String value1 = item.getString(key1);
                        if (i == index) {
                            return Long.parseLong(value1);
                        }
                        ++i;
                    }
                }
                return Long.parseLong(result);
            }
            Timestamp time = this.rs.getTimestamp(index);
            return time == null ? 0L : time.getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public byte[] getBlobValueByIndex(int index) {
        try {
            Blob blob = this.rs.getBlob(index);
            BufferedInputStream is = new BufferedInputStream(blob.getBinaryStream());
            byte[] bytes = new byte[(int)blob.length()];
            int len = bytes.length;
            int read = 0;
            for (int offset = 0; offset < len && (read = ((InputStream)is).read(bytes, offset, len - offset)) >= 0; offset += read) {
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean open(String sql, int fetchSize) {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("open", String.class, Integer.TYPE);
                boolean flag = (Boolean)method.invoke(this.instance, sql, fetchSize);
                return flag;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (this.httpResult.size() > 0) {
            return true;
        }
        try {
            this.ps = this.connection.prepareStatement(sql);
            this.ps.setFetchSize(fetchSize);
            this.rs = this.ps.executeQuery();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean close() {
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("close", new Class[0]);
                boolean flag = (Boolean)method.invoke(this.instance, new Object[0]);
                return flag;
            }
            this.rs.close();
            this.ps.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getFieldCount() {
        if (this.instance != null) {
            try {
                Method method = this.clz.getMethod("getFieldCount", new Class[0]);
                int res = (Integer)method.invoke(this.instance, new Object[0]);
                return res;
            }
            catch (Exception e) {
                return 0;
            }
        }
        if (this.httpResult.size() > 0) {
            int i = 0;
            for (String key : this.httpResult.keySet()) {
                JSONArray value = this.httpResult.getJSONArray(key);
                JSONObject item = value.getJSONObject(0);
                i = item.keySet().size();
            }
            return i;
        }
        try {
            ResultSetMetaData data = this.rs.getMetaData();
            return data.getColumnCount();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getConnURL(String connName) {
        try {
            JSONObject object = this.connObject.getJSONObject(connName);
            String url = object.getString("url");
            if (url.contains("sqlite")) {
                Class.forName("org.sqlite.JDBC");
            } else if (url.contains("postgresql")) {
                Class.forName("org.postgresql.Driver");
            } else if (url.contains("oracle")) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
            } else if (url.contains("mysql")) {
                Class.forName("com.mysql.cj.jdbc.Driver");
            } else if (url.contains("sqlserver")) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            } else if (url.contains("odbc")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if (url.contains("Excel")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if (url.contains("Access")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            } else if (url.contains("db2")) {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
            } else if (url.contains("informix")) {
                Class.forName("com.informix.jdbc.IfxDriver");
            } else if (url.contains("hive")) {
                Class.forName("org.apache.hive.jdbc.HiveDriver");
            } else if (url.contains("sap")) {
                Class.forName("com.sap.db.jdbc.Driver");
            } else if (url.contains("ignite")) {
                Class.forName("org.apache.ignite.IgniteJdbcDriver");
            }
            if (this.connObject == null || object == null) {
                return null;
            }
            return object.getString("url");
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean disConnect() {
        this.indexNum = -1;
        try {
            if (this.instance != null) {
                Method method = this.clz.getMethod("disConnect", new Class[0]);
                boolean flag = (Boolean)method.invoke(this.instance, new Object[0]);
                this.instance = null;
                return flag;
            }
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.ps != null) {
                this.rs.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getLastConnectTime() {
        return this.lastConnectTime;
    }

    public boolean isCacheObject() {
        return this.connection != null;
    }

    public static void main(String[] args) throws Exception {
        String url = "jdbc:mysql://localhost:3306/efrs?useUnicode=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai&useSSL=false";
        String userName = "root";
        String password = "123456";
        Connection connection = DriverManager.getConnection(url, userName, password);
        String sql = "select id , changeTime from test";
        PreparedStatement ps = connection.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            System.out.println(rs.getInt(1));
            System.out.println(rs.getString(2));
            Timestamp time = rs.getTimestamp(2);
            System.out.println(time.getTime());
        }
    }
}

