/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.forms.fields.CheckBoxFormFieldBuilder;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.properties.CheckBoxType;
import com.itextpdf.forms.form.element.CheckBox;
import com.itextpdf.forms.form.renderer.AbstractFormFieldRenderer;
import com.itextpdf.forms.form.renderer.checkboximpl.HtmlCheckBoxRenderingStrategy;
import com.itextpdf.forms.form.renderer.checkboximpl.ICheckBoxRenderingStrategy;
import com.itextpdf.forms.form.renderer.checkboximpl.PdfACheckBoxRenderingStrategy;
import com.itextpdf.forms.form.renderer.checkboximpl.PdfCheckBoxRenderingStrategy;
import com.itextpdf.forms.util.BorderStyleUtil;
import com.itextpdf.forms.util.FormFieldRendererUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfConformance;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.HorizontalAlignment;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.Map;

public class CheckBoxRenderer
extends AbstractFormFieldRenderer {
    public static final float DEFAULT_BORDER_WIDTH = 0.75f;
    private static final float DEFAULT_SIZE = 8.25f;

    public CheckBoxRenderer(CheckBox modelElement) {
        super(modelElement);
        this.setProperty(75, VerticalAlignment.MIDDLE);
    }

    public IRenderer getNextRenderer() {
        return new CheckBoxRenderer((CheckBox)this.modelElement);
    }

    public RenderingMode getRenderingMode() {
        RenderingMode renderingMode = (RenderingMode)this.getProperty(123);
        if (renderingMode != null) {
            return renderingMode;
        }
        return RenderingMode.DEFAULT_LAYOUT_MODE;
    }

    public CheckBoxType getCheckBoxType() {
        if (this.hasProperty(0x20000E)) {
            return (CheckBoxType)((Object)this.getProperty(0x20000E));
        }
        return CheckBoxType.CROSS;
    }

    public ICheckBoxRenderingStrategy createCheckBoxRenderStrategy() {
        boolean isConformantPdfDocument;
        PdfConformance conformance = (PdfConformance)this.getProperty(0x20000F);
        boolean bl = isConformantPdfDocument = conformance != null && conformance.isPdfAOrUa();
        ICheckBoxRenderingStrategy renderingStrategy = this.getRenderingMode() == RenderingMode.HTML_MODE ? new HtmlCheckBoxRenderingStrategy() : (this.getRenderingMode() == RenderingMode.DEFAULT_LAYOUT_MODE && isConformantPdfDocument ? new PdfACheckBoxRenderingStrategy() : new PdfCheckBoxRenderingStrategy());
        return renderingStrategy;
    }

    public void drawBackground(DrawContext drawContext) {
    }

    public void drawBorder(DrawContext drawContext) {
    }

    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        return rect;
    }

    public boolean isBoxChecked() {
        return Boolean.TRUE.equals(this.getProperty(0x200007));
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
    }

    protected Rectangle applyPaddings(Rectangle rect, UnitValue[] paddings, boolean reverse) {
        return rect;
    }

    @Override
    public IRenderer createFlatRenderer() {
        UnitValue heightUV = this.getPropertyAsUnitValue(27);
        UnitValue widthUV = this.getPropertyAsUnitValue(77);
        float height = 8.25f;
        if (heightUV != null && heightUV.isPointValue()) {
            height = heightUV.getValue();
        }
        float width = 8.25f;
        if (widthUV != null && widthUV.isPointValue()) {
            width = widthUV.getValue();
        }
        Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)((Paragraph)((Paragraph)((Paragraph)new Paragraph().setWidth(width)).setHeight(height)).setMargin(0.0f)).setVerticalAlignment(VerticalAlignment.MIDDLE)).setHorizontalAlignment(HorizontalAlignment.CENTER)).setTextAlignment(TextAlignment.CENTER);
        paragraph.setProperty(105, this.getProperty(105));
        this.modelElement.setProperty(123, this.getProperty(123));
        paragraph.setBorderTop((Border)this.getProperty(13));
        paragraph.setBorderRight((Border)this.getProperty(12));
        paragraph.setBorderBottom((Border)this.getProperty(10));
        paragraph.setBorderLeft((Border)this.getProperty(11));
        paragraph.setProperty(6, this.getProperty(6));
        if (this.getRenderingMode() == RenderingMode.HTML_MODE) {
            paragraph.setWidth(Math.max(width, height));
            paragraph.setHeight(Math.max(width, height));
        }
        return new FlatParagraphRenderer(paragraph);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        String name = this.getModelId();
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.flatRenderer.getOccupiedArea().getBBox().clone();
        Map<Integer, Object> properties = FormFieldRendererUtil.removeProperties(this.modelElement);
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        CheckBoxFormFieldBuilder builder = (CheckBoxFormFieldBuilder)((CheckBoxFormFieldBuilder)new CheckBoxFormFieldBuilder(doc, name).setWidgetRectangle(area)).setConformance((PdfConformance)this.getProperty(0x20000F));
        if (this.hasProperty(0x20000E)) {
            builder.setCheckType((CheckBoxType)((Object)this.getProperty(0x20000E)));
        }
        PdfButtonFormField checkBox = builder.createCheckBox();
        checkBox.disableFieldRegeneration();
        BorderStyleUtil.applyBorderProperty((IPropertyContainer)this, checkBox.getFirstFormAnnotation());
        Background background = (Background)this.modelElement.getProperty(6);
        if (background != null) {
            checkBox.getFirstFormAnnotation().setBackgroundColor(background.getColor());
        }
        checkBox.setValue("Yes");
        if (!this.isBoxChecked()) {
            checkBox.setValue("Off");
        }
        this.applyAccessibilityProperties(checkBox, doc);
        checkBox.getFirstFormAnnotation().setFormFieldElement((CheckBox)this.modelElement);
        checkBox.enableFieldRegeneration();
        PdfFormCreator.getAcroForm(doc, true).addField(checkBox, page);
        FormFieldRendererUtil.reapplyProperties(this.modelElement, properties);
    }

    @Override
    protected boolean isLayoutBasedOnFlatRenderer() {
        return false;
    }

    protected class FlatParagraphRenderer
    extends ParagraphRenderer {
        public FlatParagraphRenderer(Paragraph modelElement) {
            super(modelElement);
        }

        public void drawChildren(DrawContext drawContext) {
            Rectangle rectangle = this.getInnerAreaBBox().clone();
            PdfCanvas canvas = drawContext.getCanvas();
            boolean isTaggingEnabled = drawContext.isTaggingEnabled();
            if (isTaggingEnabled) {
                TagTreePointer tp = drawContext.getDocument().getTagStructureContext().getAutoTaggingPointer();
                canvas.openTag(tp.getTagReference());
            }
            CheckBoxRenderer.this.createCheckBoxRenderStrategy().drawCheckBoxContent(drawContext, CheckBoxRenderer.this, rectangle);
            if (isTaggingEnabled) {
                canvas.closeTag();
            }
        }
    }
}

