/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.commons.datastructures.NullableContainer;
import com.itextpdf.commons.utils.Base64;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.AbstractPdfFormField;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfFormAnnotation;
import com.itextpdf.forms.fields.PdfFormAnnotationUtil;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfFormFieldMergeUtil;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.forms.fields.properties.CheckBoxType;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.source.HighPrecisionOutputStream;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceCmyk;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.layout.properties.TextAlignment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfFormField
extends AbstractPdfFormField {
    public static final int FF_MULTILINE = PdfFormField.makeFieldFlag(13);
    public static final int FF_PASSWORD = PdfFormField.makeFieldFlag(14);
    public static final int FF_READ_ONLY = PdfFormField.makeFieldFlag(1);
    public static final int FF_REQUIRED = PdfFormField.makeFieldFlag(2);
    public static final int FF_NO_EXPORT = PdfFormField.makeFieldFlag(3);
    private static final Set<PdfName> FORM_FIELD_KEYS = new HashSet<PdfName>();
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfFormField.class);
    protected String text;
    protected ImageData img;
    protected PdfFormXObject form;
    protected NullableContainer<CheckBoxType> checkType = null;
    private String displayValue;
    private List<AbstractPdfFormField> childFields = new ArrayList<AbstractPdfFormField>();

    public PdfFormField(PdfDictionary pdfObject) {
        super(pdfObject);
        this.createKids(pdfObject);
    }

    private void createKids(PdfDictionary pdfObject) {
        PdfArray kidsArray = pdfObject.getAsArray(PdfName.Kids);
        if (kidsArray == null) {
            PdfFormAnnotation childField;
            PdfName subType = pdfObject.getAsName(PdfName.Subtype);
            if (PdfName.Widget.equals((Object)subType) && (childField = PdfFormAnnotation.makeFormAnnotation((PdfObject)pdfObject, this.getDocument())) != null) {
                this.setChildField(childField);
            }
        } else {
            for (PdfObject kid : kidsArray) {
                if (kid.isFlushed()) {
                    LOGGER.info("A form field was flushed. There's no way to create this field in the AcroForm dictionary.");
                    continue;
                }
                AbstractPdfFormField childField = PdfFormField.makeFormFieldOrAnnotation(kid, this.getDocument());
                if (childField != null) {
                    this.setChildField(childField);
                    continue;
                }
                LOGGER.warn(MessageFormatUtil.format((String)"Cannot create form field from a given PDF object: {0}", (Object[])new Object[]{pdfObject.getIndirectReference() == null ? pdfObject : pdfObject.getIndirectReference()}));
            }
        }
    }

    protected PdfFormField(PdfDocument pdfDocument) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(pdfDocument));
        PdfName formType = this.getFormType();
        if (formType != null) {
            this.put(PdfName.FT, (PdfObject)formType);
        }
    }

    protected PdfFormField(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(pdfDocument));
        widget.makeIndirect(pdfDocument);
        this.addKid(widget);
        if (this.getFormType() != null) {
            this.put(PdfName.FT, (PdfObject)this.getFormType());
        }
    }

    public static PdfFormField makeFormField(PdfObject pdfObject, PdfDocument document) {
        if (!pdfObject.isDictionary()) {
            return null;
        }
        PdfDictionary dictionary = (PdfDictionary)pdfObject;
        if (!PdfFormField.isFormField(dictionary)) {
            return null;
        }
        PdfName formType = dictionary.getAsName(PdfName.FT);
        PdfFormField field = PdfName.Tx.equals((Object)formType) ? PdfFormCreator.createTextFormField(dictionary) : (PdfName.Btn.equals((Object)formType) ? PdfFormCreator.createButtonFormField(dictionary) : (PdfName.Ch.equals((Object)formType) ? PdfFormCreator.createChoiceFormField(dictionary) : (PdfName.Sig.equals((Object)formType) ? PdfFormCreator.createSignatureFormField(dictionary) : PdfFormCreator.createFormField(dictionary))));
        field.makeIndirect(document);
        if (document != null) {
            field.pdfConformance = document.getConformance();
        }
        return field;
    }

    public static AbstractPdfFormField makeFormFieldOrAnnotation(PdfObject pdfObject, PdfDocument document) {
        AbstractPdfFormField formField = PdfFormField.makeFormField(pdfObject, document);
        if (formField == null) {
            formField = PdfFormAnnotation.makeFormAnnotation(pdfObject, document);
        }
        return formField;
    }

    public static int makeFieldFlag(int bitPosition) {
        return 1 << bitPosition - 1;
    }

    public static boolean isFormField(PdfDictionary dict) {
        for (PdfName formFieldKey : PdfFormField.getFormFieldKeys()) {
            if (!dict.containsKey(formFieldKey)) continue;
            return true;
        }
        return false;
    }

    public static Collection<PdfName> getFormFieldKeys() {
        return Collections.unmodifiableCollection(FORM_FIELD_KEYS);
    }

    public static PdfName getFormType(PdfDictionary fieldDict) {
        PdfName formType = fieldDict.getAsName(PdfName.FT);
        if (formType == null) {
            return PdfFormField.getTypeFromParent(fieldDict);
        }
        return formType;
    }

    public PdfName getFormType() {
        return PdfFormField.getFormType(this.getPdfObject());
    }

    public PdfFormField setValue(String value) {
        PdfName formType = this.getFormType();
        boolean autoGenerateAppearance = !PdfName.Btn.equals((Object)formType) || !this.getFieldFlag(PdfButtonFormField.FF_RADIO);
        return this.setValue(value, autoGenerateAppearance);
    }

    public PdfFormField setValue(String value, boolean generateAppearance) {
        if (this.parent == null) {
            this.setFieldValue(value, generateAppearance);
        } else {
            String fieldName = this.getPartialFieldName().toUnicodeString();
            for (PdfFormField field : this.parent.getChildFormFields()) {
                if (!fieldName.equals(field.getPartialFieldName().toUnicodeString())) continue;
                field.setFieldValue(value, generateAppearance);
            }
        }
        return this;
    }

    public PdfFormField setValue(String value, PdfFont font, float fontSize) {
        this.updateFontAndFontSize(font, fontSize);
        return this.setValue(value);
    }

    public PdfFormField setValue(String value, String displayValue) {
        if (value == null) {
            LOGGER.warn("Field value cannot be null.");
            return this;
        }
        if (displayValue == null || displayValue.equals(value)) {
            return this.setValue(value);
        }
        this.setValue(displayValue, true);
        this.setValue(value, false);
        this.displayValue = displayValue;
        return this;
    }

    public void removeChild(AbstractPdfFormField fieldName) {
        this.childFields.remove((Object)fieldName);
        PdfArray kids = this.getPdfObject().getAsArray(PdfName.Kids);
        if (kids != null) {
            kids.remove((PdfObject)fieldName.getPdfObject());
            if (kids.isEmpty()) {
                this.getPdfObject().remove(PdfName.Kids);
            }
        }
    }

    public void removeChildren() {
        this.childFields.clear();
        this.getPdfObject().remove(PdfName.Kids);
    }

    public PdfArray getKids() {
        return this.getPdfObject().getAsArray(PdfName.Kids);
    }

    public List<AbstractPdfFormField> getChildFields() {
        return Collections.unmodifiableList(this.childFields);
    }

    public List<PdfFormField> getChildFormFields() {
        ArrayList<PdfFormField> fields = new ArrayList<PdfFormField>();
        for (AbstractPdfFormField child : this.childFields) {
            if (!(child instanceof PdfFormField)) continue;
            fields.add((PdfFormField)child);
        }
        return fields;
    }

    public List<PdfFormField> getAllChildFormFields() {
        ArrayList<PdfFormField> allKids = new ArrayList<PdfFormField>();
        List<PdfFormField> kids = this.getChildFormFields();
        for (PdfFormField formField : kids) {
            allKids.add(formField);
            allKids.addAll(formField.getAllChildFormFields());
        }
        return allKids;
    }

    public List<AbstractPdfFormField> getAllChildFields() {
        List<AbstractPdfFormField> kids = this.getChildFields();
        ArrayList<AbstractPdfFormField> allKids = new ArrayList<AbstractPdfFormField>(kids);
        for (AbstractPdfFormField field : kids) {
            if (!(field instanceof PdfFormField)) continue;
            allKids.addAll(((PdfFormField)field).getAllChildFields());
        }
        return allKids;
    }

    public PdfFormField getChildField(String fieldName) {
        for (PdfFormField formField : this.getChildFormFields()) {
            PdfString partialFieldName = formField.getPartialFieldName();
            if (partialFieldName == null || !partialFieldName.toUnicodeString().equals(fieldName)) continue;
            return formField;
        }
        return null;
    }

    public PdfFormField addKid(AbstractPdfFormField kid) {
        return this.addKid(kid, true);
    }

    public PdfFormField addKid(AbstractPdfFormField kid, boolean throwExceptionOnError) {
        PdfFormAnnotationUtil.separateWidgetAndField(this);
        kid.setParent(this);
        PdfArray kids = this.getKids();
        if (kids == null) {
            kids = new PdfArray();
        }
        if (!this.mergeKidsIfKidWithSuchNameExists(kid, throwExceptionOnError)) {
            kids.add((PdfObject)kid.getPdfObject());
            this.childFields.add(kid);
        }
        this.put(PdfName.Kids, (PdfObject)kids);
        return this;
    }

    public PdfFormField addKid(PdfWidgetAnnotation kid) {
        kid.setParent((PdfObject)this.getPdfObject());
        PdfDictionary pdfObject = (PdfDictionary)kid.getPdfObject();
        pdfObject.makeIndirect(this.getDocument());
        PdfFormAnnotation field = PdfFormCreator.createFormAnnotation(pdfObject);
        return this.addKid(field);
    }

    public PdfFormField setFieldName(String name) {
        this.put(PdfName.T, (PdfObject)new PdfString(name));
        PdfFormField parent = this.getParentField();
        if (parent != null) {
            parent.mergeKidsIfKidWithSuchNameExists(this, true);
        }
        return this;
    }

    public PdfString getPartialFieldName() {
        PdfString partialName = this.getPdfObject().getAsString(PdfName.T);
        return partialName == null ? new PdfString("") : partialName;
    }

    public PdfFormField setAlternativeName(String name) {
        this.put(PdfName.TU, (PdfObject)new PdfString(name));
        return this;
    }

    public PdfString getAlternativeName() {
        return this.getPdfObject().getAsString(PdfName.TU);
    }

    public PdfFormField setMappingName(String name) {
        this.put(PdfName.TM, (PdfObject)new PdfString(name));
        return this;
    }

    public PdfString getMappingName() {
        return this.getPdfObject().getAsString(PdfName.TM);
    }

    public boolean getFieldFlag(int flag) {
        return (this.getFieldFlags() & flag) != 0;
    }

    public PdfFormField setFieldFlag(int flag) {
        return this.setFieldFlag(flag, true);
    }

    public PdfFormField setFieldFlag(int flag, boolean value) {
        int flags = this.getFieldFlags();
        flags = value ? (flags |= flag) : (flags &= ~flag);
        return this.setFieldFlags(flags);
    }

    public boolean isMultiline() {
        return this.getFieldFlag(FF_MULTILINE);
    }

    public boolean isPassword() {
        return this.getFieldFlag(FF_PASSWORD);
    }

    public PdfFormField setFieldFlags(int flags) {
        int oldFlags = this.getFieldFlags();
        this.put(PdfName.Ff, (PdfObject)new PdfNumber(flags));
        if (((oldFlags ^ flags) & PdfTextFormField.FF_COMB) != 0 && PdfName.Tx.equals((Object)this.getFormType()) && PdfFormCreator.createTextFormField(this.getPdfObject()).getMaxLen() != 0) {
            this.regenerateField();
        }
        return this;
    }

    public int getFieldFlags() {
        PdfNumber f = this.getPdfObject().getAsNumber(PdfName.Ff);
        if (f != null) {
            return f.intValue();
        }
        PdfFormField parent = this.getParentField();
        if (parent != null) {
            return parent.getFieldFlags();
        }
        return 0;
    }

    public PdfObject getValue() {
        PdfObject value = this.getPdfObject().get(PdfName.V);
        if ((this.getPdfObject().get(PdfName.T) == null || value == null) && this.getParentField() != null) {
            return this.getParentField().getValue();
        }
        return value;
    }

    public String getValueAsString() {
        PdfObject value = this.getValue();
        if (value == null) {
            return "";
        }
        if (value instanceof PdfStream) {
            return new String(((PdfStream)value).getBytes(), StandardCharsets.UTF_8);
        }
        if (value instanceof PdfName) {
            return ((PdfName)value).getValue();
        }
        if (value instanceof PdfString) {
            return ((PdfString)value).toUnicodeString();
        }
        return "";
    }

    public String getDisplayValue() {
        if (this.displayValue != null) {
            return this.displayValue;
        }
        if (this.text != null) {
            return this.text;
        }
        return this.getValueAsString();
    }

    public PdfFormField setDefaultValue(PdfObject value) {
        this.put(PdfName.DV, value);
        return this;
    }

    public PdfObject getDefaultValue() {
        return this.getPdfObject().get(PdfName.DV);
    }

    public PdfFormField setAdditionalAction(PdfName key, PdfAction action) {
        PdfAction.setAdditionalAction((PdfObjectWrapper)this, (PdfName)key, (PdfAction)action);
        return this;
    }

    public PdfDictionary getAdditionalAction() {
        return this.getPdfObject().getAsDictionary(PdfName.AA);
    }

    public PdfFormField setOptions(PdfArray options) {
        this.put(PdfName.Opt, (PdfObject)options);
        return this;
    }

    public PdfArray getOptions() {
        return this.getPdfObject().getAsArray(PdfName.Opt);
    }

    public List<PdfWidgetAnnotation> getWidgets() {
        ArrayList<PdfWidgetAnnotation> widgets = new ArrayList<PdfWidgetAnnotation>();
        for (AbstractPdfFormField child : this.childFields) {
            PdfDictionary kid = child.getPdfObject();
            PdfName subType = kid.getAsName(PdfName.Subtype);
            if (subType == null || !subType.equals((Object)PdfName.Widget)) continue;
            widgets.add((PdfWidgetAnnotation)PdfAnnotation.makeAnnotation((PdfObject)kid));
        }
        return widgets;
    }

    public List<PdfFormAnnotation> getChildFormAnnotations() {
        ArrayList<PdfFormAnnotation> annots = new ArrayList<PdfFormAnnotation>();
        for (AbstractPdfFormField child : this.childFields) {
            if (!(child instanceof PdfFormAnnotation)) continue;
            annots.add((PdfFormAnnotation)child);
        }
        return annots;
    }

    public PdfFormAnnotation getFirstFormAnnotation() {
        for (AbstractPdfFormField child : this.childFields) {
            if (!(child instanceof PdfFormAnnotation)) continue;
            return (PdfFormAnnotation)child;
        }
        return null;
    }

    @Override
    public PdfString getDefaultAppearance() {
        PdfDictionary parent;
        PdfString defaultAppearance = this.getPdfObject().getAsString(PdfName.DA);
        if (defaultAppearance == null && (parent = this.getParent()) != null && parent.containsKey(PdfName.FT)) {
            defaultAppearance = parent.getAsString(PdfName.DA);
        }
        if (defaultAppearance == null) {
            defaultAppearance = (PdfString)this.getAcroFormKey(PdfName.DA, 10);
        }
        return defaultAppearance;
    }

    public void updateDefaultAppearance() {
        if (this.hasDefaultAppearance()) {
            PdfName fontName;
            PdfDictionary fontResources;
            if (this.getFont() == null) {
                return;
            }
            PdfDictionary defaultResources = (PdfDictionary)this.getAcroFormObject(PdfName.DR, 3);
            if (defaultResources == null) {
                this.addAcroFormToCatalog();
                defaultResources = new PdfDictionary();
                this.putAcroFormObject(PdfName.DR, (PdfObject)defaultResources);
            }
            if ((fontResources = defaultResources.getAsDictionary(PdfName.Font)) == null) {
                fontResources = new PdfDictionary();
                defaultResources.put(PdfName.Font, (PdfObject)fontResources);
            }
            if ((fontName = this.getFontNameFromDR(fontResources, this.getFont().getPdfObject())) == null) {
                fontName = this.getUniqueFontNameForDR(fontResources);
                fontResources.put(fontName, this.getFont().getPdfObject());
                fontResources.setModified();
            }
            this.put(PdfName.DA, (PdfObject)PdfFormField.generateDefaultAppearance(fontName, this.getFontSize(), this.color));
            this.getDocument().addFont(this.getFont());
        } else {
            this.getPdfObject().remove(PdfName.DA);
            this.setModified();
        }
    }

    public TextAlignment getJustification() {
        Integer justification = this.getPdfObject().getAsInt(PdfName.Q);
        if (justification == null && this.getParent() != null) {
            justification = this.getParent().getAsInt(PdfName.Q);
        }
        return justification == null ? null : PdfFormField.numberToHorizontalAlignment(justification);
    }

    public PdfFormField setJustification(TextAlignment justification) {
        if (justification != null) {
            this.put(PdfName.Q, (PdfObject)new PdfNumber(justification.ordinal()));
            this.regenerateField();
        }
        return this;
    }

    public PdfString getDefaultStyle() {
        return this.getPdfObject().getAsString(PdfName.DS);
    }

    public PdfFormField setDefaultStyle(PdfString defaultStyleString) {
        this.put(PdfName.DS, (PdfObject)defaultStyleString);
        return this;
    }

    public PdfObject getRichText() {
        return this.getPdfObject().get(PdfName.RV);
    }

    public PdfFormField setRichText(PdfObject richText) {
        this.put(PdfName.RV, richText);
        return this;
    }

    public PdfFormField setCheckType(CheckBoxType checkType) {
        if (checkType == null) {
            checkType = CheckBoxType.CROSS;
        }
        this.checkType = new NullableContainer((Object)checkType);
        if (this.getPdfConformance() != null && this.getPdfConformance().isPdfAOrUa()) {
            return this;
        }
        try {
            this.font = PdfFontFactory.createFont((String)"ZapfDingbats");
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
        return this;
    }

    @Override
    public boolean regenerateField() {
        boolean result = true;
        if (this.isFieldRegenerationEnabled()) {
            this.updateDefaultAppearance();
        } else {
            result = false;
        }
        for (AbstractPdfFormField child : this.childFields) {
            if (child instanceof PdfFormAnnotation) {
                PdfFormAnnotation annotation = (PdfFormAnnotation)child;
                result &= annotation.regenerateWidget();
                continue;
            }
            child.regenerateField();
        }
        return result;
    }

    public PdfFormField setReadOnly(boolean readOnly) {
        return this.setFieldFlag(FF_READ_ONLY, readOnly);
    }

    public boolean isReadOnly() {
        return this.getFieldFlag(FF_READ_ONLY);
    }

    public PdfFormField setRequired(boolean required) {
        return this.setFieldFlag(FF_REQUIRED, required);
    }

    public boolean isRequired() {
        return this.getFieldFlag(FF_REQUIRED);
    }

    public PdfFormField setNoExport(boolean noExport) {
        return this.setFieldFlag(FF_NO_EXPORT, noExport);
    }

    public boolean isNoExport() {
        return this.getFieldFlag(FF_NO_EXPORT);
    }

    public boolean isInReadingMode() {
        return this.getDocument().getWriter() == null;
    }

    @Override
    public String[] getAppearanceStates() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        PdfString stringOpt = this.getPdfObject().getAsString(PdfName.Opt);
        if (stringOpt != null) {
            names.add(stringOpt.toUnicodeString());
        } else {
            PdfArray arrayOpt = this.getPdfObject().getAsArray(PdfName.Opt);
            if (arrayOpt != null) {
                for (PdfObject pdfObject : arrayOpt) {
                    PdfString valStr = null;
                    if (pdfObject.isArray()) {
                        valStr = ((PdfArray)pdfObject).getAsString(1);
                    } else if (pdfObject.isString()) {
                        valStr = (PdfString)pdfObject;
                    }
                    if (valStr == null) continue;
                    names.add(valStr.toUnicodeString());
                }
            }
        }
        for (AbstractPdfFormField child : this.childFields) {
            String[] states = child.getAppearanceStates();
            Collections.addAll(names, states);
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public void release() {
        for (AbstractPdfFormField child : this.childFields) {
            child.release();
        }
        this.childFields.clear();
        this.childFields = null;
        super.release();
    }

    @Override
    public AbstractPdfFormField setColor(Color color) {
        this.color = color;
        for (AbstractPdfFormField child : this.childFields) {
            child.setColorNoRegenerate(color);
        }
        this.regenerateField();
        return this;
    }

    @Override
    void updateFontAndFontSize(PdfFont font, float fontSize) {
        super.updateFontAndFontSize(font, fontSize);
        for (AbstractPdfFormField child : this.childFields) {
            child.updateFontAndFontSize(font, fontSize);
        }
    }

    static String optionsArrayToString(PdfArray options) {
        if (options == null || options.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (PdfObject obj : options) {
            if (obj.isString()) {
                sb.append(((PdfString)obj).toUnicodeString()).append('\n');
                continue;
            }
            if (obj.isArray()) {
                PdfObject element = ((PdfArray)obj).size() > 1 ? ((PdfArray)obj).get(1) : null;
                if (element == null || !element.isString()) continue;
                sb.append(((PdfString)element).toUnicodeString()).append('\n');
                continue;
            }
            sb.append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    AbstractPdfFormField setChildField(AbstractPdfFormField kid) {
        kid.setParent(this);
        this.childFields.add(kid);
        return kid;
    }

    void replaceKids(Collection<AbstractPdfFormField> kids) {
        PdfArray kidsValues = new PdfArray();
        PdfArray oldKids = this.getKids();
        if (oldKids != null) {
            for (PdfObject pdfObject : oldKids) {
                if (!pdfObject.isFlushed()) continue;
                kidsValues.add(pdfObject);
            }
        }
        this.childFields.clear();
        for (AbstractPdfFormField abstractPdfFormField : kids) {
            abstractPdfFormField.setParent(this);
            kidsValues.add((PdfObject)abstractPdfFormField.getPdfObject());
            this.childFields.add(abstractPdfFormField);
        }
        this.put(PdfName.Kids, (PdfObject)kidsValues);
    }

    private static PdfString generateDefaultAppearance(PdfName font, float fontSize, Color textColor) {
        assert (font != null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PdfOutputStream pdfStream = new PdfOutputStream((OutputStream)new HighPrecisionOutputStream((OutputStream)output));
        byte[] g = new byte[]{103};
        byte[] rg = new byte[]{114, 103};
        byte[] k = new byte[]{107};
        byte[] Tf = new byte[]{84, 102};
        ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)pdfStream.write((PdfObject)font).writeSpace()).writeFloat(fontSize)).writeSpace()).writeBytes(Tf);
        if (textColor != null) {
            if (textColor instanceof DeviceGray) {
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)pdfStream.writeSpace()).writeFloats(textColor.getColorValue())).writeSpace()).writeBytes(g);
            } else if (textColor instanceof DeviceRgb) {
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)pdfStream.writeSpace()).writeFloats(textColor.getColorValue())).writeSpace()).writeBytes(rg);
            } else if (textColor instanceof DeviceCmyk) {
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)pdfStream.writeSpace()).writeFloats(textColor.getColorValue())).writeSpace()).writeBytes(k);
            } else {
                LOGGER.error("Unsupported color in FormField's DA");
            }
        }
        return new PdfString(output.toByteArray());
    }

    private static PdfName getTypeFromParent(PdfDictionary field) {
        PdfDictionary parent = field.getAsDictionary(PdfName.Parent);
        PdfName formType = field.getAsName(PdfName.FT);
        if (parent != null && (formType = parent.getAsName(PdfName.FT)) == null) {
            formType = PdfFormField.getTypeFromParent(parent);
        }
        return formType;
    }

    private static TextAlignment numberToHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 1: {
                return TextAlignment.CENTER;
            }
            case 2: {
                return TextAlignment.RIGHT;
            }
        }
        return TextAlignment.LEFT;
    }

    private PdfFormField setFieldValue(String value, boolean generateAppearance) {
        if (value == null) {
            LOGGER.warn("Field value cannot be null.");
            return this;
        }
        this.displayValue = null;
        PdfName formType = this.getFormType();
        if (PdfName.Btn.equals((Object)formType)) {
            if (this.getFieldFlag(PdfButtonFormField.FF_PUSH_BUTTON)) {
                try {
                    this.img = ImageDataFactory.create((byte[])Base64.decode((String)value));
                }
                catch (Exception e) {
                    if (generateAppearance) {
                        for (PdfFormAnnotation annot : this.getChildFormAnnotations()) {
                            annot.setCaption(value, false);
                        }
                    }
                    this.text = value;
                }
            } else {
                PdfFormFieldMergeUtil.processDirtyAnnotations(this, true);
                this.put(PdfName.V, (PdfObject)new PdfName(value));
                if (generateAppearance && !this.getFieldFlag(PdfButtonFormField.FF_RADIO) && this.tryGenerateCheckboxAppearance(value)) {
                    return this;
                }
                for (PdfWidgetAnnotation widget : this.getWidgets()) {
                    List<String> states = Arrays.asList(PdfFormAnnotation.makeFormAnnotation(widget.getPdfObject(), this.getDocument()).getAppearanceStates());
                    if (states.contains(value)) {
                        widget.setAppearanceState(new PdfName(value));
                        continue;
                    }
                    widget.setAppearanceState(new PdfName("Off"));
                }
            }
        } else if (PdfName.Ch.equals((Object)formType)) {
            if (this instanceof PdfChoiceFormField) {
                ((PdfChoiceFormField)this).setListSelected(new String[]{value}, false);
            } else {
                PdfChoiceFormField choice = PdfFormCreator.createChoiceFormField(this.getPdfObject());
                choice.setListSelected(new String[]{value}, false);
            }
        } else {
            this.put(PdfName.V, (PdfObject)new PdfString(value, "UnicodeBig"));
        }
        if (generateAppearance) {
            this.regenerateField();
        }
        this.setModified();
        return this;
    }

    private boolean tryGenerateCheckboxAppearance(String value) {
        if (value == null || value.isEmpty() || "Off".equals(value)) {
            return false;
        }
        HashSet<String> allStates = new HashSet<String>();
        for (PdfFormAnnotation annotation : this.getChildFormAnnotations()) {
            allStates.addAll(Arrays.asList(annotation.getAppearanceStates()));
            if (allStates.size() <= 2) continue;
            return false;
        }
        allStates.remove("Off");
        if (allStates.isEmpty() || allStates.size() == 1 && !value.equals(allStates.toArray(new String[allStates.size()])[0])) {
            for (PdfFormAnnotation annotation : this.getChildFormAnnotations()) {
                annotation.setCheckBoxAppearanceOnStateName(value);
            }
            this.updateDefaultAppearance();
            return true;
        }
        return false;
    }

    private boolean mergeKidsIfKidWithSuchNameExists(AbstractPdfFormField newKid, boolean throwExceptionOnError) {
        if (this.childFields.contains((Object)newKid)) {
            return true;
        }
        if (this.isInReadingMode() || PdfFormAnnotationUtil.isPureWidget(newKid.getPdfObject())) {
            return false;
        }
        String newKidPartialName = PdfFormFieldMergeUtil.getPartialName(newKid);
        for (AbstractPdfFormField kid : this.childFields) {
            String kidPartialName = PdfFormFieldMergeUtil.getPartialName(kid);
            if (kidPartialName == null || !kidPartialName.equals(newKidPartialName)) continue;
            return PdfFormFieldMergeUtil.mergeTwoFieldsWithTheSameNames((PdfFormField)kid, (PdfFormField)newKid, throwExceptionOnError);
        }
        return false;
    }

    private boolean hasDefaultAppearance() {
        PdfName type = this.getFormType();
        return type == PdfName.Tx || type == PdfName.Ch || type == PdfName.Btn && (this.getFieldFlags() & PdfButtonFormField.FF_PUSH_BUTTON) != 0;
    }

    private PdfName getUniqueFontNameForDR(PdfDictionary fontResources) {
        PdfName uniqueName;
        int indexer = 1;
        Set fontNames = fontResources.keySet();
        while (fontNames.contains(uniqueName = new PdfName("F" + indexer++))) {
        }
        return uniqueName;
    }

    private PdfName getFontNameFromDR(PdfDictionary fontResources, PdfObject font) {
        for (Map.Entry drFont : fontResources.entrySet()) {
            if (drFont.getValue() != font) continue;
            return (PdfName)drFont.getKey();
        }
        return null;
    }

    private void putAcroFormObject(PdfName acroFormKey, PdfObject acroFormObject) {
        ((PdfDictionary)this.getDocument().getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm).put(acroFormKey, acroFormObject);
    }

    private void addAcroFormToCatalog() {
        if (((PdfDictionary)this.getDocument().getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm) == null) {
            PdfDictionary acroform = new PdfDictionary();
            acroform.makeIndirect(this.getDocument());
            acroform.put(PdfName.Fields, (PdfObject)new PdfArray());
            this.getDocument().getCatalog().put(PdfName.AcroForm, (PdfObject)acroform);
        }
    }

    private PdfObject getAcroFormKey(PdfName key, int type) {
        PdfDictionary acroFormDictionary;
        PdfObject acroFormKey = null;
        PdfDocument document = this.getDocument();
        if (document != null && (acroFormDictionary = ((PdfDictionary)document.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm)) != null) {
            acroFormKey = acroFormDictionary.get(key);
        }
        return acroFormKey != null && acroFormKey.getType() == type ? acroFormKey : null;
    }

    static {
        FORM_FIELD_KEYS.add(PdfName.FT);
        FORM_FIELD_KEYS.add(PdfName.Kids);
        FORM_FIELD_KEYS.add(PdfName.T);
        FORM_FIELD_KEYS.add(PdfName.TU);
        FORM_FIELD_KEYS.add(PdfName.TM);
        FORM_FIELD_KEYS.add(PdfName.Ff);
        FORM_FIELD_KEYS.add(PdfName.V);
        FORM_FIELD_KEYS.add(PdfName.DV);
        FORM_FIELD_KEYS.add(PdfName.DA);
        FORM_FIELD_KEYS.add(PdfName.Q);
        FORM_FIELD_KEYS.add(PdfName.DS);
        FORM_FIELD_KEYS.add(PdfName.RV);
        FORM_FIELD_KEYS.add(PdfName.Opt);
        FORM_FIELD_KEYS.add(PdfName.MaxLen);
        FORM_FIELD_KEYS.add(PdfName.TI);
        FORM_FIELD_KEYS.add(PdfName.I);
        FORM_FIELD_KEYS.add(PdfName.Lock);
        FORM_FIELD_KEYS.add(PdfName.SV);
    }
}

