/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class EFRadio {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = EFRadio.generateDefaultOption();
            JSONObject optionObj = JSONObject.parseObject((String)option);
            String clazzName = EFRadio.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("</head>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/semantic/semantic.min.js'></script>");
                sb.append("<link rel='stylesheet' href='" + jsResourceHttp + "/semantic/css/semantic.min.css'>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' class='ui form'  style='width:" + width + "px;height:" + height + "px;display:flex;justify-content:center;align-items:center;'>");
                sb.append(" <div class='inline fields'>       <div class=field>           <input type='radio' name='ef_check' class='position'>\n           <label>\u9009\u98791</label>\n       </div>       <div class=field>           <input type='radio' name='ef_check' class='position'>\n           <label>\u9009\u98792</label>\n       </div> </div>");
                sb.append("</div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + EFRadio.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                results.put("option", realDataJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("'labelColor':'#000000',");
        sb.append("'valueCell':'',");
        sb.append("'textCell':'',");
        sb.append("'fontSize':'14',");
        sb.append("'direction':'hori',");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        StringBuffer sb = new StringBuffer();
        JSONObject optionObj = JSONObject.parseObject((String)option);
        boolean flag = true;
        String valueCell = optionObj.getString("valueCell");
        String textCell = optionObj.getString("textCell");
        String[] values = valueCell.split(",");
        String[] texts = textCell.split(",");
        String labelColor = optionObj.getString("labelColor");
        String fontSize = optionObj.getString("fontSize");
        String direction = optionObj.getString("direction");
        path = path.replace(".html", ".plugin");
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        JSONArray cssArray = new JSONArray();
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsArray.add((Object)(jsResourcePath + "/semantic/semantic.min.js"));
        jsBuffer.append(jsArray.toString());
        cssArray.add((Object)(jsResourcePath + "/semantic/css/semantic.min.css"));
        cssBuffer.append(cssArray.toString());
        long time = new Random().nextLong();
        if (time < 0L) {
            time = 0L - time;
        }
        domBuffer.append("<div id='main_" + time + "' class='ui form' style='width:100%;height:100%;display:flex;justify-content:center;align-items:center;'>");
        domBuffer.append(" <div class='inline field' style='clear: both;margin: 0;width: 100%;height: 100%;display: flex;align-items: center;justify-content: center;'>");
        for (int i = 0; i < values.length; ++i) {
            if (i == 0) {
                domBuffer.append("       <div class='ui radio checkbox'  style='display:flex;flex:1;justify-content: center;align-items: center;'>           <input type='radio' value='" + values[i] + "' name='ef_check_" + time + "' class='position'>           <label>" + texts[i] + "</label>       </div>");
                continue;
            }
            domBuffer.append("       <div class='ui radio checkbox'  style='display:flex;flex:1;justify-content: center;align-items: center;'>           <input type='radio' value='" + values[i] + "' name='ef_check_" + time + "' class='position'>           <label>" + texts[i] + "</label>       </div>");
        }
        domBuffer.append("</div>");
        domBuffer.append("</div>");
        scriptBuffer.append("$('#main_" + time + "').find('.ui.radio.checkbox').checkbox();");
        scriptBuffer.append("$('#main_" + time + "').find('.ui').find('label').css('color', '" + labelColor + "');");
        scriptBuffer.append("$('#main_" + time + "').find('.ui').find('label').css('font-size', '" + fontSize + "px');");
        if (direction.equals("hori")) {
            scriptBuffer.append("$('#main_" + time + "').find('.field').css('flex-direction' , 'row');");
        } else {
            scriptBuffer.append("$('#main_" + time + "').find('.field').css('flex-direction' , 'column');");
        }
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String repaintRegions = reportInfoObj.getString("repaintRegions");
        JSONObject repaintRegionsObj = JSONObject.parseObject((String)repaintRegions);
        if (repaintRegionsObj != null) {
            scriptBuffer.append("$('input[name=\"ef_check_" + time + "\"]').on('change', function () { var value = $('input[name=\"ef_check_" + time + "\"]:checked').map(function(){        return $(this).val();    }).get().join(',');Link.Fn.regionLink(this,45,'" + reportInfoObj.getString("repaintRegions") + "','','',value)});");
        }
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr = null;
        JSONObject optionObj = JSONObject.parseObject((String)option);
        StringBuffer sb = new StringBuffer();
        String hori = optionObj.getString("hori");
        String horiF = hori.equals("left") ? "flex-start" : (hori.equals("right") ? "flex-end" : "center");
        String verti = optionObj.getString("verti");
        String vertiF = verti.equals("top") ? "flex-start" : (verti.equals("bottom") ? "flex-end" : "center");
        String text = optionObj.getString("text");
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/semantic/semantic.min.js'></script>");
        sb.append("<link rel='stylesheet' href='" + jsResourcePath + "/semantic/css/semantic.min.css'>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'>");
        sb.append("<div id='but' style='display:flex;justify-content:" + horiF + ";align-items:" + vertiF + ";width:" + width + "px;height:" + height + "px;border:1px solid " + optionObj.getString("borderColor") + ";background-color:" + optionObj.getString("backgroundColor") + ";font-size:" + optionObj.getString("fontSize") + "px;color:" + optionObj.getString("color") + ";font-family:" + optionObj.getString("fontFamily") + ";font-style:" + optionObj.getString("fontStyle") + ";font-weight:" + optionObj.getString("fontWeight") + ";'>");
        sb.append("</div>");
        sb.append("<script type='text/javascript'>");
        sb.append("$(document).ready(function(){");
        if (width != 0 && height != 0) {
            sb.append("$('#but').html('" + text + "');");
            sb.append("$('#main').css('width',$(window.frameElement).attr('ow'));");
            sb.append("$('#main').css('height',$(window.frameElement).attr('oh'));");
            sb.append("$('#but').css('width',$(window.frameElement).attr('ow'));");
            sb.append("$('#but').css('height',$(window.frameElement).attr('oh'));");
        }
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u5355\u9009\u6846\u63a7\u4ef6";
    }

    public static String getClassName() {
        return "EFRadio";
    }

    public static void main(String[] args) {
        System.out.println(EFRadio.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        return option;
    }
}

