/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class RichEditor {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = RichEditor.generateDefaultOption();
            JSONObject optionObj = JSONObject.parseObject((String)option);
            String clazzName = RichEditor.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
                return results;
            }
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            StringBuffer sb = new StringBuffer();
            sb.append("<!DOCTYPE html>");
            sb.append("<html lang='zh-cmn-Hans'>");
            sb.append("<head>");
            sb.append(" <meta charset='UTF-8'>");
            sb.append("        <meta http-equiv='pragma' content='no-cache'>");
            sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
            sb.append("        <meta http-equiv='expires' content='0'>");
            sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
            sb.append("        <meta name='format-detection' content='telephone=no'>");
            sb.append("        <meta name='format-detection' content='email=no'>");
            sb.append("        <meta name='format-detection' content='adress=no'>");
            sb.append(" <style>\n      html, body { padding: 0; margin: 0; overflow: hidden; height: 100% }\n      #container { width: 100%; height: 100%; }\n      #screen { width: 100%; height: 100%; }\n    </style>");
            sb.append("</head>");
            sb.append("<body>");
            sb.append(" <div id=\"container\">\n    <div id=\"screen\"></div>\n  </div>");
            sb.append("<script type='text/javascript' src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
            sb.append("<script type='text/javascript' src='" + jsResourceHttp + "/richEditor/tinymce.min.js'></script>");
            sb.append("<script type='text/javascript'>");
            sb.append(" $(document).ready(function() {\n        tinymce.init({\n          selector: '#screen',\n          language: 'zh_CN',\n          menubar: false,\n          branding: false,\n          plugins: \"print\",\n          statusbar:false,\n          toolbar: [ //\u6570\u7ec4\u5199\u6cd5\n            'undo redo | styleselect | bold italic | link image alignleft aligncenter alignright forecolor backcolor print word'\n          ],\n          setup(editor) {\n            // \u5f80editor\u5de5\u5177\u680f\u6dfb\u52a0\u6309\u94ae\u914d\u7f6e \uff08\u4ec5\u6dfb\u52a0\u914d\u7f6e\uff0c\u662f\u5426\u4f7f\u7528\u4e0d\u5728\u6b64\uff09\n            // \u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\u5de5\u5177\u540d\u79f0--imgs\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\u914d\u7f6e\u5c5e\u6027\n            editor.ui.registry.addButton('word', {\n              // text\uff1a\u5de5\u5177\u680f\u7684\u663e\u793a\u7684\u5185\u5bb9\n              text: '\u5bfc\u51fa',\n              // \u70b9\u51fb\u56fe\u6807\u6216\u6587\u5b57\u65f6\u7684\u4e8b\u4ef6\u56de\u8c03\n              onAction: () => {\n                 downLoad();\n              }\n            })\n          }\n        })\n      });\n");
            sb.append(" function downLoad(){\n        var content = tinymce.editors['screen'].getContent();\n        download(content, 'text.rtf', 'application/rtf');\n      }");
            sb.append("</script>");
            sb.append("</body>");
            sb.append("</html>");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
            if (result == 0) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                results.put("state", "failed");
            }
            if (!htmlFile.exists()) return results;
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionObj = JSONObject.parseObject((String)option);
            String content = optionObj.getString("content");
            String newContent = content.replaceAll("\\n", "");
            String finalContent = newContent.replaceAll("'", "\\\\'");
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + RichEditor.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = new JSONObject();
                optionJSON.put("content", (Object)newContent);
                optionJSON.put("showTool", (Object)optionObj.getBoolean("showTool"));
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
            Object var16_17 = null;
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{'fileName':'http://www.efreport.com','showScroll':'N'");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        path = path.replace(".html", ".plugin");
        StringBuffer sb = new StringBuffer();
        JSONObject optionObj = JSONObject.parseObject((String)option);
        String content = optionObj.getString("content");
        boolean showTool = optionObj.getBoolean("showTool");
        String newContent = content.replaceAll("\\n", "");
        String finalContent = newContent.replaceAll("'", "\\\\'");
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsonArray.add((Object)(jsResourcePath + "/richEditor/tinymce.min.js"));
        jsonArray.add((Object)(jsResourcePath + "/richEditor/fileDownLoad.js"));
        jsBuffer.append(jsonArray.toString());
        cssBuffer.append(new JSONArray().toString());
        long time = new Random().nextLong();
        if (time < 0L) {
            time = 0L - time;
        }
        domBuffer.append(" <div id='container_" + time + "' style='width:99%;height:99%;'>    <div id='screen_" + time + "' style='width:100%;height:100%;'></div>  </div>");
        scriptBuffer.append("let content = '" + finalContent + "';\n");
        if (showTool) {
            scriptBuffer.append("        tinymce.init({\n          selector: '#screen_" + time + "',\n          language: 'zh_CN',\n          menubar: false,\n          branding: false,\n          plugins: \"print\",\n          statusbar:false,\n          toolbar: [ //\u6570\u7ec4\u5199\u6cd5\n            'undo redo | styleselect | bold italic | link image alignleft aligncenter alignright forecolor backcolor print word'\n          ],\n          setup(editor) {\n            // \u5f80editor\u5de5\u5177\u680f\u6dfb\u52a0\u6309\u94ae\u914d\u7f6e \uff08\u4ec5\u6dfb\u52a0\u914d\u7f6e\uff0c\u662f\u5426\u4f7f\u7528\u4e0d\u5728\u6b64\uff09\n            // \u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\u5de5\u5177\u540d\u79f0--imgs\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\u914d\u7f6e\u5c5e\u6027\n            editor.ui.registry.addButton('word', {\n              // text\uff1a\u5de5\u5177\u680f\u7684\u663e\u793a\u7684\u5185\u5bb9\n              text: '\u5bfc\u51fa',\n              // \u70b9\u51fb\u56fe\u6807\u6216\u6587\u5b57\u65f6\u7684\u4e8b\u4ef6\u56de\u8c03\n              onAction: () => {\n               var content = tinymce.editors['screen_" + time + "'].getContent();\n               download(content, '\u6587\u6863.rtf', 'application/rtf');\n              }\n            })\n          }\n        })\n  setTimeout(function(){tinyMCE.editors['screen_" + time + "'].setContent(content)},1000);");
        } else {
            scriptBuffer.append("        tinymce.init({\n          selector: '#screen_" + time + "',\n          language: 'zh_CN',\n          menubar: false,\n          branding: false,\n          plugins: \"print\",\n          statusbar:false,\n          toolbar: false,\n          setup(editor) {\n            // \u5f80editor\u5de5\u5177\u680f\u6dfb\u52a0\u6309\u94ae\u914d\u7f6e \uff08\u4ec5\u6dfb\u52a0\u914d\u7f6e\uff0c\u662f\u5426\u4f7f\u7528\u4e0d\u5728\u6b64\uff09\n            // \u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\u5de5\u5177\u540d\u79f0--imgs\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\u914d\u7f6e\u5c5e\u6027\n            editor.ui.registry.addButton('word', {\n              // text\uff1a\u5de5\u5177\u680f\u7684\u663e\u793a\u7684\u5185\u5bb9\n              text: '\u5bfc\u51fa',\n              // \u70b9\u51fb\u56fe\u6807\u6216\u6587\u5b57\u65f6\u7684\u4e8b\u4ef6\u56de\u8c03\n              onAction: () => {\n               var content = tinymce.editors['screen_" + time + "'].getContent();\n               download(content, '\u6587\u6863.rtf', 'application/rtf');\n              }\n            })\n          }\n        })\n  setTimeout(function(){tinyMCE.editors['screen_" + time + "'].setContent(content)},1000);  ");
        }
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        StringBuffer sb = new StringBuffer();
        String resultStr = null;
        JSONObject optionObj = JSONObject.parseObject((String)option);
        String content = optionObj.getString("content");
        String newContent = content.replaceAll("\\n", "<br>");
        String finalContent = newContent.replaceAll("'", "\\\\'");
        boolean showTool = optionObj.getBoolean("showTool");
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append(" <style>\n      html, body { padding: 0; margin: 0; overflow: hidden; height: 100% }\n      #container { width: 99%; height: 99%; }\n      #screen { width: 100%; height: 100%; }\n      .tox-tinymce{border:none!important;}    </style>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append(" <div id=\"container\">\n    <div id=\"screen\"></div>\n  </div>");
        sb.append("<script type='text/javascript' src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script type='text/javascript' src='" + jsResourcePath + "/richEditor/tinymce.min.js'></script>");
        sb.append("<script type='text/javascript' src='" + jsResourcePath + "/richEditor/fileDownLoad.js'></script>");
        sb.append("<script type='text/javascript'>");
        sb.append("let content = '" + finalContent + "';");
        if (showTool) {
            sb.append(" $(document).ready(function() {\n        tinymce.init({\n          selector: '#screen',\n          language: 'zh_CN',\n          menubar: false,\n          branding: false,\n          plugins: \"print\",\n          statusbar:false,\n          toolbar: [ //\u6570\u7ec4\u5199\u6cd5\n            'undo redo | styleselect | bold italic | link image alignleft aligncenter alignright forecolor backcolor print word'\n          ],\n          setup(editor) {\n            // \u5f80editor\u5de5\u5177\u680f\u6dfb\u52a0\u6309\u94ae\u914d\u7f6e \uff08\u4ec5\u6dfb\u52a0\u914d\u7f6e\uff0c\u662f\u5426\u4f7f\u7528\u4e0d\u5728\u6b64\uff09\n            // \u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\u5de5\u5177\u540d\u79f0--imgs\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\u914d\u7f6e\u5c5e\u6027\n            editor.ui.registry.addButton('word', {\n              // text\uff1a\u5de5\u5177\u680f\u7684\u663e\u793a\u7684\u5185\u5bb9\n              text: '\u5bfc\u51fa',\n              // \u70b9\u51fb\u56fe\u6807\u6216\u6587\u5b57\u65f6\u7684\u4e8b\u4ef6\u56de\u8c03\n              onAction: () => {\n                 downLoad();\n              }\n            })\n          }\n        })\n  setTimeout(function(){tinyMCE.editors['screen'].setContent(content)},200);      });\n");
        } else {
            sb.append(" $(document).ready(function() {\n        tinymce.init({\n          selector: '#screen',\n          language: 'zh_CN',\n          menubar: false,\n          branding: false,\n          plugins: \"print\",\n          statusbar:false,\n          toolbar: false,\n          setup(editor) {\n            // \u5f80editor\u5de5\u5177\u680f\u6dfb\u52a0\u6309\u94ae\u914d\u7f6e \uff08\u4ec5\u6dfb\u52a0\u914d\u7f6e\uff0c\u662f\u5426\u4f7f\u7528\u4e0d\u5728\u6b64\uff09\n            // \u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\u5de5\u5177\u540d\u79f0--imgs\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\u914d\u7f6e\u5c5e\u6027\n            editor.ui.registry.addButton('word', {\n              // text\uff1a\u5de5\u5177\u680f\u7684\u663e\u793a\u7684\u5185\u5bb9\n              text: '\u5bfc\u51fa',\n              // \u70b9\u51fb\u56fe\u6807\u6216\u6587\u5b57\u65f6\u7684\u4e8b\u4ef6\u56de\u8c03\n              onAction: () => {\n                 downLoad();\n              }\n            })\n          }\n        })\n  setTimeout(function(){tinyMCE.editors['screen'].setContent(content)},200);      });\n");
        }
        sb.append(" function downLoad(){\n        var content = tinymce.editors['screen'].getContent();\n        download(content, 'text.rtf', 'application/rtf');\n      }");
        sb.append("</script>");
        sb.append("</body>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u5bcc\u6587\u672c\u7f16\u8f91\u5668";
    }

    public static String getClassName() {
        return "RichEditor";
    }

    public static void main(String[] args) {
        System.out.println(RichEditor.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        return option;
    }
}

