/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public class Radar {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = Radar.generateDefaultOption();
            String clazzName = Radar.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-5.4.2.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/china.js'></script>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("var myChart = echarts.init(document.getElementById('main'));");
                sb.append("var option = ");
                sb.append(option + ";");
                sb.append("myChart.setOption(option);");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + Radar.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                JSONArray legend;
                JSONObject legendObject;
                JSONArray yAxis;
                JSONObject yAxisObject;
                JSONArray xAxis;
                JSONObject xAxisObject;
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                optionJSON.put("categoryData", realDataJSON.get((Object)"categoryData"));
                optionJSON.put("seriesData", realDataJSON.get((Object)"seriesData"));
                optionJSON.put("valueData", realDataJSON.get((Object)"valueData"));
                optionJSON.put("labelFormatter", realDataJSON.get((Object)"labelFormatter"));
                if (optionJSON.containsKey((Object)"xAxis") && (xAxisObject = (xAxis = optionJSON.getJSONArray("xAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    xAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"yAxis") && (yAxisObject = (yAxis = optionJSON.getJSONArray("yAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    yAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"series")) {
                    JSONObject labelObject;
                    JSONObject seriesObject;
                    JSONArray seriesArray = optionJSON.getJSONArray("series");
                    if (seriesArray.size() > 0 && (seriesObject = seriesArray.getJSONObject(0)).containsKey((Object)"label") && (labelObject = seriesObject.getJSONObject("label")).containsKey((Object)"show")) {
                        boolean flag = labelObject.getBoolean("show");
                        optionJSON.put("labelShow", (Object)flag);
                    }
                    optionJSON.remove((Object)"series");
                }
                if (optionJSON.containsKey((Object)"legend") && (legendObject = (legend = optionJSON.getJSONArray("legend")).getJSONObject(0)).containsKey((Object)"data")) {
                    legendObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"animation")) {
                    optionJSON.remove((Object)"animation");
                    optionJSON.put("animation", (Object)true);
                }
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("    title: {");
        sb.append("        text: '\u57fa\u7840\u96f7\u8fbe\u56fe'");
        sb.append("    },");
        sb.append("animation:false,");
        sb.append("initTimes:0,");
        sb.append("    legend: {");
        sb.append("        data: ['\u9884\u7b97\u5206\u914d', '\u5b9e\u9645\u5f00\u9500'],type:'scroll'");
        sb.append("    },");
        sb.append("    radar: {");
        sb.append("        indicator: [");
        sb.append("        { name: '\u9500\u552e', max: 6500},");
        sb.append("        { name: '\u7ba1\u7406', max: 16000},");
        sb.append("        { name: '\u4fe1\u606f\u6280\u672f', max: 30000},");
        sb.append("        { name: '\u5ba2\u670d', max: 38000},");
        sb.append("        { name: '\u7814\u53d1', max: 52000},");
        sb.append("        { name: '\u5e02\u573a', max: 25000}");
        sb.append("        ],");
        sb.append("triggerEvent:true");
        sb.append("    },");
        sb.append("    series: [{");
        sb.append("    name: '\u9884\u7b97 vs \u5f00\u9500',");
        sb.append("            type: 'radar',");
        sb.append("            data : [");
        sb.append("    {");
        sb.append("        value : [4300, 10000, 28000, 35000, 50000, 19000],");
        sb.append("        name : '\u9884\u7b97\u5206\u914d'");
        sb.append("    },");
        sb.append("    {");
        sb.append("        value : [5000, 14000, 28000, 31000, 42000, 21000],");
        sb.append("        name : '\u5b9e\u9645\u5f00\u9500'");
        sb.append("    }");
        sb.append("    ]");
        sb.append("}]");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        Set keySet;
        JSONObject hyperLinkObj;
        path = path.replace(".html", ".plugin");
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        if (valueData.equals("")) {
            return 0;
        }
        String labelShow = optionObject.getString("labelShow");
        String labelSize = optionObject.getString("labelSize");
        String labelColor = optionObject.getString("labelColor");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray radarArray = optionObject.getJSONArray("radar");
        JSONObject radarObj = radarArray.getJSONObject(0);
        radarObj.remove((Object)"indicator");
        radarObj.put("triggerEvent", (Object)true);
        JSONArray indicatorArray = new JSONArray();
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
            JSONObject indicator = new JSONObject();
            indicator.put("name", (Object)categoryDatas[i]);
            indicatorArray.add((Object)indicator);
        }
        radarObj.put("indicator", (Object)indicatorArray);
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        JSONObject seriesObject = new JSONObject();
        seriesObject.put("type", (Object)"radar");
        String showLabel = optionObject.getString("showLabel");
        JSONArray dataArray = new JSONArray();
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("name", (Object)seriesDatas[i]);
            if (showLabel != null) {
                JSONObject labelObject = new JSONObject();
                if ("true".equals(showLabel)) {
                    labelObject.put("show", (Object)true);
                } else {
                    labelObject.put("show", (Object)false);
                }
                if (labelSize != null) {
                    labelObject.put("fontSize", (Object)labelSize);
                }
                if (labelColor != null) {
                    labelObject.put("color", (Object)labelColor);
                }
                labelObject.put("formatter", (Object)labelFormatter);
                dataObject.put("label", (Object)labelObject);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                seriesDataArray.add((Object)valueDatas[i + j * seriesDatas.length]);
            }
            dataObject.put("value", (Object)seriesDataArray);
            dataArray.add((Object)dataObject);
        }
        seriesObject.put("data", (Object)dataArray);
        seriesArray.add((Object)seriesObject);
        optionObject.put("series", (Object)seriesArray);
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        JSONArray cssArray = new JSONArray();
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsArray.add((Object)(jsResourcePath + "/echarts-5.4.2.min.js"));
        jsBuffer.append(jsArray.toString());
        cssBuffer.append(cssArray.toString());
        long time = new Random().nextLong();
        if (time < 0L) {
            time = 0L - time;
        }
        domBuffer.append("<div id='main_" + time + "' style='width:100%;height:100%;'></div>");
        scriptBuffer.append("var myChart_" + time + " = echarts.init(document.getElementById('main_" + time + "'));");
        scriptBuffer.append("var option_" + time + " = ");
        scriptBuffer.append(optionObject.toString());
        scriptBuffer.append(";");
        scriptBuffer.append("myChart_" + time + ".setOption(option_" + time + ");");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        String repaintRegions = reportInfoObj.getString("repaintRegions");
        JSONObject repaintRegionsObj = JSONObject.parseObject((String)repaintRegions);
        if (hyperLinkArray != null && repaintRegionsObj != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);");
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1');");
            scriptBuffer.append("});");
        } else if (repaintRegionsObj != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        } else if (hyperLinkArray != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);});");
        }
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        if (valueData.equals("")) {
            return 0;
        }
        String labelShow = optionObject.getString("labelShow");
        String labelSize = optionObject.getString("labelSize");
        String labelColor = optionObject.getString("labelColor");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray radarArray = optionObject.getJSONArray("radar");
        JSONObject radarObj = radarArray.getJSONObject(0);
        radarObj.remove((Object)"indicator");
        radarObj.put("triggerEvent", (Object)true);
        JSONArray indicatorArray = new JSONArray();
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
            JSONObject indicator = new JSONObject();
            indicator.put("name", (Object)categoryDatas[i]);
            indicatorArray.add((Object)indicator);
        }
        radarObj.put("indicator", (Object)indicatorArray);
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        JSONObject seriesObject = new JSONObject();
        seriesObject.put("type", (Object)"radar");
        String showLabel = optionObject.getString("showLabel");
        JSONArray dataArray = new JSONArray();
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("name", (Object)seriesDatas[i]);
            if (showLabel != null) {
                JSONObject labelObject = new JSONObject();
                if ("true".equals(showLabel)) {
                    labelObject.put("show", (Object)true);
                } else {
                    labelObject.put("show", (Object)false);
                }
                if (labelSize != null) {
                    labelObject.put("fontSize", (Object)labelSize);
                }
                if (labelColor != null) {
                    labelObject.put("color", (Object)labelColor);
                }
                labelObject.put("formatter", (Object)labelFormatter);
                dataObject.put("label", (Object)labelObject);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                seriesDataArray.add((Object)valueDatas[i + j * seriesDatas.length]);
            }
            dataObject.put("value", (Object)seriesDataArray);
            dataArray.add((Object)dataObject);
        }
        seriesObject.put("data", (Object)dataArray);
        seriesArray.add((Object)seriesObject);
        optionObject.put("series", (Object)seriesArray);
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(optionObject.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr = null;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        if (valueData.equals("")) {
            return "error";
        }
        String labelShow = optionObject.getString("labelShow");
        String labelSize = optionObject.getString("labelSize");
        String labelColor = optionObject.getString("labelColor");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray radarArray = optionObject.getJSONArray("radar");
        JSONObject radarObj = radarArray.getJSONObject(0);
        radarObj.remove((Object)"indicator");
        radarObj.put("triggerEvent", (Object)true);
        JSONArray indicatorArray = new JSONArray();
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
            JSONObject indicator = new JSONObject();
            indicator.put("name", (Object)categoryDatas[i]);
            indicatorArray.add((Object)indicator);
        }
        radarObj.put("indicator", (Object)indicatorArray);
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        JSONObject seriesObject = new JSONObject();
        seriesObject.put("type", (Object)"radar");
        String showLabel = optionObject.getString("showLabel");
        JSONArray dataArray = new JSONArray();
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("name", (Object)seriesDatas[i]);
            if (showLabel != null) {
                JSONObject labelObject = new JSONObject();
                if ("true".equals(showLabel)) {
                    labelObject.put("show", (Object)true);
                } else {
                    labelObject.put("show", (Object)false);
                }
                if (labelSize != null) {
                    labelObject.put("fontSize", (Object)labelSize);
                }
                if (labelColor != null) {
                    labelObject.put("color", (Object)labelColor);
                }
                labelObject.put("formatter", (Object)labelFormatter);
                dataObject.put("label", (Object)labelObject);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                seriesDataArray.add((Object)valueDatas[i + j * seriesDatas.length]);
            }
            dataObject.put("value", (Object)seriesDataArray);
            dataArray.add((Object)dataObject);
        }
        seriesObject.put("data", (Object)dataArray);
        seriesArray.add((Object)seriesObject);
        optionObject.put("series", (Object)seriesArray);
        optionObject.put("animation", (Object)false);
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/china.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(optionObject.toString());
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u96f7\u8fbe\u56fe";
    }

    public static String getClassName() {
        return "Radar";
    }

    public static void main(String[] args) {
        System.out.println(Radar.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        JSONObject defaultJson = JSONObject.parseObject((String)Radar.generateDefaultOption());
        String labelSize = optionJson.getString("labelSize");
        String labelColor = optionJson.getString("labelColor");
        JSONArray seriesDefaultObj = (JSONArray)defaultJson.get((Object)"series");
        if (optionJson.containsKey((Object)"showLabel")) {
            String flag = optionJson.getString("showLabel");
            for (int i = 0; i < seriesDefaultObj.size(); ++i) {
                JSONObject seriesObject = seriesDefaultObj.getJSONObject(i);
                JSONObject labelObject = new JSONObject();
                labelObject.put("show", (Object)(flag.equals("true") ? 1 : 0));
                if (labelSize != null) {
                    labelObject.put("fontSize", (Object)labelSize);
                }
                if (labelColor != null) {
                    labelObject.put("color", (Object)labelColor);
                }
                seriesObject.put("label", (Object)labelObject);
            }
        }
        optionJson.put("series", (Object)seriesDefaultObj);
        return optionJson.toString();
    }
}

