/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.grid.AutoValue;
import com.itextpdf.layout.properties.grid.BreadthValue;
import com.itextpdf.layout.properties.grid.FitContentValue;
import com.itextpdf.layout.properties.grid.FlexValue;
import com.itextpdf.layout.properties.grid.GridValue;
import com.itextpdf.layout.properties.grid.LengthValue;
import com.itextpdf.layout.properties.grid.MinMaxValue;
import com.itextpdf.layout.properties.grid.PercentValue;
import com.itextpdf.layout.properties.grid.TemplateValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.Grid;
import com.itextpdf.layout.renderer.GridCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class GridTrackSizer {
    private final Grid grid;
    private final List<Track> tracks;
    private final float gap;
    private final float availableSpace;
    private final Grid.GridOrder order;
    private final Set<Integer> percentValueIndexes = new HashSet<Integer>();

    GridTrackSizer(Grid grid, List<GridValue> values, float gap, float availableSpace, Grid.GridOrder order) {
        this.grid = grid;
        this.availableSpace = availableSpace;
        this.gap = gap;
        this.tracks = new ArrayList<Track>(values.size());
        for (GridValue value : values) {
            Track track = new Track();
            track.value = value;
            this.tracks.add(track);
            if (track.value.getType() != TemplateValue.ValueType.FLEX) continue;
            track.value = new MinMaxValue(AutoValue.VALUE, (FlexValue)track.value);
        }
        if (Float.compare(availableSpace, -1.0f) == 0) {
            for (int i = 0; i < this.tracks.size(); ++i) {
                Track track = this.tracks.get(i);
                if (track.value.getType() == TemplateValue.ValueType.PERCENT) {
                    this.percentValueIndexes.add(i);
                    track.value = AutoValue.VALUE;
                }
                if (track.value.getType() != TemplateValue.ValueType.FIT_CONTENT || ((FitContentValue)track.value).getLength().getType() != TemplateValue.ValueType.PERCENT) continue;
                track.value = AutoValue.VALUE;
            }
        }
        this.order = order;
    }

    TrackSizingResult sizeTracks() {
        this.initializeTrackSizes();
        this.resolveIntrinsicTrackSizes();
        this.maximizeTracks();
        this.expandFlexibleTracks();
        this.stretchAutoTracks();
        return new TrackSizingResult(this.tracks, this.gap, this.percentValueIndexes);
    }

    private void stretchAutoTracks() {
        ArrayList<Track> tracksToGrow = new ArrayList<Track>();
        for (Track track : this.tracks) {
            if (!track.hasAutoMax()) continue;
            tracksToGrow.add(track);
        }
        if (tracksToGrow.isEmpty()) {
            return;
        }
        float freeSpace = this.determineFreeSpace();
        if (Float.compare(freeSpace, -1.0f) == 0) {
            return;
        }
        this.distributeExtraSpaceToTracks(freeSpace, 0.0f, GridItemContributionType.FOR_FREE_SPACE, tracksToGrow, tracksToGrow, true);
        for (Track track : tracksToGrow) {
            track.baseSize += track.incurredIncrease;
            track.ensureGrowthLimitIsNotLessThanBaseSize();
        }
    }

    private void maximizeTracks() {
        float freeSpace = this.determineFreeSpace();
        if (Float.compare(freeSpace, 0.0f) == 0) {
            return;
        }
        ArrayList<Track> tracksToGrow = new ArrayList<Track>(this.tracks);
        this.distributeExtraSpaceToTracks(freeSpace, 0.0f, GridItemContributionType.FOR_FREE_SPACE, tracksToGrow, null, true);
        for (Track track : tracksToGrow) {
            track.baseSize += track.incurredIncrease;
            track.ensureGrowthLimitIsNotLessThanBaseSize();
        }
    }

    private void expandFlexibleTracks() {
        boolean thereIsFlexibleTrack = false;
        for (Track track : this.tracks) {
            if (!track.isFlexibleTrack()) continue;
            thereIsFlexibleTrack = true;
            break;
        }
        if (!thereIsFlexibleTrack) {
            return;
        }
        float freeSpace = this.determineFreeSpace();
        if (Float.compare(freeSpace, 0.0f) == 0) {
            return;
        }
        float frSize = 0.0f;
        if (Float.compare(freeSpace, -1.0f) != 0) {
            frSize = this.findFrSize(this.tracks, this.availableSpace);
        } else {
            for (GridCell cell : this.grid.getUniqueGridCells(this.order)) {
                ArrayList<Track> flexSpannedTracks = new ArrayList<Track>();
                List<Track> spannedTracks = this.getSpannedTracks(cell);
                for (Track track : spannedTracks) {
                    if (!track.isFlexibleTrack()) continue;
                    flexSpannedTracks.add(track);
                }
                if (flexSpannedTracks.isEmpty()) continue;
                float gridItemFrSize = this.findFrSize(spannedTracks, this.calculateMinMaxContribution(cell, false));
                frSize = Math.max(gridItemFrSize, frSize);
            }
            for (Track track : this.tracks) {
                if (!track.isFlexibleTrack()) continue;
                float trackFlexFactor = Math.max(track.getFlexFactor(), 1.0f);
                frSize = Math.max(track.baseSize / trackFlexFactor, frSize);
            }
        }
        for (Track track : this.tracks) {
            float frShare;
            if (!track.isFlexibleTrack() || !((frShare = frSize * track.getFlexFactor()) >= track.baseSize)) continue;
            track.baseSize = frShare;
            track.ensureGrowthLimitIsNotLessThanBaseSize();
        }
    }

    private List<Track> getSpannedTracks(GridCell cell) {
        ArrayList<Track> affectedTracks = new ArrayList<Track>();
        for (int i = cell.getStart(this.order); i < cell.getEnd(this.order); ++i) {
            affectedTracks.add(this.tracks.get(i));
        }
        return affectedTracks;
    }

    private float determineFreeSpace() {
        float freeSpace = this.availableSpace;
        if (Float.compare(freeSpace, -1.0f) != 0) {
            for (Track track : this.tracks) {
                freeSpace -= track.baseSize;
            }
            return Math.max(freeSpace -= (float)(this.tracks.size() - 1) * this.gap, 0.0f);
        }
        return -1.0f;
    }

    private float findFrSize(List<Track> affectedTracks, float leftoverSpace) {
        float frSize = 0.0f;
        boolean allFlexTracksSatisfied = false;
        boolean[] ignoreTracks = new boolean[affectedTracks.size()];
        while (!allFlexTracksSatisfied) {
            float currentLeftoverSpace = leftoverSpace;
            int totalTrackCount = 0;
            float flexFactorSum = 0.0f;
            for (int i = 0; i < affectedTracks.size(); ++i) {
                Track track = affectedTracks.get(i);
                ++totalTrackCount;
                if (track.isFlexibleTrack() && !ignoreTracks[i]) {
                    flexFactorSum += track.getFlexFactor();
                    continue;
                }
                currentLeftoverSpace -= track.baseSize;
            }
            flexFactorSum = flexFactorSum < 1.0f ? 1.0f : flexFactorSum;
            float hyphFrSize = (currentLeftoverSpace -= (float)(totalTrackCount - 1) * this.gap) / flexFactorSum;
            allFlexTracksSatisfied = true;
            for (int i = 0; i < affectedTracks.size(); ++i) {
                Track track = affectedTracks.get(i);
                if (!track.isFlexibleTrack() || ignoreTracks[i] || !(hyphFrSize * track.getFlexFactor() < track.baseSize)) continue;
                ignoreTracks[i] = true;
                allFlexTracksSatisfied = false;
            }
            if (!allFlexTracksSatisfied) continue;
            frSize = hyphFrSize;
        }
        return frSize;
    }

    private void resolveIntrinsicTrackSizes() {
        int maxSpanCell = 0;
        for (GridCell cell : this.grid.getUniqueGridCells(this.order)) {
            maxSpanCell = Math.max(maxSpanCell, cell.getGridSpan(this.order));
        }
        for (int span = 1; span <= maxSpanCell; ++span) {
            ArrayList<GridCell> group = new ArrayList<GridCell>();
            for (GridCell cell : this.grid.getUniqueGridCells(this.order)) {
                if (cell.getGridSpan(this.order) != span) continue;
                boolean flexTracksExist = false;
                List<Track> spannedTracks = this.getSpannedTracks(cell);
                for (Track track : spannedTracks) {
                    if (!track.isFlexibleTrack()) continue;
                    flexTracksExist = true;
                    break;
                }
                if (flexTracksExist) continue;
                group.add(cell);
            }
            this.increaseTrackSizesToAccommodateGridItems(group, false, GridItemContributionType.FOR_INTRINSIC_MINIMUMS);
            this.increaseTrackSizesToAccommodateGridItems(group, false, GridItemContributionType.FOR_CONTENT_BASED_MINIMUMS);
            this.increaseTrackSizesToAccommodateGridItems(group, false, GridItemContributionType.FOR_MAX_CONTENT_MINIMUMS);
            this.increaseTrackSizesToAccommodateGridItems(group, false, GridItemContributionType.FOR_INTRINSIC_MAXIMUMS);
            this.increaseTrackSizesToAccommodateGridItems(group, false, GridItemContributionType.FOR_MAX_CONTENT_MAXIMUMS);
        }
        ArrayList<GridCell> group = new ArrayList<GridCell>();
        for (GridCell cell : this.grid.getUniqueGridCells(this.order)) {
            ArrayList<Track> flexSpannedTracks = new ArrayList<Track>();
            List<Track> spannedTracks = this.getSpannedTracks(cell);
            for (Track track : spannedTracks) {
                if (!track.isFlexibleTrack()) continue;
                flexSpannedTracks.add(track);
            }
            if (flexSpannedTracks.isEmpty()) continue;
            group.add(cell);
        }
        if (!group.isEmpty()) {
            this.increaseTrackSizesToAccommodateGridItems(group, true, GridItemContributionType.FOR_INTRINSIC_MINIMUMS);
            this.increaseTrackSizesToAccommodateGridItems(group, true, GridItemContributionType.FOR_CONTENT_BASED_MINIMUMS);
            this.increaseTrackSizesToAccommodateGridItems(group, true, GridItemContributionType.FOR_MAX_CONTENT_MINIMUMS);
        }
        for (Track track : this.tracks) {
            if (Float.compare(track.growthLimit, -1.0f) != 0) continue;
            track.growthLimit = track.baseSize;
        }
    }

    private void increaseTrackSizesToAccommodateGridItems(List<GridCell> group, boolean isGroupSpanningFlexTrack, GridItemContributionType contributionType) {
        for (Track track : this.tracks) {
            track.plannedIncrease = -1.0f;
        }
        for (GridCell cell : group) {
            ArrayList<Track> tracksToGrow = new ArrayList<Track>();
            ArrayList<Track> tracksToGrowBeyondLimit = new ArrayList<Track>();
            float flexFactorSum = 0.0f;
            float spannedTrackSize = this.gap * (float)(cell.getGridSpan(this.order) - 1);
            for (Track track : this.getSpannedTracks(cell)) {
                spannedTrackSize += GridTrackSizer.affectedSizeForContribution(track, contributionType);
                if (isGroupSpanningFlexTrack && !track.isFlexibleTrack() || !GridTrackSizer.isContributionAppliedToTrack(track, contributionType)) continue;
                if (Float.compare(track.plannedIncrease, -1.0f) == 0) {
                    track.plannedIncrease = 0.0f;
                }
                if (isGroupSpanningFlexTrack) {
                    flexFactorSum += track.getFlexFactor();
                }
                tracksToGrow.add(track);
                if (!GridTrackSizer.shouldUsedSizeGrowBeyondLimit(track, contributionType)) continue;
                tracksToGrowBeyondLimit.add(track);
            }
            if (tracksToGrow.isEmpty()) continue;
            boolean minTypeContribution = contributionType == GridItemContributionType.FOR_INTRINSIC_MINIMUMS || contributionType == GridItemContributionType.FOR_CONTENT_BASED_MINIMUMS || contributionType == GridItemContributionType.FOR_INTRINSIC_MAXIMUMS;
            float extraSpace = this.calculateMinMaxContribution(cell, minTypeContribution);
            if (Float.compare(extraSpace = Math.max(extraSpace - spannedTrackSize, 0.0f), 0.0f) == 0) continue;
            if (!isGroupSpanningFlexTrack || Float.compare(flexFactorSum, 0.0f) == 0) {
                this.distributeExtraSpaceToTracks(extraSpace, 0.0f, contributionType, tracksToGrow, tracksToGrowBeyondLimit.isEmpty() ? tracksToGrow : tracksToGrowBeyondLimit, true);
            } else {
                this.distributeExtraSpaceToTracks(extraSpace, flexFactorSum, contributionType, tracksToGrow, null, false);
            }
            for (Track track : tracksToGrow) {
                track.plannedIncrease = Math.max(track.incurredIncrease, track.plannedIncrease);
            }
        }
        for (Track track : this.tracks) {
            GridTrackSizer.growAffectedSizeByPlannedIncrease(track, contributionType);
        }
    }

    private static void growAffectedSizeByPlannedIncrease(Track track, GridItemContributionType contributionType) {
        track.isInfinityGrowable = false;
        float plannedIncrease = track.plannedIncrease;
        if (Float.compare(plannedIncrease, -1.0f) == 0) {
            return;
        }
        switch (contributionType) {
            case FOR_INTRINSIC_MINIMUMS: 
            case FOR_CONTENT_BASED_MINIMUMS: 
            case FOR_MAX_CONTENT_MINIMUMS: {
                track.baseSize += plannedIncrease;
                track.ensureGrowthLimitIsNotLessThanBaseSize();
                return;
            }
            case FOR_INTRINSIC_MAXIMUMS: {
                track.isInfinityGrowable = Float.compare(track.growthLimit, -1.0f) == 0;
                track.growthLimit = track.definiteGrowthLimit() + plannedIncrease;
                return;
            }
            case FOR_MAX_CONTENT_MAXIMUMS: {
                track.growthLimit = track.definiteGrowthLimit() + plannedIncrease;
                return;
            }
        }
    }

    private void distributeExtraSpaceToTracks(float extraSpace, float flexFactorSum, GridItemContributionType contributionType, List<Track> tracksToGrow, List<Track> tracksToGrowBeyondLimits, boolean isEqualDistribution) {
        float shareRatioSum;
        if (Float.compare(extraSpace, -1.0f) == 0) {
            for (Track track : tracksToGrow) {
                track.incurredIncrease = this.growthPotentialForSet(track, contributionType, false);
            }
            return;
        }
        int growableTrackCount = 0;
        for (Track track : tracksToGrow) {
            track.incurredIncrease = 0.0f;
            if (Float.compare(this.growthPotentialForSet(track, contributionType, false), 0.0f) == 0) continue;
            ++growableTrackCount;
        }
        float f = shareRatioSum = isEqualDistribution ? (float)growableTrackCount : flexFactorSum;
        if ((growableTrackCount != 0 || GridTrackSizer.isDistributionForGrowthLimits(contributionType)) && Float.compare(flexFactorSum, 0.0f) == 0) {
            Collections.sort(tracksToGrow, new CompareTracksByGrowthPotential(this, contributionType));
        }
        for (Track track : tracksToGrow) {
            if (growableTrackCount == 0) break;
            ExtraSpaceShareFunctionParams changedParams = new ExtraSpaceShareFunctionParams(growableTrackCount, shareRatioSum, extraSpace);
            track.incurredIncrease = GridTrackSizer.extraSpaceShare(track, this.growthPotentialForSet(track, contributionType, false), isEqualDistribution, changedParams);
            growableTrackCount = changedParams.growableTrackCount;
            shareRatioSum = changedParams.shareRatioSum;
            extraSpace = changedParams.extraSpace;
        }
        if (tracksToGrowBeyondLimits != null && Float.compare(extraSpace, 0.0f) != 0) {
            for (Track track : tracksToGrowBeyondLimits) {
                float beyondLimitsGrowthPotential = GridTrackSizer.isDistributionForGrowthLimits(contributionType) ? this.growthPotentialForSet(track, contributionType, true) : -1.0f;
                if (Float.compare(beyondLimitsGrowthPotential, 0.0f) == 0) continue;
                ++growableTrackCount;
            }
            shareRatioSum = growableTrackCount;
            for (Track track : tracksToGrowBeyondLimits) {
                if (growableTrackCount == 0) break;
                float beyondLimitsGrowthPotential = GridTrackSizer.isDistributionForGrowthLimits(contributionType) ? this.growthPotentialForSet(track, contributionType, true) : -1.0f;
                ExtraSpaceShareFunctionParams changedParams = new ExtraSpaceShareFunctionParams(growableTrackCount, shareRatioSum, extraSpace);
                track.incurredIncrease = GridTrackSizer.extraSpaceShare(track, beyondLimitsGrowthPotential, isEqualDistribution, changedParams);
                growableTrackCount = changedParams.growableTrackCount;
                shareRatioSum = changedParams.shareRatioSum;
                extraSpace = changedParams.extraSpace;
            }
        }
    }

    private static float extraSpaceShare(Track track, float growthPotential, boolean isEqualDistribution, ExtraSpaceShareFunctionParams changedParams) {
        float extraSpaceShare;
        float trackShareRatio;
        if (Float.compare(growthPotential, 0.0f) == 0) {
            return 0.0f;
        }
        int trackCount = 1;
        float f = trackShareRatio = isEqualDistribution ? 1.0f : track.getFlexFactor();
        if (trackShareRatio > changedParams.shareRatioSum) {
            trackShareRatio = changedParams.shareRatioSum;
        }
        if (Float.compare(trackShareRatio, changedParams.shareRatioSum) == 0) {
            trackCount = changedParams.growableTrackCount;
            extraSpaceShare = changedParams.extraSpace;
        } else {
            extraSpaceShare = changedParams.extraSpace * trackShareRatio / changedParams.shareRatioSum;
        }
        if (Float.compare(growthPotential, -1.0f) != 0) {
            extraSpaceShare = Math.min(extraSpaceShare, growthPotential);
        }
        changedParams.growableTrackCount -= trackCount;
        changedParams.shareRatioSum -= trackShareRatio;
        changedParams.extraSpace -= extraSpaceShare;
        return extraSpaceShare;
    }

    private static boolean isDistributionForGrowthLimits(GridItemContributionType contributionType) {
        switch (contributionType) {
            case FOR_INTRINSIC_MINIMUMS: 
            case FOR_CONTENT_BASED_MINIMUMS: 
            case FOR_MAX_CONTENT_MINIMUMS: 
            case FOR_FREE_SPACE: {
                return false;
            }
            case FOR_INTRINSIC_MAXIMUMS: 
            case FOR_MAX_CONTENT_MAXIMUMS: {
                return true;
            }
        }
        return false;
    }

    private float growthPotentialForSet(Track track, GridItemContributionType contributionType, boolean ignoreInfinitelyGrowable) {
        switch (contributionType) {
            case FOR_INTRINSIC_MINIMUMS: 
            case FOR_CONTENT_BASED_MINIMUMS: 
            case FOR_MAX_CONTENT_MINIMUMS: {
                if (Float.compare(track.growthLimit, -1.0f) == 0) {
                    return -1.0f;
                }
                float increasedBaseSize = track.baseSize + track.incurredIncrease;
                return track.growthLimit - increasedBaseSize;
            }
            case FOR_INTRINSIC_MAXIMUMS: 
            case FOR_MAX_CONTENT_MAXIMUMS: {
                if (!ignoreInfinitelyGrowable && Float.compare(track.growthLimit, -1.0f) != 0 && !track.isInfinityGrowable) {
                    return 0.0f;
                }
                if (track.value.getType() == TemplateValue.ValueType.FIT_CONTENT) {
                    FitContentValue fitContentValue = (FitContentValue)track.value;
                    float growthPotential = fitContentValue.getMaxSizeForSpace(this.availableSpace) - track.definiteGrowthLimit() - track.incurredIncrease;
                    return Math.max(growthPotential, 0.0f);
                }
                return -1.0f;
            }
            case FOR_FREE_SPACE: {
                return track.growthLimit - track.baseSize;
            }
        }
        return 0.0f;
    }

    private static boolean shouldUsedSizeGrowBeyondLimit(Track track, GridItemContributionType contributionType) {
        GridValue maxTrack = track.value;
        if (track.value.getType() == TemplateValue.ValueType.MINMAX) {
            maxTrack = ((MinMaxValue)track.value).getMax();
        }
        switch (contributionType) {
            case FOR_INTRINSIC_MINIMUMS: 
            case FOR_CONTENT_BASED_MINIMUMS: {
                return maxTrack.getType() == TemplateValue.ValueType.MIN_CONTENT || maxTrack.getType() == TemplateValue.ValueType.MAX_CONTENT || maxTrack.getType() == TemplateValue.ValueType.AUTO || maxTrack.getType() == TemplateValue.ValueType.FIT_CONTENT;
            }
            case FOR_MAX_CONTENT_MINIMUMS: {
                return maxTrack.getType() == TemplateValue.ValueType.MAX_CONTENT || maxTrack.getType() == TemplateValue.ValueType.AUTO;
            }
            case FOR_INTRINSIC_MAXIMUMS: 
            case FOR_MAX_CONTENT_MAXIMUMS: 
            case FOR_FREE_SPACE: {
                return false;
            }
        }
        return false;
    }

    private static boolean isContributionAppliedToTrack(Track track, GridItemContributionType contributionType) {
        GridValue minTrack = track.value;
        GridValue maxTrack = track.value;
        if (track.value.getType() == TemplateValue.ValueType.MINMAX) {
            minTrack = ((MinMaxValue)track.value).getMin();
            maxTrack = ((MinMaxValue)track.value).getMax();
        }
        switch (contributionType) {
            case FOR_INTRINSIC_MINIMUMS: {
                return minTrack.getType() == TemplateValue.ValueType.MIN_CONTENT || minTrack.getType() == TemplateValue.ValueType.MAX_CONTENT || minTrack.getType() == TemplateValue.ValueType.AUTO || minTrack.getType() == TemplateValue.ValueType.FIT_CONTENT;
            }
            case FOR_CONTENT_BASED_MINIMUMS: {
                return minTrack.getType() == TemplateValue.ValueType.MIN_CONTENT || minTrack.getType() == TemplateValue.ValueType.MAX_CONTENT;
            }
            case FOR_MAX_CONTENT_MINIMUMS: {
                return minTrack.getType() == TemplateValue.ValueType.MAX_CONTENT;
            }
            case FOR_INTRINSIC_MAXIMUMS: {
                return maxTrack.getType() == TemplateValue.ValueType.MIN_CONTENT || maxTrack.getType() == TemplateValue.ValueType.MAX_CONTENT || maxTrack.getType() == TemplateValue.ValueType.AUTO || maxTrack.getType() == TemplateValue.ValueType.FIT_CONTENT;
            }
            case FOR_MAX_CONTENT_MAXIMUMS: {
                return maxTrack.getType() == TemplateValue.ValueType.MAX_CONTENT || maxTrack.getType() == TemplateValue.ValueType.AUTO || maxTrack.getType() == TemplateValue.ValueType.FIT_CONTENT;
            }
            case FOR_FREE_SPACE: {
                return true;
            }
        }
        return false;
    }

    private static float affectedSizeForContribution(Track track, GridItemContributionType contributionType) {
        switch (contributionType) {
            case FOR_INTRINSIC_MINIMUMS: 
            case FOR_CONTENT_BASED_MINIMUMS: 
            case FOR_MAX_CONTENT_MINIMUMS: {
                return track.baseSize;
            }
            case FOR_INTRINSIC_MAXIMUMS: 
            case FOR_MAX_CONTENT_MAXIMUMS: {
                return track.definiteGrowthLimit();
            }
        }
        return 0.0f;
    }

    private void initializeTrackSizes() {
        for (Track track : this.tracks) {
            GridValue minTrackSizingValue = track.value;
            GridValue maxTrackSizingValue = track.value;
            if (track.value.getType() == TemplateValue.ValueType.MINMAX) {
                minTrackSizingValue = ((MinMaxValue)track.value).getMin();
                maxTrackSizingValue = ((MinMaxValue)track.value).getMax();
            }
            track.baseSize = minTrackSizingValue.getType() == TemplateValue.ValueType.POINT || minTrackSizingValue.getType() == TemplateValue.ValueType.PERCENT ? (minTrackSizingValue.getType() == TemplateValue.ValueType.POINT ? ((LengthValue)minTrackSizingValue).getValue() : ((LengthValue)minTrackSizingValue).getValue() / 100.0f * this.availableSpace) : 0.0f;
            if (maxTrackSizingValue.getType() == TemplateValue.ValueType.POINT || maxTrackSizingValue.getType() == TemplateValue.ValueType.PERCENT) {
                if (maxTrackSizingValue.getType() == TemplateValue.ValueType.POINT) {
                    track.growthLimit = ((LengthValue)maxTrackSizingValue).getValue();
                    continue;
                }
                track.growthLimit = ((LengthValue)maxTrackSizingValue).getValue() / 100.0f * this.availableSpace;
                continue;
            }
            track.growthLimit = -1.0f;
        }
    }

    private float calculateMinMaxContribution(GridCell cell, boolean minTypeContribution) {
        if (Grid.GridOrder.COLUMN == this.order) {
            if (cell.getValue() instanceof AbstractRenderer) {
                AbstractRenderer abstractRenderer = (AbstractRenderer)cell.getValue();
                return minTypeContribution ? abstractRenderer.getMinMaxWidth().getMinWidth() : abstractRenderer.getMinMaxWidth().getMaxWidth();
            }
        } else {
            LayoutContext layoutContext = new LayoutContext(new LayoutArea(1, new Rectangle(cell.getLayoutArea().getWidth(), 1000000.0f)));
            LayoutResult inifiniteHeighLayoutResult = cell.getValue().layout(layoutContext);
            if (inifiniteHeighLayoutResult.getStatus() == 3 || inifiniteHeighLayoutResult.getStatus() == 2) {
                return 0.0f;
            }
            return inifiniteHeighLayoutResult.getOccupiedArea().getBBox().getHeight();
        }
        return 0.0f;
    }

    static class Track {
        float baseSize;
        float growthLimit;
        GridValue value;
        float plannedIncrease;
        float incurredIncrease;
        boolean isInfinityGrowable = false;

        Track() {
        }

        public float definiteGrowthLimit() {
            return Float.compare(this.growthLimit, -1.0f) == 0 ? this.baseSize : this.growthLimit;
        }

        public boolean isFlexibleTrack() {
            if (this.value.getType() == TemplateValue.ValueType.MINMAX) {
                return ((MinMaxValue)this.value).getMax().getType() == TemplateValue.ValueType.FLEX;
            }
            return false;
        }

        public boolean hasAutoMax() {
            if (this.value.getType() == TemplateValue.ValueType.MINMAX) {
                return ((MinMaxValue)this.value).getMax().getType() == TemplateValue.ValueType.AUTO;
            }
            return this.value.getType() == TemplateValue.ValueType.AUTO;
        }

        public float getFlexFactor() {
            if (this.value.getType() == TemplateValue.ValueType.MINMAX) {
                BreadthValue max = ((MinMaxValue)this.value).getMax();
                return max.getType() == TemplateValue.ValueType.FLEX ? ((FlexValue)max).getFlex() : 0.0f;
            }
            return 0.0f;
        }

        public void ensureGrowthLimitIsNotLessThanBaseSize() {
            if (Float.compare(this.growthLimit, -1.0f) != 0 && this.growthLimit < this.baseSize) {
                this.growthLimit = this.baseSize;
            }
        }
    }

    static class TrackSizingResult {
        private final List<Track> tracks;
        private final Set<Integer> percentValueIndexes;
        private final float gap;

        TrackSizingResult(List<Track> tracks, float gap, Set<Integer> percentValueIndexes) {
            this.tracks = tracks;
            this.percentValueIndexes = percentValueIndexes;
            this.gap = gap;
        }

        List<Float> getTrackSizes() {
            ArrayList<Float> result = new ArrayList<Float>(this.tracks.size());
            for (Track track : this.tracks) {
                result.add(Float.valueOf(track.baseSize));
            }
            return result;
        }

        List<Float> getTrackSizesAndExpandPercents(List<GridValue> template) {
            if (this.percentValueIndexes.isEmpty()) {
                return this.getTrackSizes();
            }
            float total = 0.0f;
            for (Track track : this.tracks) {
                total += track.baseSize;
            }
            total += (float)(this.tracks.size() - 1) * this.gap;
            ArrayList<Float> expandedTrackSizes = new ArrayList<Float>(this.tracks.size());
            for (int i = 0; i < this.tracks.size(); ++i) {
                if (this.percentValueIndexes.contains(i)) {
                    expandedTrackSizes.add(Float.valueOf(((PercentValue)template.get(i)).getValue() / 100.0f * total));
                    continue;
                }
                expandedTrackSizes.add(Float.valueOf(this.tracks.get((int)i).baseSize));
            }
            return expandedTrackSizes;
        }
    }

    private static enum GridItemContributionType {
        FOR_INTRINSIC_MINIMUMS,
        FOR_CONTENT_BASED_MINIMUMS,
        FOR_MAX_CONTENT_MINIMUMS,
        FOR_INTRINSIC_MAXIMUMS,
        FOR_MAX_CONTENT_MAXIMUMS,
        FOR_FREE_SPACE;

    }

    private static class ExtraSpaceShareFunctionParams {
        int growableTrackCount;
        float shareRatioSum;
        float extraSpace;

        public ExtraSpaceShareFunctionParams(int growableTrackCount, float shareRatioSum, float extraSpace) {
            this.growableTrackCount = growableTrackCount;
            this.shareRatioSum = shareRatioSum;
            this.extraSpace = extraSpace;
        }
    }

    private static final class CompareTracksByGrowthPotential
    implements Comparator<Track> {
        private final GridTrackSizer gridTrackSizer;
        private final GridItemContributionType contributionType;

        public CompareTracksByGrowthPotential(GridTrackSizer gridTrackSizer, GridItemContributionType contributionType) {
            this.gridTrackSizer = gridTrackSizer;
            this.contributionType = contributionType;
        }

        @Override
        public int compare(Track lhs, Track rhs) {
            float growthPotentialLhs = this.gridTrackSizer.growthPotentialForSet(lhs, this.contributionType, true);
            float growthPotentialRhs = this.gridTrackSizer.growthPotentialForSet(rhs, this.contributionType, true);
            if (Float.compare(growthPotentialLhs, -1.0f) == 0 || Float.compare(growthPotentialRhs, -1.0f) == 0) {
                return Float.compare(growthPotentialLhs, -1.0f) == 0 ? 1 : -1;
            }
            return Float.compare(growthPotentialLhs, growthPotentialRhs);
        }
    }
}

