/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.renderer.Grid;
import com.itextpdf.layout.renderer.IRenderer;

class GridCell {
    private final IRenderer value;
    private int columnStart;
    private int rowStart;
    private final int columnSpan;
    private final int rowSpan;
    private final Rectangle layoutArea = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
    private float[] rowSizes;

    GridCell(IRenderer value, int x, int y, int width, int height) {
        this.value = value;
        this.columnStart = x;
        this.rowStart = y;
        this.columnSpan = width;
        this.rowSpan = height;
    }

    int getColumnStart() {
        return this.columnStart;
    }

    int getColumnEnd() {
        return this.columnStart + this.columnSpan;
    }

    int getRowStart() {
        return this.rowStart;
    }

    int getRowEnd() {
        return this.rowStart + this.rowSpan;
    }

    int getStart(Grid.GridOrder order) {
        if (Grid.GridOrder.COLUMN == order) {
            return this.getColumnStart();
        }
        return this.getRowStart();
    }

    int getEnd(Grid.GridOrder order) {
        if (Grid.GridOrder.COLUMN == order) {
            return this.getColumnEnd();
        }
        return this.getRowEnd();
    }

    int getGridHeight() {
        return this.rowSpan;
    }

    int getGridWidth() {
        return this.columnSpan;
    }

    int getGridSpan(Grid.GridOrder order) {
        if (Grid.GridOrder.COLUMN == order) {
            return this.getGridWidth();
        }
        return this.getGridHeight();
    }

    IRenderer getValue() {
        return this.value;
    }

    Rectangle getLayoutArea() {
        return this.layoutArea;
    }

    void setPos(int y, int x) {
        this.rowStart = y;
        this.columnStart = x;
    }

    float[] getRowSizes() {
        return this.rowSizes;
    }

    void setRowSizes(float[] rowSizes) {
        this.rowSizes = rowSizes;
    }
}

