/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EFTabs {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = "{}";
            String clazzName = EFTabs.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append(" <meta http-equiv='pragma' content='no-cache'>");
                sb.append(" <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append(" <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<link rel='stylesheet' href='" + jsResourceHttp + "/layui/css/layui.css' media='all'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<style>");
                sb.append("        html, body {");
                sb.append("    width: 100%;");
                sb.append("    border: 0px;");
                sb.append("    margin: 0px;");
                sb.append("    padding: 0px;");
                sb.append("     height: 100%;");
                sb.append(" }");
                sb.append("</style>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;width:100%;height:100%;'>");
                sb.append("<div style='margin:0px;padding:0px;width:100%;height:100%;display:flex;justify-content: center; align-items: center;'>");
                sb.append("Tab\u9875\u63d2\u4ef6");
                sb.append("</div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + EFTabs.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", opJson.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("  elem: '#table'");
        sb.append("   ,height: 312");
        sb.append("   ,url: '/static/json/table/user.json'");
        sb.append("   ,page: true ");
        sb.append("   ,cols: [[ ");
        sb.append("    {field: 'id', title: 'ID', width:80, sort: true, fixed: 'left'}");
        sb.append("    ,{field: 'username', title: '\u7528\u6237\u540d', width:80}");
        sb.append("    ,{field: 'sex', title: '\u6027\u522b', width:80, sort: true}");
        sb.append("    ,{field: 'city', title: '\u57ce\u5e02', width:80}");
        sb.append("    ,{field: 'sign', title: '\u7b7e\u540d', width: 177}");
        sb.append("    ,{field: 'experience', title: '\u79ef\u5206', width: 80, sort: true}");
        sb.append("    ,{field: 'score', title: '\u8bc4\u5206', width: 80, sort: true}");
        sb.append("    ,{field: 'classify', title: '\u804c\u4e1a', width: 80}");
        sb.append("   ,{field: 'words', title: '\u5b57\u6570', width: 135, sort: true}");
        sb.append("   ]]");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        try {
            JSONObject obj;
            int i;
            String indicator;
            String arrow;
            String value;
            JSONObject param;
            int i2;
            String paramStr = "";
            JSONObject paramsObj = JSONObject.parseObject((String)reportInfo);
            JSONArray reportParams = paramsObj.getJSONArray("reportParams");
            JSONArray templateParams = new JSONArray();
            for (i2 = 0; i2 < reportParams.size(); ++i2) {
                param = reportParams.getJSONObject(i2);
                for (String key : param.keySet()) {
                    value = (String)param.get((Object)key);
                    if (key.startsWith("ef") || value.equals("")) continue;
                    templateParams.add((Object)param);
                }
            }
            for (i2 = 0; i2 < templateParams.size(); ++i2) {
                param = templateParams.getJSONObject(i2);
                for (String key : param.keySet()) {
                    value = (String)param.get((Object)key);
                    if (i2 == templateParams.size() - 1) {
                        paramStr = paramStr + key + "=" + value;
                        continue;
                    }
                    paramStr = paramStr + key + "=" + value + "&";
                }
            }
            StringBuffer sb = new StringBuffer();
            String base = jsResourcePath.substring(0, jsResourcePath.length() - 7);
            JSONObject tabOption = JSONObject.parseObject((String)option);
            String token = tabOption.getString("token");
            boolean isCarousel = tabOption.getBoolean("isCarousel");
            JSONArray columns = tabOption.getJSONArray("columns");
            String carouselTime = tabOption.getString("carouselTime");
            boolean isShowArrow = tabOption.getBoolean("isShowArrow");
            String chooseStyle = tabOption.getString("chooseStyle");
            if (isShowArrow) {
                arrow = "always";
                indicator = "inside";
            } else {
                arrow = "none";
                indicator = "none";
            }
            sb.append("<!DOCTYPE html>");
            sb.append("<html lang='zh-cmn-Hans'>");
            sb.append("<head>");
            sb.append(" <meta charset='UTF-8'>");
            sb.append("        <meta http-equiv='pragma' content='no-cache'>");
            sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
            sb.append("        <meta http-equiv='expires' content='0'>");
            sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
            sb.append("        <meta name='format-detection' content='telephone=no'>");
            sb.append("        <meta name='format-detection' content='email=no'>");
            sb.append("        <meta name='format-detection' content='adress=no'>");
            sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
            sb.append("<script src='" + jsResourcePath + "/layui/layui.js'></script>");
            sb.append("<link href='" + jsResourcePath + "/layui/css/layui.css' rel='stylesheet'>");
            sb.append("</head>");
            sb.append("<style>");
            sb.append("    html, body {");
            sb.append("    border: 0px;");
            sb.append("    margin: 0px;");
            sb.append("    padding: 0px;");
            sb.append("    width: 100%;");
            sb.append("    height: 100%;");
            sb.append(" }");
            if (chooseStyle != null) {
                sb.append(".hover{" + chooseStyle + "}");
            } else {
                sb.append(".hover{}");
            }
            sb.append("</style>");
            sb.append("<body style='margin:0px;padding:0px;'>");
            if (isCarousel) {
                String css;
                String name;
                String id;
                for (i = 0; i < columns.size(); ++i) {
                    obj = columns.getJSONObject(i);
                    id = obj.getString("id");
                    name = obj.getString("name");
                    css = obj.getString("css");
                    if (css.contains("@base")) {
                        css = css.replace("@base", base + "/pluginResource/upload");
                        css = css + ";background-size:100% 100%;";
                        css = css + "background-repeat:no-repeat;cursor:pointer;";
                    }
                    if (tabOption.containsKey((Object)"isShowTab")) {
                        boolean isShowTab = tabOption.getBoolean("isShowTab");
                        if (!isShowTab) continue;
                        if (i == 0) {
                            sb.append("<button id='but_" + id + "' class='buttonGroup hover' style=\"" + css + "\" onclick='change(" + id + "," + i + ")'>" + name + "</button>");
                            continue;
                        }
                        sb.append("<button id='but_" + id + "' class='buttonGroup' style=\"" + css + "\" onclick='change(" + id + "," + i + ")'>" + name + "</button>");
                        continue;
                    }
                    if (i == 0) {
                        sb.append("<button id='but_" + id + "' class='buttonGroup hover' style=\"" + css + "\" onclick='change(" + id + "," + i + ")'>" + name + "</button>");
                        continue;
                    }
                    sb.append("<button id='but_" + id + "' class='buttonGroup' style=\"" + css + "\" onclick='change(" + id + "," + i + ")'>" + name + "</button>");
                }
                sb.append("<div class=\"layui-carousel\" id=\"iframe-carousel\" lay-filter=\"carousel\">");
                sb.append("<div carousel-item>");
                for (i = 0; i < columns.size(); ++i) {
                    obj = columns.getJSONObject(i);
                    id = obj.getString("id");
                    name = obj.getString("name");
                    css = obj.getString("css");
                    if (css.contains("@base")) {
                        css = css.replace("@base", base + "/pluginResource/upload");
                        css = css + ";background-size:100% 100%;";
                        css = css + "background-repeat:no-repeat;cursor:pointer;";
                    }
                    String url = base + "/reportTab.html?id=" + id + "&token=" + token + "&params=" + paramStr;
                    url = paramStr.equals("") ? base + "/reportTab.html?id=" + id + "&token=" + token : base + "/reportTab.html?id=" + id + "&token=" + token + "&params=" + paramStr;
                    if (i == 0) {
                        sb.append("<div id='" + id + "'><iframe id='frame_" + id + "' src='" + url + "' style='width:100%;height:100%' frameborder='0' scrolling='no' ></iframe></div>");
                        continue;
                    }
                    sb.append("<div id='" + id + "' class='buttonGroup'><iframe id='frame_" + id + "' style='width:100%;height:100%;' frameborder='0' scrolling='no'  hidden='true'></iframe></div>");
                }
                sb.append("</div>");
                sb.append("</div>");
            } else {
                for (i = 0; i < columns.size(); ++i) {
                    obj = columns.getJSONObject(i);
                    String id = obj.getString("id");
                    String name = obj.getString("name");
                    String css = obj.getString("css");
                    if (css.contains("@base")) {
                        css = css.replace("@base", base + "/pluginResource/upload");
                        css = css + ";background-size:100% 100%;";
                        css = css + "background-repeat:no-repeat;cursor:pointer;";
                    }
                    if (tabOption.containsKey((Object)"isShowTab")) {
                        boolean isShowTab = tabOption.getBoolean("isShowTab");
                        if (isShowTab) {
                            if (i == 0) {
                                sb.append("<button id='but_" + id + "' class='buttonGroup hover' style=\"" + css + "\" onclick='change(" + id + "," + i + ")'>" + name + "</button>");
                            } else {
                                sb.append("<button id='but_" + id + "' class='buttonGroup' style=\"" + css + "\" onclick='change(" + id + "," + i + ")'>" + name + "</button>");
                            }
                        }
                    } else if (i == 0) {
                        sb.append("<button id='but_" + id + "' class='buttonGroup hover' style=\"" + css + "\" onclick='change(" + id + "," + i + ")'>" + name + "</button>");
                    } else {
                        sb.append("<button id='but_" + id + "' class='buttonGroup' style=\"" + css + "\" onclick='change(" + id + "," + i + ")'>" + name + "</button>");
                    }
                    String url = paramStr.equals("") ? base + "/reportTab.html?id=" + id + "&token=" + token : base + "/reportTab.html?id=" + id + "&token=" + token + "&params=" + paramStr;
                    if (i == 0) {
                        sb.append("<iframe id='frame_" + id + "' src='" + url + "' style='width:100%;height:100%' frameborder='0' scrolling='no'></iframe>");
                        continue;
                    }
                    sb.append("<iframe id='frame_" + id + "' style='width:100%;height:100%;' frameborder='0' scrolling='no' hidden='true'></iframe>");
                }
            }
            sb.append("</body>");
            sb.append("<script type='text/javascript'>\n");
            sb.append("var carItem;");
            sb.append("var isRefresh;");
            if (tabOption.containsKey((Object)"isRefresh")) {
                boolean isRefresh = tabOption.getBoolean("isRefresh");
                if (isRefresh) {
                    sb.append("isRefresh = true;");
                } else {
                    sb.append("isRefresh = false;");
                }
            } else {
                sb.append("isRefresh = false;");
            }
            sb.append("function change(id , index){\n                       $('.buttonGroup').removeClass('hover');$('#but_' + id).addClass('hover');                       let token='" + token + "';                       let base = '" + base + "';                       var fId='frame_' + id;                       $('body').find('iframe').hide();\n                       if($('#' + fId).attr('src') == undefined){                           $('#' + fId).attr('src',base + '/reportTab.html?id=' + id + '&token=' + token" + (paramStr.equals("") ? "" : "+'&params=" + paramStr + "'") + ");                       }else{                            if(isRefresh){$('#' + fId).attr('src',base + '/reportTab.html?id=' + id + '&token=' + token" + (paramStr.equals("") ? "" : "+'&params=" + paramStr + "'") + ");}                       }                       $('#' + fId).attr('hidden' , 'false').show();\n                       if(index != undefined && carItem != undefined){$('.layui-this').removeClass();$('#'+id).addClass('layui-this');}                    }");
            sb.append("$(document).ready(function(){");
            if (tabOption.containsKey((Object)"isCarousel") && tabOption.getBoolean("isCarousel").booleanValue()) {
                sb.append("layui.use('carousel', function(){\n        var carousel = layui.carousel;\n\n        // \u521d\u59cb\u5316\u8f6e\u64ad\n        carItem = carousel.render({\n            elem: '#iframe-carousel',\n            width: '100%',  // \u8bbe\u7f6e\u5bb9\u5668\u5bbd\u5ea6\n            height: '100%', // \u8bbe\u7f6e\u9ad8\u5ea6\n            arrow: '" + arrow + "', // \u663e\u793a\u5207\u6362\u7bad\u5934\n            indicator: '" + indicator + "', // \u663e\u793aindicator\n            interval: " + Integer.parseInt(carouselTime) + " // \u81ea\u52a8\u5207\u6362\u7684\u65f6\u95f4\u95f4\u9694\n        });\ncarousel.on('change(carousel)', function(obj){\n    let id = obj.item.attr('id');console.log(id); // \u8f93\u51fa\u5f53\u524d\u7684\u8f6e\u64ad\u56fe\u7d22\u5f15\n    change(id);    // \u53ef\u4ee5\u6839\u636e\u5f53\u524d\u7684 obj.index \u505a\u8fdb\u4e00\u6b65\u64cd\u4f5c\uff0c\u6bd4\u5982\u52a0\u8f7d\u4e0d\u540c\u7684\u6570\u636e\n  });    });");
            }
            sb.append("});\n");
            sb.append("</script>");
            sb.append("</html>");
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(sb.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr = null;
        StringBuffer sb = new StringBuffer();
        String base = jsResourcePath.substring(0, jsResourcePath.length() - 7);
        JSONObject tabOption = JSONObject.parseObject((String)option);
        String token = tabOption.getString("token");
        JSONArray columns = tabOption.getJSONArray("columns");
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/slick.min.js'></script>");
        sb.append("<link href='" + jsResourcePath + "/slick.css' rel='stylesheet'>");
        sb.append("<link href='" + jsResourcePath + "/slick.min.css' rel='stylesheet'>");
        sb.append("</head>");
        sb.append("<style>");
        sb.append("    html, body {");
        sb.append("    border: 0px;");
        sb.append("    margin: 0px;");
        sb.append("    padding: 0px;");
        sb.append("    height: 100%;");
        sb.append(" }");
        sb.append("</style>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div class=\"ui container\">");
        sb.append("<div class=\"ui slider\">");
        for (int i = 0; i < columns.size(); ++i) {
            JSONObject obj = columns.getJSONObject(i);
            String id = obj.getString("id");
            String name = obj.getString("name");
            String css = obj.getString("css");
            if (css.contains("@base")) {
                css = css.replace("@base", base + "/pluginResource/upload");
                css = css + ";background-size:100% 100%;";
                css = css + "background-repeat:no-repeat;cursor:pointer;";
            }
            sb.append("<button style=\"" + css + "\" onclick='change(" + id + ")'>" + name + "</button>");
            String url = base + "/reportTab.html?id=" + id + "&token=" + token;
            if (i == 0) {
                sb.append("<div><iframe id='frame_" + id + "' src='" + url + "' style='width:100%;height:100%' frameborder='0' scrolling='no'></iframe></div>");
                continue;
            }
            sb.append("<div><iframe id='frame_" + id + "' style='width:100%;height:100%;' frameborder='0' scrolling='no' hidden='true'></iframe></div>");
        }
        sb.append("</div>");
        sb.append("</div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("function change(id){\n                       let token='" + token + "';                       let base = '" + base + "';                      var fId='frame_' + id;                       $('body').find('iframe').hide();\n                       console.log($('#' + fId).attr('src'));if($('#' + fId).attr('src') == undefined){$('#' + fId).attr('src',base + '/reportTab.html?id=' + id + '&token=' + token)};$('#' + fId).attr('hidden' , 'false').show();\n                    }");
        sb.append("$(document).ready(function(){");
        sb.append("$('.ui.slider').slick({\n    dots: true,  // \u663e\u793a\u70b9\u5bfc\u822a\n    infinite: true,  // \u65e0\u9650\u5faa\u73af\n    speed: 500,  // \u8fc7\u6e21\u901f\u5ea6\n    slidesToShow: 1,  // \u6bcf\u6b21\u663e\u793a1\u5f20\u56fe\n    adaptiveHeight: true  // \u9ad8\u5ea6\u81ea\u9002\u5e94\n  });");
        sb.append("});\n");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        return 0;
    }

    public static String getPluginName() {
        return "Tab\u9875\u63d2\u4ef6";
    }

    public static String getClassName() {
        return "EFTabs";
    }

    public static void main(String[] args) {
    }

    public static String getMixedOption(String option) {
        return new JSONObject().toString();
    }
}

