/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class EFDateAndTime {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = EFDateAndTime.generateDefaultOption();
            String clazzName = EFDateAndTime.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
                return results;
            }
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            String style = "<style>\n        * {\n            padding: 0;\n            margin: 0;\n            box-sizing: border-box;\n        }\n \n        body {\n            background: #333;\n        }\n        .clock {\n            width: " + width + "px;\n            height: " + height + "px;\n            background: #000000;\n            margin: 0 auto;\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            flex-wrap:wrap;\n        }\n        #clockTime{\n            font-size: 100px;\n            font-weight: bold;\n            color: #f7c08a;\n        }\n        #clickDate{\n            font-size: 30px;\n            color: #ff2d51;\n        }\n    </style>\n\n";
            String script = "<script>\n \n        showDateTime();\n        //\u5f00\u542f\u4e00\u4e2a\u5b9a\u65f6\u5668\uff0c\u8ba9\u7f51\u9875\u4e0a\u7684\u65f6\u95f4\u80fd\u81ea\u52a8\u66f4\u65b0\n        var timer = setInterval(showDateTime,1000);\n        //\u641e\u8d77\n        function showDateTime() {\n            var date = new Date();            //\u83b7\u53d6\u5f53\u524d\u65e5\u671f\n            var years = date.getFullYear();\n            var months = date.getMonth()\n            var days = date.getDate();\n \n            // \u83b7\u53d6\u5f53\u524d\u65f6\u95f4\n            var hour = date.getHours();\n            var minute = date.getMinutes();\n            var second = date.getSeconds();\n \n            //\u8bbe\u5b9a\u4e00\u4e2a\u5b57\u7b26\u4e32\n            var showTime = '';\n            //\u628a\u65f6\u95f4\u6309\u7279\u5b9a\u683c\u5f0f\u663e\u793a\n            showTime = hour + \":\" + minute + \":\" + second;\n            showDate = years + \"\u5e74\" + (months+1) + \"\u6708\" + days + \"\u65e5\"\n           //\u5c06\u65f6\u95f4\u663e\u793a\u5230\u9875\u9762\n            document.getElementById(\"clockTime\").innerHTML=showTime;\n            document.getElementById(\"clickDate\").innerHTML = showDate\n        }\n \n    </script>\n";
            String sb = "<!DOCTYPE html><html lang='zh'><head><meta charset='UTF-8'><meta http-equiv='X-UA-Compatible' content='IE=edge,chrome=1'> <meta name='viewport' content='width=device-width, initial-scale=1.0'>" + style + "</head><body><div class='clock'><div id='clockTime'></div><div id='clickDate'></div></div><script src='" + jsResourceHttp + "/jquery-1.11.3.min.js' type='text/javascript'></script>" + script + "</body></html>";
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
            if (result == 0) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                results.put("state", "failed");
            }
            if (!htmlFile.exists()) return results;
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + EFDateAndTime.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                optionJSON.put("bg", realDataJSON.get((Object)"bg"));
                optionJSON.put("fontColor", realDataJSON.get((Object)"fontColor"));
                optionJSON.put("fontSize", realDataJSON.get((Object)"fontSize"));
                optionJSON.put("fontColor1", realDataJSON.get((Object)"fontColor1"));
                optionJSON.put("fontSize1", realDataJSON.get((Object)"fontSize1"));
                optionJSON.put("oneLine", realDataJSON.get((Object)"oneLine"));
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("'bg':'#cccccc00',");
        sb.append("'fontColor':'#f7c08a',");
        sb.append("'fontSize':28,");
        sb.append("'fontColor1':'#ff2d51',");
        sb.append("'fontSize1':30");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        path = path.replace(".html", ".plugin");
        JSONObject realDataJson = JSON.parseObject((String)option);
        String bg = realDataJson.getString("bg");
        String fontColor = realDataJson.getString("fontColor");
        String fontSize = realDataJson.getString("fontSize");
        String fontColor1 = realDataJson.getString("fontColor1");
        String fontSize1 = realDataJson.getString("fontSize1");
        String oneLine = realDataJson.getString("oneLine");
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsBuffer.append(jsArray.toString());
        cssBuffer.append(new JSONArray().toString());
        long pluginTime = new Random().nextLong();
        if (pluginTime < 0L) {
            pluginTime = 0L - pluginTime;
        }
        scriptBuffer.append("timer = setInterval(function(){            var date = new Date();            var years = date.getFullYear();            var months = date.getMonth();            var days = date.getDate();            var hour = date.getHours();            var minute = date.getMinutes();            var second = date.getSeconds();            var showTime = '';            showTime = hour + ':' + (minute<10?('0'+minute):minute) + ':' + (second<10?('0'+second):second);            showDate = years + '\u5e74' + (months+1) + '\u6708' + days + '\u65e5';            $('#clockTime_" + pluginTime + "').text(showTime);            $('#clockDate_" + pluginTime + "').text(showDate);},1000);");
        if (oneLine.equals("0")) {
            domBuffer.append("<div class='clock' style='width:100%;height:100%;background:" + bg + ";margin:0 auto;'><div id='clockTime_" + pluginTime + "' style='display: block;height:" + height / 2 + "px;display: flex;line-height:1;align-items:flex-end;justify-content: center;color:" + fontColor + ";font-size:" + fontSize + "px;'></div><div id='clockDate_" + pluginTime + "' style='display: block;height:" + height / 2 + "px;display: flex;line-height:1;align-items:flex-start;justify-content: center;color:" + fontColor1 + ";font-size:" + fontSize1 + "px;'></div></div>");
        } else {
            domBuffer.append("<div class='clock' style='display:flex;width:100%;height:100%;background:" + bg + ";margin:0 auto;'><div id='clockDate_" + pluginTime + "' style='width:60%;height:" + height + "px;display: flex;line-height:1;align-items:center;justify-content: flex-end;padding-right:10px;color:" + fontColor + ";font-size:" + fontSize + "px;'></div><div id='clockTime_" + pluginTime + "' style='width:40%;height:" + height + "px;display: flex;line-height:1;align-items:center;justify-content: flex-start;color:" + fontColor1 + ";font-size:" + fontSize1 + "px;'></div></div>");
        }
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        String resultStr = null;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String parentData = (String)optionObject.get((Object)"parentData");
        String childData = (String)optionObject.get((Object)"childData");
        String valueData = (String)optionObject.get((Object)"valueData");
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> parentList = new ArrayList<String>();
        String[] parentStrs = parentData.split(",");
        for (int i = 0; i < parentStrs.length; ++i) {
            if (!names.contains(parentStrs[i])) {
                names.add(parentStrs[i]);
            }
            parentList.add(parentStrs[i]);
        }
        ArrayList<String> childList = new ArrayList<String>();
        String[] childStrs = childData.split(",");
        for (int i = 0; i < childStrs.length; ++i) {
            if (!names.contains(childStrs[i])) {
                names.add(childStrs[i]);
            }
            childList.add(childStrs[i]);
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] valueStrs = valueData.split(",");
        for (int i = 0; i < valueStrs.length; ++i) {
            valueList.add(valueStrs[i]);
        }
        JSONArray nameArray = new JSONArray();
        for (int i = 0; i < names.size(); ++i) {
            JSONObject nameObj = new JSONObject();
            nameObj.put("name", names.get(i));
            nameArray.add((Object)nameObj);
        }
        JSONArray linksArray = new JSONArray();
        for (int i = 0; i < parentList.size(); ++i) {
            JSONObject object = new JSONObject();
            object.put("source", parentList.get(i));
            object.put("target", childList.get(i));
            object.put("value", (Object)Double.parseDouble((String)valueList.get(i)));
            linksArray.add((Object)object);
        }
        JSONArray seriesArr = optionObject.getJSONArray("series");
        JSONObject seriesObj = seriesArr.getJSONObject(0);
        seriesObj.put("data", (Object)nameArray);
        seriesObj.put("links", (Object)linksArray);
        optionObject.put("animation", (Object)false);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-4.1.0.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-wordcloud.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append(" function setColor(){");
        sb.append("               return 'rgb(' + [");
        sb.append("                Math.round(Math.random() * 250),");
        sb.append("                        Math.round(Math.random() * 250),");
        sb.append("                        Math.round(Math.random() * 250)");
        sb.append("                ].join(',') + ')';");
        sb.append("            };");
        sb.append("var option = ");
        sb.append(optionObject.toString() + ";");
        sb.append("myChart.setOption(option);");
        sb.append("option.series[0].textStyle.normal.color = setColor;");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                // empty if block
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u65f6\u95f4\u65e5\u671f\u63a7\u4ef6";
    }

    public static String getClassName() {
        return "EFDateAndTime";
    }

    public static void main(String[] args) {
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        return optionJson.toString();
    }
}

