//初始化单元格属性
function initCellProp() {
    let text = canvasEvent.Cell.getSelCellText(); //获取当前单元格文本
    $('#editArea').val(text); //设置编辑框值

    //边框图片恢复原始状态
    $('#border').attr("src", "images/svg/border.svg");
    $('img[name="borders"]').removeClass('choose');

    initCell();
    initStyle();

    var dict = {};
    //控件信息初始化
    let controlInfo = canvasEvent.Cell.getControlInfo();
    if (controlInfo != '') { //存在控件信息
        let ctinfo = JSON.parse(controlInfo);
        let ctype = ctinfo.ControlType;
        $("#controlName_" + ctype).val(ctinfo.ControlName); //控件名
        $("#allowNull_" + ctype).prop('checked', ctinfo.AllowNull); //是否允许为空
        $("#affectRow_" + ctype).prop('checked', ctinfo.AffectRow); //影响行数
        $("#defaultValue_" + ctype).val(ctinfo.DefaultValue); //默认值
        $("#tip_" + ctype).val(ctinfo.Hint); //提示
        $("#expr_" + ctype).prev().val(ctinfo.ControlShowExpr); //公式
        //var controlTypeText = $('option[value=' + ctinfo.ControlType + ']', $("#ef_control")).text();
        //manualChange($("#ef_control") , ctinfo.ControlType ,controlTypeText);
        $("#ef_control").dropdown('set selected' , ctype);
        $('div[id^="controlInfo"]').hide(); //隐藏其他属性内容
        dict = {};//数据字典还原，其他的不管
        $('#controlInfo' + ctype).show();
        //根据控件类型初始化控件属性
        if (10 == ctype || 2 == ctype || 3 == ctype) {
            dict.ComboDSType = ctinfo.ComboDSType;
            if (1 == ctinfo.ComboDSType) {
                dict.DSName = ctinfo.DSName;
                dict.KeyFieldName = ctinfo.KeyFieldName;
                dict.ShowFieldName = ctinfo.ShowFieldName;
            } else if (2 == ctinfo.ComboDSType) {
                dict.CustomComboTexts = ctinfo.CustomComboTexts;
            }
        } else if (1 == ctype) { //文本编辑框
            $("#maxsize").val(ctinfo.MaxLength == -1 ? "" : ctinfo.MaxLength);
            $("#minsize").val(ctinfo.MinLength == -1 ? "" : ctinfo.MinLength);
        } else if (8 == ctype) { //
            $('#allowDecimal').prop('checked', ctinfo.AllowDecimal);
            $('#allowNegative').prop('checked', ctinfo.AllowNegative);
            $('#maxnum').val(ctinfo.MaxValue == -1 ? "" : ctinfo.MaxValue);
            $('#minnum').val(ctinfo.MinValue == -1 ? "" : ctinfo.MinValue);
            $('#autonum').val(ctinfo.decimalPlace == -1 ? "" : ctinfo.decimalPlace);
        } else if (9 == ctype) {
            $('#btntext').val(ctinfo.ButtonText);
            $('#btntype').dropdown('set selected' , ctinfo.ButtonType + '');
            $('#addButJs').prev().val(ctinfo.ButtonJS);
            if (2 == ctinfo.ButtonType) {
                $('#firstCell').hide();
            } else {
                $('#firstCell').show();
            }
            $('#dyg1').val(canvasEvent.Util.int2CellX(ctinfo.FirstCellX));
            $('#dyg2').val(ctinfo.FirstCellY);
        } else if (7 == ctype) {
            $('#cktext').val(ctinfo.ShowText);
        } else if (6 == ctype) {
            $('#showdate').prop('checked', ctinfo.HasTime);
            if (ctinfo.DateType == undefined) { //兼容之前的时间控件，没有时间格式
                if (ctinfo.HasTime) {
                    $('#dateTimeType').show();
                    $('#dateType').hide();
                    $('#dateTimeType').dropdown('set selected' , '0');
                } else {
                    $('#dateTimeType').hide();
                    $('#dateType').show();
                    $('#dateType').dropdown('set selected' , '0');
                }
            } else {
                if (ctinfo.HasTime) {
                    $('#dateTimeType').show();
                    $('#ef-dateTime-div').show();
                    $('#ef-date-div').hide();
                    $('#dateTimeType').dropdown('set selected' , ctinfo.DateType);
                } else {
                    $('#ef-dateTime-div').hide();
                    $('#ef-date-div').show();
                    $('#dateType').dropdown('set selected' , ctinfo.DateType);
                }
            }

        } else if (11 == ctype) {
            $('#filesize').val(ctinfo.SizeLimit == -1 ? "" : ctinfo.SizeLimit);
            $('#filetype').val(ctinfo.FileType);
           /* $('#showPic').prop('checked', ctinfo.ShowPic);*/
        }
    } else {
        $("#ef_control").dropdown('set selected' ,'0');
        $('div[id^="controlInfo"]').hide();
    }
}

//初始化悬浮元素属性
function initShapeProp() {
    let shapeName = canvasEvent.Shape.getSelShapeName();
    $('#shapeName').val(shapeName);

    let x = canvasEvent.Shape.getSelShapeX();//x坐标
    if (typeof x === 'number' && x % 1 !== 0) {
        x = parseFloat(x.toFixed(1));
    }
    $('#xPost').val(x);
    let y = canvasEvent.Shape.getSelShapeY();//y坐标
    if (typeof y === 'number' && y % 1 !== 0) {
        y = parseFloat(y.toFixed(1));
    }
    $('#yPost').val(y);
    let width = canvasEvent.Shape.getSelShapeWidth();//宽度
    if (typeof width === 'number' && width % 1 !== 0) {
        width = parseFloat(width.toFixed(1));
    }
    $('#sWidth').val(width);
    let height = canvasEvent.Shape.getSelShapeHeight();//高度
    if (typeof height === 'number' && height % 1 !== 0) {
        height = parseFloat(height.toFixed(1));
    }
    $('#sHeight').val(height);
    let sText = canvasEvent.Shape.getSelShapeText(); //悬浮元素文本
    $('#sText').val(sText);
    //颜色，字体
    let fontColor = canvasEvent.Shape.getSelShapeFontColor(); //文本颜色
    let font = canvasEvent.Shape.getSelShapeFont(); //获取文本字体
    //悬浮元素是否可见
    let isSelShapeVisible = canvasEvent.Shape.isSelShapeVisible();
    if (isSelShapeVisible == 1) {
        $('#isSelShapeVisible').prop('checked', true);
    } else {
        $('#isSelShapeVisible').prop('checked', false);
    }

    $('#lineColorDiv1').css('background-color', '#000000');
    $('#lineColorText1').text('#000000');


    $('div[name="borderAlign_d1"]').removeClass('fx');

    //水平对齐方式
    let alignH = canvasEvent.Shape.getSelShapeAlignH();
    if(alignH == 0){
        $('#horAlignS').dropdown('set selected' , '4');
    }else{
        if(alignH == 1){
            $('#horAlignS').dropdown('set selected' , '1');
        }else if(alignH == 4){
            $('#horAlignS').dropdown('set selected' , '4');
        }else{
            $('#horAlignS').dropdown('set selected' , '2');
        }
    }

    //垂直对齐方式
    let alignV = canvasEvent.Shape.getSelShapeAlignV();

    if(alignV == 0){
        $('#verAlignS').dropdown('set selected' , '64');
    }else{
        if(alignV == 16){
            $('#verAlignS').dropdown('set selected' , '16');
        }else if(alignV == 64){
            $('#verAlignS').dropdown('set selected' , '64');
        }else{
            $('#verAlignS').dropdown('set selected' , '32');
        }
    }

    let animationType = canvasEvent.Shape.getSelShapeAniType();
    if(animationType == ""){
        $('#animationS').dropdown('set selected' , "none");
    }else{
        $('#animationS').dropdown('set selected' , animationType);
    }

    //图片缩放
    let isSelShapeAdaptImageSize = canvasEvent.Shape.isSelShapeAdaptImageSize();
    $("#imgsfS").prop("checked", isSelShapeAdaptImageSize);
    if (isSelShapeAdaptImageSize) {
        $("#imgkeepS").removeAttr('disabled');
        //保持原比例
        let isSelShapeRawImageScale = canvasEvent.Shape.isSelShapeRawImageScale();
        $("#imgkeepS").prop("checked", isSelShapeRawImageScale);
    } else {
        $("#imgkeepS").attr('disabled', true);
        $("#imgkeepS").prop("checked", false);
    }



}

function initCell(){
    let cellType = canvasEvent.Cell.getSelCellsType(); //单元格类型
    let cellStyle = canvasEvent.Cell.getSelCellsStyle(); //单元格样式
    let line = canvasEvent.Cell.getSelCellLineStyle();
    let dsName = canvasEvent.Cell.getDSName(); //数据集名称
    let columnName = canvasEvent.Cell.getFieldName(); //获取字段名
    let dataType = canvasEvent.Cell.getFieldDataType(); //获取数据类型
    let dataAttribution = canvasEvent.Cell.getDataAttribution(); //获取数据设置
    let dataStatisticsType = canvasEvent.Cell.getDataStatisticsType(); //获取汇总方式
    let minRecordCount = canvasEvent.Cell.getMinRecordCount();
    /**
     * 数据设置
     * **/
    if (dsName != "") {
        let templateIndex = canvasEvent.Template.getCurrentSpreadSheetIndex(); //获取当前模板索引值
        let key = templateIndex + '@#' + dsName; //获取键值
        let columns = dsMap[key]; //获取列值
        $('#dscol').empty();
        $('#cellds').dropdown('set selected' , dsName);
        /*manualChange($('#cellds') , dsName , dsName);*/
        $('#dscol').attr('disabled', false);
        //遍历列并设置选中状态
        if (columns != undefined) {
            let columnArray = [];
            $.each(columns, function (i, e) {
                let columnObj = {};
                columnObj.value = e;
                columnObj.name = e;
                columnArray.push(columnObj);
            })
            $('#dscol').dropdown('setup menu', {values:columnArray});
            $('#dscol').parent().removeClass('disabled');
            $('#dscol').dropdown('set selected' , columnName);
        }

    } else { //非数据集字段
        $('#cellds').dropdown('clear');
        $('#dscol').dropdown('clear');
        $('#dscol').parent().addClass('disabled');
    }
    //设置数据类型
    $('#dstype').dropdown('set selected' , dataType);

    //数据设置
    if(dataAttribution == 0){ //没有设置
        $('#attri').dropdown('clear');
        $('#statistics').dropdown('setting', 'useLabels', true)
            .addClass('disabled');
        $('#statistics').dropdown('clear');
    } else if (dataAttribution == 3) { //汇总
        $('#attri').dropdown('set selected' , dataAttribution);
        $('#statistics').dropdown('setting', 'useLabels', true)
            .removeClass('disabled');
        $('#statistics').dropdown('set selected' , dataStatisticsType);
    } else { //非汇总
        $('#attri').dropdown('set selected' , dataAttribution);
        $('#statistics').dropdown('setting', 'useLabels', true)
            .addClass('disabled');
        $('#statistics').dropdown('clear');
    }
    /**
     * 数据字典
     * **/
    let dictDsName = canvasEvent.Cell.getDataDictDsName();
    if (dictDsName == "") {
        $('#d_dict').prop('checked', false);
        $('#d_ds').dropdown('setting', 'useLabels', true)
            .addClass('disabled');
        $('#d_af').dropdown('setting', 'useLabels', true)
            .addClass('disabled');
        $('#d_sf').dropdown('setting', 'useLabels', true)
            .addClass('disabled');
        manualClear($('#d_ds'));
        manualClear($('#d_sf'));
        manualClear($('#d_af'));
    } else {
        $('#d_dict').prop('checked', true);
        $('#d_ds').dropdown('setting', 'useLabels', true)
            .removeClass('disabled');
        $('#d_af').dropdown('setting', 'useLabels', true)
            .removeClass('disabled');
        $('#d_sf').dropdown('setting', 'useLabels', true)
            .removeClass('disabled');

        //manualChange($('#d_ds') , dictDsName , dictDsName);
        $('#d_ds').dropdown('set selected' , dictDsName);
        let templateIndex = canvasEvent.Template.getCurrentSpreadSheetIndex(); //获取当前模板索引值

        let key = templateIndex + '@#' + dictDsName;
        let columns = dsMap[key];

        let dataArray = [];
        $.each(columns, function (i, e) {
            let dataObj = {};
            dataObj.name = e;
            dataObj.value = e;
            dataArray.push(dataObj);
        })
        //setup menu
        $('#d_af').dropdown('setup menu', {values: dataArray});
        $('#d_sf').dropdown('setup menu', {values: dataArray});
        //reset
        let actualField = canvasEvent.Cell.getActualFieldName();
        manualChange($('#d_af') , actualField , actualField);
        //reset
        let showField = canvasEvent.Cell.getShowFieldName();
        manualChange($('#d_sf') , showField , showField);
    }

    /**
     * 扩展方向
     * **/
    initKz();
    /**
     * 字段分页补齐
     * */
    let pagingFieldRowCount = canvasEvent.Cell.getPagingFieldRowCount();
    $('#pagingFieldRowCount').val(pagingFieldRowCount);
    
    let fieldPaging = canvasEvent.Cell.isFieldPaging();//分页
    $('#fg').prop('checked', fieldPaging);

    let pagingAfterRow = canvasEvent.Cell.isPagingAfterRow(); //行后分页
    $('#far').prop('checked', pagingAfterRow);

    let completeRowForEveryPage = canvasEvent.Cell.isCompleteRowForEveryPage(); //每页补齐行
    $('#crfs').prop('checked', completeRowForEveryPage);

    let completeRowForLastPage = canvasEvent.Cell.isCompleteRowForLastPage(); //尾页补齐行
    $('#crfl').prop('checked', completeRowForLastPage);

    /**
     * 图片字段
     * */

    let imageField = canvasEvent.Cell.isImageField(); //图片字段
    if(imageField == 0){
        $('#imageField').prop('checked', false);
        $('#imagePathStr').attr('disabled', true);
        $('#imagePathStr').val("");
    }else{
        $('#imageField').prop('checked', true);
        $('#imagePathStr').attr('disabled', false);
        $('#imagePathStr').parent().removeClass('disabled');
        let imagePathStr = canvasEvent.Cell.imagePathStr();
        $('#imagePathStr').val(imagePathStr);
    }

    /**
     * 伸展设置
     * **/
        //横向扩展
    let hxkz = canvasEvent.Cell.isSelCellExtendH();
    $('#hxkz').prop("checked", hxkz);
    //纵向扩展
    let zxkz = canvasEvent.Cell.isSelCellExtendV();
    $('#zxkz').prop("checked", zxkz);

    /**
     * 分栏设置
     * */
    let expandByIsMutliColumn = canvasEvent.Cell.isExpandByMutliColumn(); //是否分栏
    let json = JSON.parse(expandByIsMutliColumn);
    let ismulti = json.isMutliColumn;
    let isColumnFirst = json.isColumnFirst;
    let num = json.colCount;
    $('#multi').prop('checked', ismulti);
    if (ismulti) {
        $('#cf').attr('disabled', false);
        $('#cf').prop('checked', isColumnFirst);
        $('#cf').parent().removeClass('disabled');
        $('#num').attr('disabled', false);
        $('#num').parent().removeClass('disabled');
        $('#num').val(num);
    } else {
        $('#cf').attr('disabled', true);
        $('#cf').prop('checked', false);
        $('#num').attr('disabled', true);
        $('#num').val("");
    }

    /**
     * 空值0值
     * */
    //显示0值
    let showZero = canvasEvent.Cell.isSelCellShowZero();
    $('#showZero').prop("checked", showZero);

    //空值显示值
    let nullConvertValue = canvasEvent.Cell.getSelCellNullConvertStr();
    $('#nullConvertValue').val(nullConvertValue);
    /**
     * 折叠
     * */
    // 开启折叠
    let isRetractSubCell = canvasEvent.Cell.isRetractSubCell();
    $('#zd').prop('checked', isRetractSubCell);
    // 显示最后行
    let isShowLastSubCell = canvasEvent.Cell.isShowLastSubCell();
    $('#lasts').prop('checked', isShowLastSubCell);

    /**
     * 特殊
     * */
        //排序
    let orderType = canvasEvent.Cell.getOrderType();
    let orderText;
    if(orderType == 0){
        orderText = '不排序'
    }else if(orderType == 1){
        orderText = '升序'
    }else{
        orderText = '降序'
    }
    manualChange( $('#px') , orderType , orderText);

    //隐藏单元格
    let hidec = canvasEvent.Cell.isSelCellHided();
    $('#hidec').prop("checked", hidec);
    // 允许编辑
    let isSelCellForceAllowedEdit = canvasEvent.Cell.isSelCellForceAllowedEdit();
    $('#lockCell').prop('checked', isSelCellForceAllowedEdit);
    // 拆分并拷贝
    let isDemergeAndCopyCell = canvasEvent.Cell.isDemergeAndCopyCell();
    $('#demergeAndCopyCell').prop('checked', isDemergeAndCopyCell);

    let mergeExpandCellStr = canvasEvent.Cell.getMergeExpandCellStr();
    $('#mergeExpandCellStr').prop('checked', mergeExpandCellStr);

    let selCellDataAttrListToGroup = canvasEvent.Cell.getCellDataAttrListToGroup();
    $('#listToGroup').prop('checked', selCellDataAttrListToGroup);

    let autoHiddenComment = canvasEvent.Cell.getSelCellCommentHide();
    $('#autoHiddenComment').prop('checked', autoHiddenComment);
    //设置最小行数
    $('#minr').val(minRecordCount);


    let selCellMoveAlign = canvasEvent.Cell.getSelCellMoveAlign();
    $('#cellPosAlign').val(selCellMoveAlign).prop('selected' , true);
}

//初始化样式
function initStyle(){
    let cellType = canvasEvent.Cell.getSelCellsType();
    let cellStyle = canvasEvent.Cell.getSelCellsStyle();
    if (cellType > 1) { //存在单元格样式
        $("#fmt_val").parent().removeClass('disabled');
        let dataArray = [];
        let val = cellType;
        $('#fmt').dropdown('set selected' , val);
        let enums;
        if (2 == val) {
            enums = CellConstant.Number;
        } else if (4 == val) {
            enums = CellConstant.DateType;
        } else if (5 == val) {
            enums = CellConstant.TimeType;
        } else if (6 == val) {
            enums = CellConstant.Currency;
        } else if (8 == val) {
            enums = CellConstant.Percent;
        } else if (10 == val) {
            enums = CellConstant.BarCodeType;
        } else if(3 == val){
            $("#fmt_val").empty();
            $("#fmt_val").dropdown('clear');
            $("#fmt_val").parent().addClass('disabled');
            $("#fmt_val").parent().find('.text').empty();
        }

        if(val != 3){
            for (var i in enums) {
                let dataObj = {};
                dataObj.name = enums[i];
                dataObj.value = i;
                dataArray.push(dataObj);
                $("#fmt_val")
                    .dropdown('setup menu', {values:dataArray});
            }
        }

        if (val == 10) {
            let barCode = canvasEvent.Cell.getSelCellsBarCodeType();
            $('#fmt_val').dropdown('set selected' , barCode + '');
        } else {
            if(val != 3){
                $('#fmt_val').dropdown('set selected' , cellStyle + '');
            }
        }
    } else {
        $("#fmt_val").empty();
        $("#fmt_val").dropdown('clear');
        $("#fmt_val").parent().addClass('disabled');
        $('#fmt').dropdown('set selected' , '1');
    }
    //水平对齐方式
    let alignH = canvasEvent.Cell.getSelCellAlignH();
    if(alignH == 0){
        $('#horAlign').dropdown('set selected' , '4');
    }else{
        if(alignH == 1){
            $('#horAlign').dropdown('set selected' , '1');
        }else if(alignH == 4){
            $('#horAlign').dropdown('set selected' , '4');
        }else{
            $('#horAlign').dropdown('set selected' , '2');
        }
    }

    //垂直对齐方式
    let alignV = canvasEvent.Cell.getSelCellAlignV();

    if(alignV == 0){
        $('#verAlign').dropdown('set selected' , '64');
    }else{
        if(alignV == 16){
            $('#verAlign').dropdown('set selected' , '16');
        }else if(alignV == 64){
            $('#verAlign').dropdown('set selected' , '64');
        }else{
            $('#verAlign').dropdown('set selected' , '32');
        }
    }

   /* let heightFlag = false;
    let widthFlag = false;*/
    //是否自适应行高
    let isAdaptTextHeight = canvasEvent.Cell.isSelCellAdaptTextHeight();
   /* if (isAdaptTextHeight) {
        manualChange($('#adapt') , '2' , '自适应行高')
        heightFlag = true;
    }*/
    //是否自适应列宽
    let isAdaptTextWidth = canvasEvent.Cell.isSelCellAdaptTextWidth();
   /* if (isAdaptTextWidth) {
        manualChange($('#adapt') , '2' , '自适应列宽')
        widthFlag = true;
    }*/
    if(isAdaptTextHeight){
        $('#adapt').dropdown('set selected' , '2');
    }else if(isAdaptTextWidth){
        $('#adapt').dropdown('set selected' , '3');
    }else{
        $('#adapt').dropdown('set selected' , '1');
    }
    //行间距
    let lineSpacing = canvasEvent.Cell.getSelCellLineSpacing();
    $('#lineSpacing').val(lineSpacing == 0 ? "" : lineSpacing);
    //字符间距
    let letterSpacing = canvasEvent.Cell.getSelCellLetterSpacing();
    $('#letterSpacing').val(letterSpacing == 0 ? "" : letterSpacing);
    //段落空格数
    let paragraphSpaceCount = canvasEvent.Cell.getSelCellParagraphSpaceCount();
    $('#paragraphSpaceCount').val(paragraphSpaceCount == 0 ? "" : paragraphSpaceCount);
    //上边距
    let topMargin = canvasEvent.Cell.getSelCellTopMargin();
    $('#topMargin').val(topMargin == 0 ? "" : topMargin);
    //下边距
    let bottomMargin = canvasEvent.Cell.getSelCellBottomMargin();
    $('#bottomMargin').val(bottomMargin == 0 ? "" : bottomMargin);
    //左边距
    let leftMargin = canvasEvent.Cell.getSelCellLeftMargin();
    $('#leftMargin').val(leftMargin == 0 ? "" : leftMargin);
    //右边距
    let rightMargin = canvasEvent.Cell.getSelCellRightMargin();
    $('#rightMargin').val(rightMargin == 0 ? "" : rightMargin);
    //图片水平
    let imgalignH = canvasEvent.Cell.getSelCellImageAlignX();
    $('#imghAlign').dropdown('set selected' , imgalignH + '');
    //图片垂直
    let imgalignV = canvasEvent.Cell.getSelCellImageAlignY()
    $('#imgvAlign').dropdown('set selected' , imgalignV + '');
    //图片缩放
    let isSelCellAdaptImageSize = canvasEvent.Cell.isSelCellAdaptImageSize();
    $("#imgsf").prop("checked", isSelCellAdaptImageSize);
    if (isSelCellAdaptImageSize) {
        $("#imgkeep").removeAttr('disabled');
        //保持原比例
        let isSelCellRawImageScale = canvasEvent.Cell.isSelCellRawImageScale();
        $("#imgkeep").prop("checked", isSelCellRawImageScale);
    } else {
        $("#imgkeep").attr('disabled', true);
        $("#imgkeep").prop("checked", false);
    }



    //重置边框属性
    $("div[name='borderAlign_d']").removeClass('fx');

    //边框颜色
    $('#linecolor').css('background-color', '#F2F3F5');
    $('#lineColorDiv').css('background-color', '#000000');
    $('#lineColorText').text('#000000');
    //样式
    $('#ckline').find('div').find('img').attr('src', 'images/design/line/l1.png');
    $('#ckline').find('div').find('img').attr('val', 1);
}

function initKz(){
    let expandOri = canvasEvent.Cell.getExpandOri();
    $('#kzfx').dropdown('set selected' , expandOri + '');
    //获取左父格类型
    let leftParentCellType = canvasEvent.Cell.getLeftParentCellType();
    $('#zfg').dropdown('set selected' , leftParentCellType + '');
    //manualChange($('#zfg') , leftParentCellType , leftType);
    if (2 == leftParentCellType) {
        let leftParentCell = canvasEvent.Cell.getLeftParentCell(); //获取左父格单元格
        leftParentCell = JSON.parse(leftParentCell);
        $("#zfgS").removeClass('ef-hidden');
        $("#zfgA").val(canvasEvent.Util.int2CellX(leftParentCell.x));
        $("#zfg1").val(leftParentCell.y == 0 ? '' : leftParentCell.y);
    } else {
        $('#zfgS').removeClass('visible');
        $("#zfgS").addClass('ef-hidden');
        $("#zfgA").val('');
        $("#zfg1").val('');
    }

    //获取上父格类型
    let TopParentCellType = canvasEvent.Cell.getTopParentCellType();
    $('#sfg').dropdown('set selected' , TopParentCellType + '');
    if (2 == TopParentCellType) {
        let topParentCell = canvasEvent.Cell.getTopParentCell(); //获取左父格单元格
        topParentCell = JSON.parse(topParentCell);
        $("#sfgS").removeClass('ef-hidden');
        $("#sfgA").val(canvasEvent.Util.int2CellX(topParentCell.x));
        $("#sfg1").val(topParentCell.y == 0 ? '' : topParentCell.y);
    } else {
        $('#sfgS').removeClass('visible');
        $("#sfgS").addClass('ef-hidden');
        $("#sfgA").val('');
        $("#sfg1").val('');
    }
}