# 报表公式制作交叉报表

说明：一些复杂的交叉报表需要多个不同表中的数据集进行汇总统计，使用筛选方式可以制作出相应的交叉报表，还可以使用公式的方式进行制作。

在插入的公式中有"DSGETDATA(数据集,取值的字段,条件1,\...,默认值)"函数，根据条件获取数据集中的取值字段，如条件不满足返回默认值。条件中可以使用公式，格式为"(=具体的公式)。通过扩展的字段再加上次函数，可筛选出不同数据集中的数据，达到交叉报表的效果。

具体模板内容可参照设计器中"特殊公式扩展"模板。

第一步：添加数据源

数据源区点击数据集新增按钮，在数据集编辑框中输入："select id,no,num from
供应商物料"，添加数据源"供应商物料"。

数据源区点击数据集新增按钮，在数据集编辑框中输入："select
id,date,dayInNum,dayOutNum from 物料总数量"，添加数据源"本月总数量"。

数据源区点击数据集新增按钮，在数据集编辑框中输入："select date as days
from 物料总数量 group by date order by date"，添加数据源"结转周期"。

第二步：制作工作表

设置表格样式，并将"结转周期"数据集中的"days"字段拖拽到"E2"单元格上，在右侧属性"单元格"-\>"字段扩展"中，扩展属性设置为"横向"。

![报表公式制作交叉报表_1](images/报表公式制作交叉报表_1.png)

将"E3"、"F3"单元格分别设置上父格为"E2"。

![报表公式制作交叉报表_2](images/报表公式制作交叉报表_2.png)

数据集"供应商物料"内的字段"id"、"no"、"num"分别拖拽到相应的位置上，再在"A4"单元格设置编号（具体步骤参考[制作编号报表](/docs/制作编号报表.md)）。

![报表公式制作交叉报表_3](images/报表公式制作交叉报表_3.png)

在"E4"单元格插入公式，"=DSGETDATA(\"本月总数量\",\"dayInNum\",\"id=B4\",\"date=E2\",0)"，设置左父格为"B4"，上父格为"E2"。在"F4"单元格插入公式，"=DSGETDATA(\"本月总数量\",\"dayOutNum\",\"id=B4\",\"date=E2\",0
)"，同样设置左父格为"B4"，上父格为"E2"。

![报表公式制作交叉报表_4](images/报表公式制作交叉报表_4.png)

至此使用"DSGETDATA"公式来制作交叉的方式完毕。点击菜单"模板"-\>"模板属性"，"基本属性"中勾选"是否一页显示"，点击预览可查看效果。

![报表公式制作交叉报表_5](images/报表公式制作交叉报表_5.png)

  第三步：扩展功能

点击工具栏中"冻结"按钮，可设置固定行列，达到EXCEL冻结功能，此功能需要在模板属性"表格插件属性"中勾选"使用表格插件显示"。再在最下面一行做一个统计值，分别将"E5"、"F5"的上父格指向"E2"。

![报表公式制作交叉报表_6](images/报表公式制作交叉报表_6.png)

  第四步：预览效果图

再次点击工具栏的预览按钮，预览效果。EXCEL冻结效果的交叉报表生成。

![报表公式制作交叉报表_7](images/报表公式制作交叉报表_7.png)

  第五步：保存模板

保存模板，模板重命名。

<font color="red">注意：DSGETDATA()函数在使用中，如果模板设置了多线程取数，此函数里面的参数不能再有其他的公式引用，使用的单元格内容同样不能再有公式。</font>