# 使用报表参数

说明：如何给报表加入变量，通过选择的条件展示报表的内容，这里需要用到报表参数。本课程以"员工信息"表为示例，按照年龄段来查找员工信息。

具体模板内容可参照设计器中"参数文本编辑"模板。

第一步：认识报表参数

单击菜单栏"模板"-\>"模板参数"，弹出模板参数设置对话框。

![使用报表参数_1](images/使用报表参数_1.png)

新增：增加一个报表参数。

删除：删除一个报表参数。

名称：报表参数的名称，可以用名称来做变量。

默认值：名称所对应的值。

数据类型：有字符串、整型、浮点、日期、布尔5种类型。

联动参数：是否联动其他参数，目前只支持"下拉框"类型。

是否必填：预览时，此参数是否是必填项。

下方留白像素：预览时参数整体位置与报表之间的留白像素。

控件类型：控件类型有文本编辑框、下拉框、多选下拉框、下拉树、多选下拉树、日期编辑框、日期时间编辑框、复选框、自定义下拉框列表等9种控件类型。

控件名称：预览时，控件显示的名称。

第二步：添加数据源

数据源区点击数据集新增按钮，在数据集编辑框中输入："select \* from
员工信息"，添加数据源"ds1"。

第三步：建立工作表

数据源"ds1"中的数据集全部拖入工作表，在相应数据单元格上方输入名册，设置文本居中、加入边框。为了方便查看年龄，在数据集的最左边加入"年龄"数据集，在属性栏"单元格"-\>"特殊"中，排序属性选择"升序"。

![使用报表参数_2](images/使用报表参数_2.png)

点击B列，右键"修改列宽"，设置列宽为0，达到隐藏B列效果。

第四步：设置模板参数

点击菜单栏"模板"-\>"模板参数"，弹出模板参数设置对话框。点击新建模板参数，名称为"age1"，"默认值"设置"25"，"数据类型"选择"整型"，"控件类型"设置为"文本编辑框"，"控件名称"设置为"最小年龄"。

点击新建模板参数，名称为"age2"，"默认值"设置"40"，"数据类"型选择"整型"，"控件类型"设置为"文本编辑框"，"控件名称"设置为"最大年龄"。

![使用报表参数_3](images/使用报表参数_3.png)

  第五步：使用模板参数

选中数据源"ds1"，在数据源区点击，弹出数据源编辑窗口。原来的语句是："select
\* from 员工信息"，现修改成： "select \* from 员工信息 where
年龄\>=@{age1} and 年龄\< =@{age2
}"，在报表中使用"@{参数名称}"来表示变量。

第六步：预览效果图

点击工具栏的预览按钮，预览效果。输入年龄显示不同年龄段的员工信息。

![使用报表参数_4](images/使用报表参数_4.png)

第六步：保存模板

保存模板，模板重命名。

<font color="red">注意：参数格式必须以字母（大小写）或下划线开头，由字母、数字、下划线组成。不建议用全大写字母加数字格式，如：A1，B1，容易与单元格混淆。

在模板参数设置成下拉树或多选下拉树时，子层设置数据源的格式可通过特殊参数指定。</font>

![使用报表参数_5](images/使用报表参数_5.png)

![使用报表参数_6](images/使用报表参数_6.png)

<font color="red">如图，"层次1"的数据源是"ds2"，"ds2"的数据源语句是"select 省份 from
城市销量 group by
省份"。"层次2"的数据源是"ds3"，"ds3"的数据源语句是"select 城市 from
城市销量 where 省份 =\'@{parentNodeValue}\' group by 城市" 。</font>

![使用报表参数_7](images/使用报表参数_7.png)

![使用报表参数_8](images/使用报表参数_8.png)

<font color="red">其中@{parentNodeValue}代表的是"层次1"实际数据源的数据值。

\@{parentNodeValue}参数只在此处使用有效果。其他地方使用此数据源无效。具体模板内容可参照设计器中"参数下拉树单选"模板。</font>