/**
 *
 * 生成普通Form表单
 *
 * **/

function initForm(tableId, sheetInfo) {

    let tableHtml =
        "<div class='x-data-bg_block show'>" +
        "<table id='" + tableId + "' stable='1' class='x-table' sheetname='" + sheetInfo.SheetName + "'" + "cellspacing='0'  cellpadding='0'>"
        + "</table>"
        + "</div>";
    $('#content').append(tableHtml);

    $('#' + tableId).hide(); //隐藏DOM元素，渲染效率更高

    let pages = reportJson.Pages;
    let page0 = pages[0];

    let totalFWidth = page0.FormW; //form的总宽度
    let totalFHeight = page0.FormH;//form的总高度
    //设置背景图片
    if (reportJson.hasOwnProperty("WebBKImage")) {
        bgImg = reportJson.WebBKImage.split("/");
        let type = reportJson.SheetBKImageStretchType;
        if (type == 0) { //背景图片类型
            $('.content').css({
                "background-image": "url('" + (base + '/export' + "/" + bgImg[bgImg.length - 2]) + "/" + bgImg[bgImg.length - 1] + "')",
                "background-repeat": "no-repeat",
                "background-position": "0 0",
                "background-size": "100% 100%"
            });
        } else if (type == 1) { //平铺
            $('.content').css({
                "background-image": "url('" + (base + '/export' + "/" + bgImg[bgImg.length - 2]) + "/" + bgImg[bgImg.length - 1] + "')",
                "background-repeat": "repeat",
            });
        } else { //居中
            $('.content').css({
                "background-image": "url('" + (base + '/export' + "/" + bgImg[bgImg.length - 2]) + "/" + bgImg[bgImg.length - 1] + "')",
                "background-repeat": "no-repeat",
                "background-position": "center center",
            });
        }
        /* $('#content').css({
             "background-image": "url('" + (base + "/export/" + bgImg[bgImg.length - 2]) + "/" + bgImg[bgImg.length - 1] + "')",
             "background-repeat": "no-repeat",
             "background-position": "0 0",
             "background-size": "100% 100%"
         });*/
    } else {//无背景图片时，设置背景颜色
        if (reportJson.hasOwnProperty("WebBKColor")) { //whj
            //$('body').css("background-color", reportJson.WebBKColor);
            $('#content').css("background-color", reportJson.WebBKColor); //whj
        }
    }
    //显示参数工具栏
    if (reportJson.ShowParamToolBar) {
        $('#ef-normal-param').show();
    }
    //显示普通工具栏
    if (reportJson.ShowToolBar) {
        $('#tool').show();
    }


    let shapes = page0.Shapes; //所有的悬浮元素
    initShapes(shapes, 1, 1, tableId);

    //渲染轮播图
    $.each(carouselMap, function (k, v) {
        if(v.interval == undefined || v.interval == 0){
            //渲染轮播
            carousel.render({
                elem: '#' + k,
                width: '100%', //设置容器宽度
                arrow: 'hover', //始终显示箭头
                autoplay: false,
                height: v['height']
            });
        }else{
            //渲染轮播
            carousel.render({
                elem: '#' + k,
                width: '100%', //设置容器宽度
                arrow: 'hover', //始终显示箭头
                interval: v['interval'],
                height: v['height']
            });
        }

    });

    setContentHeight(); //设置内容区高度

    $('#' + tableId).show();
}

//生成悬浮元素
function initShapes(shapes, hRatio, vRatio, tableId) {
    //遍历悬浮元素
    $.each(shapes, function (index, element) {
        //随机生成悬浮元素ID
        let id = randomUUID();
        let width = element.Width * hRatio; //悬浮元素宽度
        let height = element.Height * vRatio; //悬浮元素高度
        let HtmlFile = element.HtmlFile; //Html文件
        let x = element.X * hRatio; //x轴位置
        let y = element.Y * vRatio; //y轴位置
        let text = element.Text; //悬浮元素文本
        let html;
        let borderStyle = '';
        let visible = element.Visible; //悬浮元素是否可见
        let display = 'flex';
        let aniType = element.AniType;
        let aniCss = "";
        if(aniType != undefined && aniType != 'none'){
            aniCss = "animate__animated animate__" + aniType;
        }
        if (visible != undefined) {
            display = 'none';
        }

        if (element.BW != undefined) { //边框
            borderStyle = 'border-style:solid;border-width:' + element.BW + 'px;border-color:' + element.BC + ';box-sizing:border-box;';
        }
        //有插件
        if (element.HtmlFile != undefined) {
            if (element.HtmlFile.endsWith(".html")) {
                html = '<div type="plugin" id="' + id + '" class="shape '+ aniCss +'" sname="' + element.Name + '" style="' + borderStyle + 'background-color:' + element.BKC + ';position:absolute;width:' + width + 'px;height:' + height + 'px;left:' + x + 'px;top:' + y + 'px;z-index:' + (element.Z - 200) + ';display:' + display + ';">' +
                    '       <iframe id="fra_' + id + '" oh="' + height + '" ow="' + width + '" src="' + base + '/export/' + HtmlFile + '" style="width:' + width + 'px;height:' + height + 'px;" frameborder=0 scrolling=no>' +
                    '       </iframe>' +
                    '   </div>'
                $('#' + tableId).parent().append(html);
            } else {
                html = '<div type="plugin" id="' + id + '" class="shape '+ aniCss +'" sname="' + element.Name + '" style="' + borderStyle + 'background-color:' + element.BKC + ';position:absolute;width:' + width + 'px;height:' + height + 'px;left:' + x + 'px;top:' + y + 'px;z-index:' + (element.Z - 200) + ';display:' + display + ';">' +
                    '   </div>'
                $('#' + tableId).parent().append(html);
                loadPlugin(base + '/export/' + HtmlFile, id);
            }

        } else { //没有插件
            if (element.SN != undefined) {//包含子表单
                let sheetName = element.SN;
                html = '<div id="' + id + '" class="shape '+ aniCss +'" sname="' + element.Name + '" style="' + borderStyle + 'background-color:' + element.BKC + ';position:absolute;width:' + width + 'px;height:' + height + 'px;left:' + x + 'px;top:' + y + 'px;z-index:' + (element.Z - 200) + ';display:' + display + ';">' +
                    '<table id="_tb_sheet_' + id + '" stable="1" class="x-table" sheetname="' + sheetName + '"style="border-collapse:collapse;border:none;border-spacing:2px;-webkit-border-horizontal-spacing: 2px;' +
                    '-webkit-border-vertical-spacing: 2px;table-layout: fixed;"  cellspacing="0"  cellpadding="0">' +
                    '</table></div>'
                //获取sheet数据并且渲染
                $.getJSON(base + '/report/loadJSON?' + "t=" + new Date().getTime() + "&token=" + token + '&serverId=' + serverId, {
                    file: sheetName, //子sheet名
                    pathId: pathId,
                    serverId: serverId
                }, function (data) {
                    //生成子表单
                    generateShapeSheet("_tb_sheet_" + id, data, element, width, height);
                });

            } else if (element.SNS != undefined) {//包含子表单数组

                if (element.SNS.length == 1) {
                    let sheetName = element.SNS[0];
                    html = '<div id="' + id + '" class="shape '+ aniCss +'" sname="' + element.Name + '" style="' + borderStyle + 'background-color:' + element.BKC + ';position:absolute;width:' + width + 'px;height:' + height + 'px;left:' + x + 'px;top:' + y + 'px;z-index:' + (element.Z - 200) + ';display:' + display + ';">' +
                        '<table id="_tb_sheet_' + id + '" stable="1" class="x-table" sheetname="' + sheetName + '"style="border-collapse:collapse;border:none;border-spacing:2px;-webkit-border-horizontal-spacing: 2px;' +
                        '-webkit-border-vertical-spacing: 2px;table-layout: fixed;"  cellspacing="0"  cellpadding="0">' +
                        '</table></div>'
                    //获取sheet数据并且渲染
                    $.getJSON(base + '/report/loadJSON?' + "t=" + new Date().getTime() + "&token=" + token + '&serverId=' + serverId, {
                        file: sheetName, //子sheet名
                        pathId: pathId,
                        serverId: serverId
                    }, function (data) {
                        //生成子表单
                        generateShapeSheet("_tb_sheet_" + id, data, element, width, height);
                    });
                } else {
                    let sheetName = element.SNS;
                    html = '<div id="' + id + '" class="shape '+ aniCss +'" sname="' + element.Name + '" style="' + borderStyle + 'background-color:' + element.BKC + ';position:absolute;width:' + width + 'px;height:' + height + 'px;left:' + x + 'px;top:' + y + 'px;z-index:' + (element.Z - 200) + ';display:' + display + ';">' +
                        '</div>';
                    $('#' + tableId).parent().append(html);
                    generateShapeMultiSheet(id, element, false, width, height);
                }


            } else {//不包含子表单
                let cssText = '';
                //文本大小
                cssText += ('font-size:' + element.Font.Size + 'px;');
                //文本样式
                cssText += ('font-family:' + element.Font.Name + ';');
                //文本颜色
                cssText += ('color:' + element.Font.FC + ';');
                if (element.Font.Italic) {
                    cssText += 'font-style:italic;';
                }
                if (element.Font.Bold) {
                    cssText += 'font-weight:bold;';
                }
                if (element.Font.Underline) {
                    cssText += 'text-decoration:underline;';
                }
                if (element.AH != undefined) {
                    if (element.AH == 1) {
                        cssText += 'justify-content:flex-start;';
                    } else {
                        cssText += 'justify-content:flex-end;';
                    }
                } else {
                    cssText += 'justify-content:center;';
                }
                if (element.AV != undefined) {
                    if (element.AV == 16) {
                        cssText += 'align-items:flex-start;';
                    } else {
                        cssText += 'align-items:flex-end;';
                    }
                } else {
                    cssText += 'align-items:center;';
                }
                html = '<div id="' + id + '" class="shape '+ aniCss +'" sname="' + element.Name + '" style="' + borderStyle + 'background-color:' + element.BKC + ';' + cssText + 'display:flex;position:absolute;width:' + width + 'px;height:' + height + 'px;left:' + x + 'px;top:' + y + 'px;z-index:' + (element.Z - 200) + ';display:' + display + ';">' + (text == undefined ? '' : text) + '</div>'
            }
            if (element.SNS == undefined || element.SNS.length == 1) {
                $('#' + tableId).parent().append(html);
            }
        }


        //背景图片
        if (element.BKPic != undefined) {
            let bgImg = element.BKPic.split("/");
            let ais = element.AIS; //图片缩放
            let ris = element.RIS; //保持原比例
            let url = base + '/export/' + bgImg[bgImg.length - 2] + '/' + bgImg[bgImg.length - 1];
            if(ais == undefined){ //未设置缩放
                $('#' + id).css({
                    "background-image": "url('" + url + "?token=" + token + "')"
                })
            }else{
                if(!ais){ //非缩放
                    $('#' + id).css({
                        "background-image": "url('" + url + "?token=" + token + "')",
                        "background-repeat":"no-repeat"
                    })

                }else{ //缩放
                    if(ris){ //保持原比例
                        $('#' + id).css({
                            "background-image": "url('" + url + "?token=" + token + "')",
                            "background-size": "contain",
                            "background-repeat":"no-repeat"
                        })
                    }else{ //平铺
                        $('#' + id).css({
                            "background-image": "url('" + url + "?token=" + token + "')",
                            "background-size": "100% 100%"
                        })
                    }
                }


            }

        }

        if (element.Hyperlink != undefined) {
            $('#' + id).bind('click', function () {
                let hyperlink = JSON.parse(element.Hyperlink);
                Link.Fn.hyperlink(hyperlink);
            })
        }
    })
}

function randomUUID() {
    let d = new Date().getTime();
    if (window.performance && typeof window.performance.now === "function") {
        d += performance.now();
    }
    let uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        let r = (d + Math.random() * 16) % 16 | 0;
        d = Math.floor(d / 16);
        return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
    });

    return uuid;
}

function generateShapeSheet(tableId, data, element, width, height) {
    let table = $('#' + tableId); //表单table对象
    table.hide();
    let page = data.Pages[0];
    let rows = page.Rows; //行对象
    let columns = page.Columns;//列对象

    let rowNumber = rows.RowArray.length; //行数
    let columnNumber = columns.ColumnArray.length; //列数

    /**
     * 生成悬浮插件表单时，需要使用的是当前sheet JSON里面的ColorList，此时主Form的JSON数据中ColorList为空
     * **/
    let shapeSheetColorList = data.ColorList;
    let shapeFontList = data.FontList;

    let isSubReportKeepHVRatio = element.HVR; //是否保持横纵比
    let isShowScroll = element.SS; //是否显示滚动条
    let intervalScrollV = element.ISV; //垂直滚动间隔
    let stepScrollV = element.SV; //垂直滚动距离

    let scrollData = {
        StepScrollV: stepScrollV,
        IntervalScrollV: intervalScrollV
    };

    let totalTWidth = totalWidth(columns); //原始宽度
    let totalTHeight = totalHeight(rows); //原始高度
    let hRatio = horizontalFormRatio(totalTWidth, width, isSubReportKeepHVRatio, columnNumber); //水平方向拉升比例
    let vRatio = verticalFormRatio(totalTHeight, height, isSubReportKeepHVRatio, rowNumber); //垂直方向拉升比例
    if (isSubReportKeepHVRatio) { //保持横纵比
        vRatio = hRatio;
    }

    table.parent().css("overflow", "hidden"); //table的父级元素不显示滚动条
    //生成子报表Table


    let html = '';
    //生成报表Table
    for (let i = 0; i < rows.Count; i++) { //遍历行
        let trId = tableId + "_r_" + (i + 1); // 生成行ID
        let oh = rows.RowArray[i].H; //原始行高度
        let nh = Math.floor(oh * vRatio); //自适应后高度

        // 生成行tr
        html += "<tr oh='" + oh + "' attr='" + oh + "' style='height: " + nh + "px;overflow:auto;" + (0 === oh ? "display: none;" : "block") + "' id='" + trId + "'>";
        //生成单元格td
        for (let j = 0; j < columns.Count; j++) { //
            let ow = columns.ColumnArray[j].W; //单元格原始宽度
            let nw = Math.floor(ow * hRatio); //自适应后宽度
            let tdId = tableId + "_" + (i + 1) + "_" + (j + 1);//单元格ID
            // 动态生成单元格TD,高度和宽度是自适应后的高度和宽度
            html += "<td  hr='" + hRatio + "' vr='" + vRatio + "' oh='" + oh + "' ow='" + ow + "' attr='" + ow + "' style='table-layout:fixed;width: " + nw + "px;height:" + nh + "px;padding: 0;" + (0 === ow ? "display: none;" : "") + "' id='" + tdId + "' idx='" + (j + 1) + "'></td>";
        }
        html += "</tr>";
    }
    table.html(html); //渲染Table
    table.attr('rows', rows.Count);//为Table添加总行数信息
    //渲染table的每个单元格
    $.each(page.Cells, function (i, cell) {
        let cellProp = cell.N; //单元格属性
        let tdId = tableId + "_" + (cellProp[1]) + "_" + (cellProp[0]); //单元格ID
        let td = $('#' + tdId);
        let pSheetName = table.attr('sheetname'); //table对应的表单
        //存在合并单元格，先合并
        if (cell.hasOwnProperty("G")) {
            mergeWcpCell(cell, td, tableId, cellProp[0], cellProp[1], hRatio, vRatio);
        }
        initWcpFormSheetCell(td, cell, tableId, hRatio, vRatio, shapeSheetColorList, shapeFontList, data);//根据单元格内容来渲染单元格
    });

    table.show();
    if (isSubReportKeepHVRatio) { //保持横纵比
        //显示垂直滚动条
        if (isShowScroll) {
            table.parent().css('overflow-y', 'auto');
        } else {
            table.parent().css('overflow-y', 'hidden');
        }
        if (intervalScrollV > 0) { //垂直滚动时间
            contentShapeMarquee(table.parent(), scrollData);
        }
    }
}


function generateShapeMultiSheet(divId, cell, isForm, width, height) {
    // 关联子表单属性
    let sheetNames = cell.SNS; //获取单元格关联的子表单集合
    let isSubReportKeepHVRatio = cell.HVR; //子报表是否保持横纵比属性
    let isShowSubReportScrollBar = cell.SS; //是否显示垂直滚动条
    let intervalScrollH = cell.ISH; //水平滚动时间
    let stepScrollV = cell.SV; //垂直滚动像素
    let intervalScrollV = cell.ISV;

    let scrollData = {
        StepScrollV: stepScrollV,
        IntervalScrollV: intervalScrollV
    };

    let carouselId = divId + "_carousel";

    let tw;
    let th;

    tw = width;
    th = height;

    let div = $('#' + divId);

    div.attr("times", 1); //第一次初始化标识
    //外层包裹容器,这里没有使用td.height()，是因为td.height()获取的是单元格合并前TD的高度
    if (sheetNames.length > 1) {//当关联多个子表单时，添加滚动DIV
        div.empty();
        //外层DIV
        let carouselHtml;
        if (isShowSubReportScrollBar) {
            carouselHtml =
                "<div id='" + carouselId + "' class='layui-carousel' style='margin:0px;padding:0px;'>" +
                "   <div carousel-item id='car'></div>" +
                "<div>";
        } else {
            carouselHtml =
                "<div id='" + carouselId + "' class='layui-carousel' style='margin:0px;padding:0px;'>" +
                "   <div carousel-item id='car'></div>" +
                "<div>";
        }


        div.append(carouselHtml);
        let carouselProp = {}; //轮播属性
        carouselProp['height'] = th;
        carouselProp['width'] = tw;
        carouselProp['interval'] = intervalScrollH;

        // 更新轮播信息
        carouselMap[carouselId] = carouselProp;
        //将DIV动态添加到轮播DIV中
        $.each(cell.SNS, function (i, item) {
            let itemId = carouselId + "_item_" + i;
            //轮播条目
            let carouselItemDivHtml = "<div id='" + itemId + "'></div>";
            $('#' + carouselId).find('#car').append(carouselItemDivHtml);
            $('#' + itemId).css("width", tw);
            $('#' + itemId).css("height", th);
        })
    }
    $.ajaxSettings.async = false;
    //遍历子报表项目
    $.each(cell.SNS, function (i, item) {
        let itemId = carouselId + "_item_" + i;
        $.getJSON(base + '/report/loadJSON?' + "t=" + new Date().getTime() + "&token=" + token, {
            file: item, //子sheet名
            pathId: pathId,
            serverId: serverId
        }, function (data) {
            //生成子表单Table
            generateShapeSubSheetTable(divId, data, itemId, i, item, true, isSubReportKeepHVRatio, isShowSubReportScrollBar, scrollData, false);
        });
    });
    $.ajaxSettings.async = true;
}

//计算水平方向上的比例
function horizontalFormRatio(totalWidth, shapeWidth, isSubReportKeepHVRatio, columnNumber) {
    //自适应宽度/总宽度=放大比例
    if (isSubReportKeepHVRatio) {
        return shapeWidth / totalWidth;
    } else {
        return shapeWidth / (totalWidth + columnNumber);
    }
}

//计算垂直方向上的比例
function verticalFormRatio(totalHeight, shapeHeight, isSubReportKeepHVRatio, rowNumber) {
    //自适应高度/总高度=放大比例
    if (isSubReportKeepHVRatio) {
        return shapeHeight / totalHeight;
    } else {
        return shapeHeight / (totalHeight + rowNumber);
    }
}

function marquee(obj) {
    let id = obj.attr("id");
    $.each(scrollArray, function (i, e) {
        if (e.id == id) {
            let _StepScrollV = parseInt(e._StepScrollV)
            let _IntervalScrollV = e._IntervalScrollV;
            var totalScroll = Math.ceil(obj.scrollTop()); //防止出现小数导致无法回滚到头部的问题 whj
            //当滚动的距离大于表格高度和DIV高度的差值时，说明已经滚动到底，需要从头开始滚动
            if (totalScroll + +_StepScrollV >= (obj.children(":first").height() - obj.height())) {
                totalScroll = 0;
            } else {
                totalScroll += _StepScrollV;
            }
            obj.scrollTop(totalScroll);
        }
    })

}

function contentShapeMarquee(elem, data) {
    let id = elem.attr("id");
    var _StepScrollV = parseInt(data.StepScrollV);     // 滚动像素
    var _IntervalScrollV = data.IntervalScrollV;// 滚动周期
    let scrollObj = {};
    scrollObj.id = id;
    scrollObj._StepScrollV = _StepScrollV;
    scrollObj._IntervalScrollV = _IntervalScrollV;
    scrollArray.push(scrollObj);
    fn = function () {
        var totalScroll = Math.ceil(elem.scrollTop()); //防止出现小数导致无法回滚到头部的问题 whj
        //当滚动的距离大于表格高度和DIV高度的差值时，说明已经滚动到底，需要从头开始滚动
        if (totalScroll + +_StepScrollV >= (elem.children(":first").height() - elem.height())) {
            totalScroll = 0;
        } else {
            totalScroll += _StepScrollV;
        }
        elem.scrollTop(totalScroll);
    };
    //联动前已经有滚动定时器，先清除，解决滚动越来越快的问题
    let elemTimer = timerMap[id];
    clearInterval(elemTimer);
    //clearInterval(timer);
    let curTimer = setInterval(fn, _IntervalScrollV);
    timerMap[id] = curTimer;

    //悬浮在子表单上时，停止上下滚动
    elem.hover(function () {
        //当元素处于滚动状态
        if (elem.attr("scl") == undefined || elem.attr("scl") == 'start') {
            let curId = elem.attr("id");
            let elemTimer = timerMap[curId];
            clearInterval(elemTimer);
            elem.attr("scl", 'stop');
        }
        if (elem.attr("scl") == 'stop') {
            marquee(elem);
        }
    }, function () {
        if (elem.attr('scl') == 'stop') {

        }
        let curId = elem.attr("id");
        // 清除定时器,解决滚动越来越快的问题
        let elemTimer = timerMap[curId];
        clearInterval(elemTimer);
        let newTimer = setInterval(function () {
            var totalScroll = Math.ceil(elem.scrollTop()); //防止出现小数导致无法回滚到头部的问题 whj
            //当滚动的距离大于表格高度和DIV高度的差值时，说明已经滚动到底，需要从头开始滚动
            if (totalScroll + +_StepScrollV >= (elem.children(":first").height() - elem.height())) {
                totalScroll = 0;
            } else {
                totalScroll += _StepScrollV;
            }
            elem.scrollTop(totalScroll);
        }, _IntervalScrollV);
        timerMap[curId] = newTimer;
        elem.attr("scl", 'start');
    });
}


